/*
 * Decompiled with CFR 0.152.
 */
package com.amitshekhar.server;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import com.amitshekhar.model.Response;
import com.amitshekhar.utils.PrefUtils;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClientServer
implements Runnable {
    private static final String TAG = "SimpleWebServer";
    private final int mPort;
    private final AssetManager mAssets;
    private boolean mIsRunning;
    private ServerSocket mServerSocket;
    private Context mContext;
    private SQLiteDatabase mDatabase;
    private File mDatabaseDir;
    private Gson mGson;
    private boolean isDbOpenned;

    public ClientServer(Context context, int port) {
        this.mPort = port;
        this.mAssets = context.getResources().getAssets();
        this.mContext = context;
        this.mGson = new Gson();
        this.getDatabaseDir();
    }

    public void start() {
        this.mIsRunning = true;
        new Thread(this).start();
    }

    public void stop() {
        try {
            this.mIsRunning = false;
            if (null != this.mServerSocket) {
                this.mServerSocket.close();
                this.mServerSocket = null;
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error closing the server socket.", (Throwable)e);
        }
    }

    @Override
    public void run() {
        try {
            this.mServerSocket = new ServerSocket(this.mPort);
            while (this.mIsRunning) {
                Socket socket = this.mServerSocket.accept();
                this.handle(socket);
                socket.close();
            }
        }
        catch (SocketException e) {
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Web server error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(Socket socket) throws IOException {
        BufferedReader reader = null;
        PrintStream output = null;
        try {
            byte[] bytes;
            String line;
            String route = null;
            reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while (!TextUtils.isEmpty((CharSequence)(line = reader.readLine()))) {
                if (!line.startsWith("GET /")) continue;
                int start = line.indexOf(47) + 1;
                int end = line.indexOf(32, start);
                route = line.substring(start, end);
                break;
            }
            output = new PrintStream(socket.getOutputStream());
            if (route == null || route.isEmpty()) {
                route = "index.html";
            }
            if (route.startsWith("getAllDataFromTheTable")) {
                Response response;
                String query = null;
                if (route.contains("?tableName=")) {
                    query = route.substring(route.indexOf("=") + 1, route.length());
                }
                if (this.isDbOpenned) {
                    String sql = "SELECT * FROM " + query;
                    response = this.query(sql);
                } else {
                    response = this.getAllPrefData(query);
                }
                String data = this.mGson.toJson((Object)response);
                bytes = data.getBytes();
            } else if (route.startsWith("query")) {
                String query = null;
                if (route.contains("?query=")) {
                    query = route.substring(route.indexOf("=") + 1, route.length());
                }
                try {
                    query = URLDecoder.decode(query, "UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String first = query.split(" ")[0].toLowerCase();
                Response response = first.equals("select") ? this.query(query) : this.exec(query);
                String data = this.mGson.toJson((Object)response);
                bytes = data.getBytes();
            } else if (route.startsWith("getDbList")) {
                Response response = this.getDBList();
                String data = this.mGson.toJson((Object)response);
                bytes = data.getBytes();
            } else if (route.startsWith("getTableList")) {
                Response response;
                String database = null;
                if (route.contains("?database=")) {
                    database = route.substring(route.indexOf("=") + 1, route.length());
                }
                if ("APP_SHARED_PREFERENCES".equals(database)) {
                    response = this.getAllPrefTableName();
                    this.closeDatabase();
                } else {
                    this.openDatabase(database);
                    response = this.getAllTableName();
                }
                String data = this.mGson.toJson((Object)response);
                bytes = data.getBytes();
            } else {
                bytes = this.loadContent(route);
            }
            if (null == bytes) {
                this.writeServerError(output);
                return;
            }
            output.println("HTTP/1.0 200 OK");
            output.println("Content-Type: " + this.detectMimeType(route));
            output.println("Content-Length: " + bytes.length);
            output.println();
            output.write(bytes);
            output.flush();
        }
        finally {
            if (null != output) {
                output.close();
            }
            if (null != reader) {
                reader.close();
            }
        }
    }

    private void writeServerError(PrintStream output) {
        output.println("HTTP/1.0 500 Internal Server Error");
        output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadContent(String fileName) throws IOException {
        InputStream input = null;
        try {
            int size;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            input = this.mAssets.open(fileName);
            byte[] buffer = new byte[1024];
            while (-1 != (size = input.read(buffer))) {
                output.write(buffer, 0, size);
            }
            output.flush();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (FileNotFoundException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (null != input) {
                input.close();
            }
        }
    }

    private String detectMimeType(String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        if (fileName.endsWith(".html")) {
            return "text/html";
        }
        if (fileName.endsWith(".js")) {
            return "application/javascript";
        }
        if (fileName.endsWith(".css")) {
            return "text/css";
        }
        return "application/octet-stream";
    }

    private void getDatabaseDir() {
        File dbRoot;
        File root = this.mContext.getFilesDir().getParentFile();
        this.mDatabaseDir = dbRoot = new File(root, "/databases");
    }

    private void openDatabase(String database) {
        this.mDatabase = this.mContext.openOrCreateDatabase(database, 0, null);
        this.isDbOpenned = true;
    }

    private void closeDatabase() {
        this.mDatabase = null;
        this.isDbOpenned = false;
    }

    private Response exec(String sql) {
        Response response = new Response();
        try {
            this.mDatabase.execSQL(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.isSuccessful = false;
            response.error = e.getMessage();
            return response;
        }
        response.isSuccessful = true;
        return response;
    }

    private Response query(String sql) {
        Cursor cursor;
        try {
            cursor = this.mDatabase.rawQuery(sql, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Response msg = new Response();
            msg.isSuccessful = false;
            msg.error = e.getMessage();
            return msg;
        }
        if (cursor != null) {
            cursor.moveToFirst();
            Response response = new Response();
            response.isSuccessful = true;
            ArrayList<String> columns = new ArrayList<String>();
            for (int i = 0; i < cursor.getColumnCount(); ++i) {
                String name = cursor.getColumnName(i);
                columns.add(name);
            }
            response.columns = columns;
            if (cursor.getCount() > 0) {
                do {
                    ArrayList<Object> row = new ArrayList<Object>();
                    block10: for (int i = 0; i < cursor.getColumnCount(); ++i) {
                        switch (cursor.getType(i)) {
                            case 4: {
                                row.add(cursor.getBlob(i));
                                continue block10;
                            }
                            case 2: {
                                row.add(Float.valueOf(cursor.getFloat(i)));
                                continue block10;
                            }
                            case 1: {
                                row.add(cursor.getInt(i));
                                continue block10;
                            }
                            case 3: {
                                row.add(cursor.getString(i));
                                continue block10;
                            }
                            default: {
                                row.add("");
                            }
                        }
                    }
                    response.rows.add(row);
                } while (cursor.moveToNext());
            }
            return response;
        }
        Response response = new Response();
        response.isSuccessful = false;
        response.error = "Cursor is null";
        return response;
    }

    public Response getDBList() {
        Response response = new Response();
        for (String name : this.mDatabaseDir.list()) {
            response.rows.add(name);
        }
        response.rows.add("APP_SHARED_PREFERENCES");
        response.isSuccessful = true;
        return response;
    }

    public Response getAllTableName() {
        Response response = new Response();
        Cursor c = this.mDatabase.rawQuery("SELECT name FROM sqlite_master WHERE type='table'", null);
        if (c.moveToFirst()) {
            while (!c.isAfterLast()) {
                response.rows.add(c.getString(0));
                c.moveToNext();
            }
        }
        response.isSuccessful = true;
        return response;
    }

    public Response getAllPrefTableName() {
        Response response = new Response();
        List<String> prefTags = PrefUtils.getSharedPreferenceTags(this.mContext);
        for (String tag : prefTags) {
            response.rows.add(tag);
        }
        response.isSuccessful = true;
        return response;
    }

    public Response getAllPrefData(String tag) {
        Response response = new Response();
        response.isSuccessful = true;
        response.columns.add("Key");
        response.columns.add("Value");
        SharedPreferences preferences = this.mContext.getSharedPreferences(tag, 0);
        Map allEntries = preferences.getAll();
        for (Map.Entry entry : allEntries.entrySet()) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(entry.getKey());
            row.add(entry.getValue().toString());
            response.rows.add(row);
        }
        return response;
    }
}

