/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.HttpUtils;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsAsyncContext;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletInputStream;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.RequestSource;
import com.amazonaws.services.lambda.runtime.Context;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.ws.rs.core.SecurityContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsProxyHttpServletRequest
extends AwsHttpServletRequest {
    private AwsProxyRequest request;
    private SecurityContext securityContext;
    private AwsAsyncContext asyncContext;
    private static Logger log = LoggerFactory.getLogger(AwsProxyHttpServletRequest.class);
    private ContainerConfig config;

    public AwsProxyHttpServletRequest(AwsProxyRequest awsProxyRequest, Context lambdaContext, SecurityContext awsSecurityContext) {
        this(awsProxyRequest, lambdaContext, awsSecurityContext, LambdaContainerHandler.getContainerConfig());
    }

    public AwsProxyHttpServletRequest(AwsProxyRequest awsProxyRequest, Context lambdaContext, SecurityContext awsSecurityContext, ContainerConfig config) {
        super(lambdaContext);
        this.request = awsProxyRequest;
        this.securityContext = awsSecurityContext;
        this.config = config;
    }

    public AwsProxyRequest getAwsProxyRequest() {
        return this.request;
    }

    public String getAuthType() {
        return this.securityContext.getAuthenticationScheme();
    }

    public Cookie[] getCookies() {
        if (this.request.getMultiValueHeaders() == null) {
            return new Cookie[0];
        }
        String cookieHeader = (String)this.request.getMultiValueHeaders().getFirst("Cookie");
        if (cookieHeader == null) {
            return new Cookie[0];
        }
        return this.parseCookieHeaderValue(cookieHeader);
    }

    public long getDateHeader(String s) {
        if (this.request.getMultiValueHeaders() == null) {
            return -1L;
        }
        String dateString = (String)this.request.getMultiValueHeaders().getFirst(s);
        if (dateString == null) {
            return -1L;
        }
        try {
            return Instant.from(ZonedDateTime.parse(dateString, dateFormatter)).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            log.warn("Invalid date header in request" + SecurityUtils.crlf(dateString));
            return -1L;
        }
    }

    public String getHeader(String s) {
        List<String> values = this.getHeaderValues(s);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public Enumeration<String> getHeaders(String s) {
        if (this.request.getMultiValueHeaders() == null || this.request.getMultiValueHeaders().get(s) == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.request.getMultiValueHeaders().get(s));
    }

    public Enumeration<String> getHeaderNames() {
        if (this.request.getMultiValueHeaders() == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.request.getMultiValueHeaders().keySet());
    }

    public int getIntHeader(String s) {
        if (this.request.getMultiValueHeaders() == null) {
            return -1;
        }
        String headerValue = (String)this.request.getMultiValueHeaders().getFirst(s);
        if (headerValue == null) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public String getMethod() {
        return this.request.getHttpMethod();
    }

    public String getPathInfo() {
        String pathInfo = AwsProxyHttpServletRequest.cleanUri(this.request.getPath());
        return AwsProxyHttpServletRequest.decodeRequestPath(pathInfo, LambdaContainerHandler.getContainerConfig());
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.generateContextPath(this.config, this.request.getRequestContext().getStage());
    }

    public String getQueryString() {
        try {
            return this.generateQueryString(this.request.getMultiValueQueryStringParameters(), this.request.getRequestSource() != RequestSource.ALB, this.config.getUriEncoding());
        }
        catch (ServletException e) {
            log.error("Could not generate query string", (Throwable)e);
            return null;
        }
    }

    public String getRemoteUser() {
        return this.securityContext.getUserPrincipal().getName();
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        return this.securityContext.getUserPrincipal();
    }

    public String getRequestURI() {
        return AwsProxyHttpServletRequest.cleanUri(this.getContextPath()) + AwsProxyHttpServletRequest.cleanUri(this.request.getPath());
    }

    public StringBuffer getRequestURL() {
        return this.generateRequestURL(this.request.getPath());
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String s, String s1) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public String getCharacterEncoding() {
        if (this.request.getMultiValueHeaders() == null) {
            return this.config.getDefaultContentCharset();
        }
        Charset charset = HttpUtils.parseCharacterEncoding((String)this.request.getMultiValueHeaders().getFirst("Content-Type"), null);
        return charset != null ? charset.name() : null;
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        String currentContentType;
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        if ((currentContentType = (String)this.request.getMultiValueHeaders().getFirst("Content-Type")) == null || currentContentType.isEmpty()) {
            log.debug("Called set character encoding to " + SecurityUtils.crlf(s) + " on a request without a content type. Character encoding will not be set");
            return;
        }
        this.request.getMultiValueHeaders().putSingle("Content-Type", HttpUtils.appendCharacterEncoding(currentContentType, s));
    }

    public int getContentLength() {
        String headerValue = (String)this.request.getMultiValueHeaders().getFirst("Content-Length");
        if (headerValue == null) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public long getContentLengthLong() {
        String headerValue = (String)this.request.getMultiValueHeaders().getFirst("Content-Length");
        if (headerValue == null) {
            return -1L;
        }
        return Long.parseLong(headerValue);
    }

    public String getContentType() {
        String contentTypeHeader = (String)this.request.getMultiValueHeaders().getFirst("Content-Type");
        if (contentTypeHeader == null || "".equals(contentTypeHeader.trim())) {
            return null;
        }
        return contentTypeHeader;
    }

    public String getParameter(String s) {
        String queryStringParameter;
        if (this.request.getRequestSource() == RequestSource.ALB) {
            s = AwsProxyHttpServletRequest.decodeValueIfEncoded(s);
        }
        if ((queryStringParameter = this.getFirstQueryParamValue(this.request.getMultiValueQueryStringParameters(), s, this.config.isQueryStringCaseSensitive())) != null) {
            if (this.request.getRequestSource() == RequestSource.ALB) {
                queryStringParameter = AwsProxyHttpServletRequest.decodeValueIfEncoded(queryStringParameter);
            }
            return queryStringParameter;
        }
        String[] bodyParams = this.getFormBodyParameterCaseInsensitive(s);
        if (bodyParams.length == 0) {
            return null;
        }
        return bodyParams[0];
    }

    public Enumeration<String> getParameterNames() {
        Set<String> formParameterNames = this.getFormUrlEncodedParametersMap().keySet();
        if (this.request.getMultiValueQueryStringParameters() == null) {
            return Collections.enumeration(formParameterNames);
        }
        Set<String> paramNames = this.request.getMultiValueQueryStringParameters().keySet();
        if (this.request.getRequestSource() == RequestSource.ALB) {
            paramNames = paramNames.stream().map(AwsHttpServletRequest::decodeValueIfEncoded).collect(Collectors.toSet());
        }
        return Collections.enumeration(Stream.concat(formParameterNames.stream(), paramNames.stream()).collect(Collectors.toSet()));
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public String[] getParameterValues(String s) {
        List<String> values;
        if (this.request.getRequestSource() == RequestSource.ALB) {
            s = AwsProxyHttpServletRequest.decodeValueIfEncoded(s);
        }
        if ((values = (values = AwsProxyHttpServletRequest.getQueryParamValuesAsList(this.request.getMultiValueQueryStringParameters(), s, this.config.isQueryStringCaseSensitive())) != null ? new ArrayList<String>(values) : new ArrayList<String>()) != null && this.request.getRequestSource() == RequestSource.ALB) {
            values = values.stream().map(AwsHttpServletRequest::decodeValueIfEncoded).collect(Collectors.toList());
        }
        values.addAll(Arrays.asList(this.getFormBodyParameterCaseInsensitive(s)));
        if (values.size() == 0) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    public Map<String, String[]> getParameterMap() {
        return this.generateParameterMap(this.request.getMultiValueQueryStringParameters(), this.config, this.request.getRequestSource() == RequestSource.ALB);
    }

    public String getProtocol() {
        return this.request.getRequestContext().getProtocol();
    }

    public String getScheme() {
        return this.getSchemeFromHeader(this.request.getMultiValueHeaders());
    }

    @Override
    public String getServerName() {
        String hostHeader;
        String region = System.getenv("AWS_REGION");
        if (region == null) {
            region = "us-east-1";
        }
        if (this.request.getMultiValueHeaders() != null && this.request.getMultiValueHeaders().containsKey("Host") && SecurityUtils.isValidHost(hostHeader = (String)this.request.getMultiValueHeaders().getFirst("Host"), this.request.getRequestContext().getApiId(), this.request.getRequestContext().getElb(), region)) {
            return hostHeader;
        }
        return this.request.getRequestContext().getApiId() + ".execute-api." + region + ".amazonaws.com";
    }

    @Override
    public int getServerPort() {
        if (this.request.getMultiValueHeaders() == null) {
            return 443;
        }
        String port = (String)this.request.getMultiValueHeaders().getFirst("X-Forwarded-Port");
        if (SecurityUtils.isValidPort(port)) {
            return Integer.parseInt(port);
        }
        return 443;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.requestInputStream == null) {
            this.requestInputStream = new AwsServletInputStream((InputStream)this.bodyStringToInputStream(this.request.getBody(), this.request.isBase64Encoded()));
        }
        return this.requestInputStream;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new StringReader(this.request.getBody()));
    }

    public String getRemoteAddr() {
        if (this.request.getRequestContext() == null || this.request.getRequestContext().getIdentity() == null) {
            return "127.0.0.1";
        }
        if (this.request.getRequestSource().equals((Object)RequestSource.ALB)) {
            return Objects.nonNull(this.request.getHeaders()) ? (String)this.request.getHeaders().get("X-Forwarded-For") : (String)this.request.getMultiValueHeaders().getFirst("X-Forwarded-For");
        }
        return this.request.getRequestContext().getIdentity().getSourceIp();
    }

    public String getRemoteHost() {
        String hostHeader = this.request.getRequestSource().equals((Object)RequestSource.ALB) ? (Objects.nonNull(this.request.getHeaders()) ? (String)this.request.getHeaders().get("Host") : (String)this.request.getMultiValueHeaders().getFirst("Host")) : (String)this.request.getMultiValueHeaders().getFirst("Host");
        return Arrays.asList(hostHeader.split(":")).get(0);
    }

    public Locale getLocale() {
        List<Locale> locales = this.parseAcceptLanguageHeader((String)this.request.getMultiValueHeaders().getFirst("Accept-Language"));
        return locales.size() == 0 ? Locale.getDefault() : locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        List<Locale> locales = this.parseAcceptLanguageHeader((String)this.request.getMultiValueHeaders().getFirst("Accept-Language"));
        return Collections.enumeration(locales);
    }

    public boolean isSecure() {
        return this.securityContext.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.getServletContext().getRequestDispatcher(s);
    }

    public int getRemotePort() {
        if (this.request.getRequestSource().equals((Object)RequestSource.ALB)) {
            String portHeader;
            String string = portHeader = Objects.nonNull(this.request.getHeaders()) ? (String)this.request.getHeaders().get("X-Forwarded-Port") : (String)this.request.getMultiValueHeaders().getFirst("X-Forwarded-Port");
            if (Objects.nonNull(portHeader)) {
                return Integer.parseInt(portHeader);
            }
        }
        return 0;
    }

    @Override
    public boolean isAsyncSupported() {
        return true;
    }

    @Override
    public boolean isAsyncStarted() {
        if (this.asyncContext == null) {
            return false;
        }
        return !this.asyncContext.isCompleted() && !this.asyncContext.isDispatched();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        this.asyncContext = new AwsAsyncContext(this, this.response);
        this.setAttribute("com.amazonaws.serverless.javacontainer.dispatchertype", DispatcherType.ASYNC);
        log.debug("Starting async context for request: " + SecurityUtils.crlf(this.request.getRequestContext().getRequestId()));
        return this.asyncContext;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        servletRequest.setAttribute("com.amazonaws.serverless.javacontainer.dispatchertype", (Object)DispatcherType.ASYNC);
        this.asyncContext = new AwsAsyncContext((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
        log.debug("Starting async context for request: " + SecurityUtils.crlf(this.request.getRequestContext().getRequestId()));
        return this.asyncContext;
    }

    public AsyncContext getAsyncContext() {
        if (this.asyncContext == null) {
            throw new IllegalStateException("Request " + SecurityUtils.crlf(this.request.getRequestContext().getRequestId()) + " is not in asynchronous mode. Call startAsync before attempting to get the async context.");
        }
        return this.asyncContext;
    }

    public String getRequestId() {
        return this.request.getRequestContext().getRequestId();
    }

    public String getProtocolRequestId() {
        return "";
    }

    public ServletConnection getServletConnection() {
        return null;
    }

    private List<String> getHeaderValues(String key) {
        ArrayList<String> values = new ArrayList<String>();
        if (this.request.getRequestSource() == RequestSource.API_GATEWAY) {
            String userAgent;
            String caller;
            if ("referer".equals(key.toLowerCase(Locale.ENGLISH)) && this.request.getRequestContext() != null && this.request.getRequestContext().getIdentity() != null && (caller = this.request.getRequestContext().getIdentity().getCaller()) != null) {
                values.add(caller);
                return values;
            }
            if ("user-agent".equals(key.toLowerCase(Locale.ENGLISH)) && this.request.getRequestContext() != null && this.request.getRequestContext().getIdentity() != null && (userAgent = this.request.getRequestContext().getIdentity().getUserAgent()) != null) {
                values.add(userAgent);
                return values;
            }
        }
        if (this.request.getMultiValueHeaders() == null) {
            return null;
        }
        return this.request.getMultiValueHeaders().get(key);
    }
}

