/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.dynamodbv2.streamsadapter.polling.DynamoDBStreamsCatchUpConfig;
import java.time.Duration;
import java.time.Instant;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;
import software.amazon.kinesis.metrics.MetricsUtil;
import software.amazon.kinesis.retrieval.polling.SleepTimeController;
import software.amazon.kinesis.retrieval.polling.SleepTimeControllerConfig;

public class DynamoDBStreamsSleepTimeController
implements SleepTimeController {
    private static final Logger log = LoggerFactory.getLogger(DynamoDBStreamsSleepTimeController.class);
    private static final String OPERATION = "ApplicationTracker";
    private static final String CATCHUP_MODE_ACTIVE_METRIC = "DynamoDBStreamsCatchUpModeActive";
    @NonNull
    private final DynamoDBStreamsCatchUpConfig catchUpConfig;
    @NonNull
    private final MetricsFactory metricsFactory;

    public DynamoDBStreamsSleepTimeController(@NonNull MetricsFactory metricsFactory) {
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory is marked non-null but is null");
        }
        this.catchUpConfig = new DynamoDBStreamsCatchUpConfig();
        this.metricsFactory = metricsFactory;
    }

    public DynamoDBStreamsSleepTimeController(@NonNull DynamoDBStreamsCatchUpConfig catchUpConfig, @NonNull MetricsFactory metricsFactory) {
        if (catchUpConfig == null) {
            throw new NullPointerException("catchUpConfig is marked non-null but is null");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory is marked non-null but is null");
        }
        this.catchUpConfig = catchUpConfig;
        this.metricsFactory = metricsFactory;
    }

    public long getSleepTimeMillis(SleepTimeControllerConfig sleepTimeControllerConfig) {
        long idleMillsBetweenCalls = sleepTimeControllerConfig.idleMillisBetweenCalls();
        if (this.shouldEnterCatchUpMode(sleepTimeControllerConfig)) {
            idleMillsBetweenCalls /= (long)this.catchUpConfig.scalingFactor();
            log.debug("Catch-up mode enabled: reducing sleep time by factor of {} (millisBehindLatest: {}ms, threshold: {}ms)", new Object[]{this.catchUpConfig.scalingFactor(), sleepTimeControllerConfig.lastMillisBehindLatest(), this.catchUpConfig.millisBehindLatestThreshold()});
            this.emitCatchUpModeMetric();
        }
        Instant lastSuccessfulCall = sleepTimeControllerConfig.lastSuccessfulCall();
        Integer lastGetRecordsReturnedRecordsCount = sleepTimeControllerConfig.lastRecordsCount();
        if (lastSuccessfulCall == null || lastGetRecordsReturnedRecordsCount == null) {
            return idleMillsBetweenCalls;
        }
        long sleepTime = lastGetRecordsReturnedRecordsCount > 0 ? idleMillsBetweenCalls : 2L * idleMillsBetweenCalls;
        long timeSinceLastCall = Duration.between(lastSuccessfulCall, Instant.now()).abs().toMillis();
        if (timeSinceLastCall < sleepTime) {
            return sleepTime - timeSinceLastCall;
        }
        return 0L;
    }

    private boolean shouldEnterCatchUpMode(SleepTimeControllerConfig config) {
        return this.catchUpConfig.catchupEnabled() && config.lastMillisBehindLatest() != null && config.lastMillisBehindLatest() > this.catchUpConfig.millisBehindLatestThreshold();
    }

    private void emitCatchUpModeMetric() {
        MetricsScope scope = MetricsUtil.createMetricsWithOperation((MetricsFactory)this.metricsFactory, (String)OPERATION);
        try {
            MetricsUtil.addCount((MetricsScope)scope, (String)CATCHUP_MODE_ACTIVE_METRIC, (long)1L, (MetricsLevel)MetricsLevel.SUMMARY);
        }
        finally {
            MetricsUtil.endScope((MetricsScope)scope);
        }
    }
}

