/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.dynamodbv2.streamsadapter.util.KinesisMapperUtil;
import com.amazonaws.services.dynamodbv2.streamsadapter.util.StreamsLeaseCleanupValidator;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.services.kinesis.model.HashKeyRange;
import software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.kinesis.common.HashKeyRangeForLease;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.coordinator.DeletedStreamListProvider;
import software.amazon.kinesis.exceptions.internal.KinesisClientLibIOException;
import software.amazon.kinesis.leases.HierarchicalShardSyncer;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.MultiStreamLease;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.exceptions.DependencyException;
import software.amazon.kinesis.leases.exceptions.InvalidStateException;
import software.amazon.kinesis.leases.exceptions.ProvisionedThroughputException;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;
import software.amazon.kinesis.metrics.MetricsUtil;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public class DynamoDBStreamsShardSyncer
extends HierarchicalShardSyncer {
    private static final Log LOG = LogFactory.getLog(DynamoDBStreamsShardSyncer.class);
    private final boolean isMultiStreamMode;
    private final String streamIdentifier;
    private final boolean cleanupLeasesOfCompletedShards;
    private final String streamArn;
    private final DeletedStreamListProvider deletedStreamListProvider;
    private static final BiFunction<Lease, MultiStreamArgs, String> SHARD_ID_FROM_LEASE_DEDUCER = (lease, multiStreamArgs) -> multiStreamArgs.isMultiStreamMode() != false ? ((MultiStreamLease)lease).shardId() : lease.leaseKey();

    public DynamoDBStreamsShardSyncer(boolean isMultiStreamMode, String streamIdentifier, boolean cleanupLeasesOfCompletedShards) {
        this(isMultiStreamMode, streamIdentifier, cleanupLeasesOfCompletedShards, null);
    }

    public DynamoDBStreamsShardSyncer(boolean isMultiStreamMode, String streamIdentifier, boolean cleanupLeasesOfCompletedShards, DeletedStreamListProvider deletedStreamListProvider) {
        super(isMultiStreamMode, streamIdentifier, deletedStreamListProvider);
        this.isMultiStreamMode = isMultiStreamMode;
        this.streamIdentifier = streamIdentifier;
        this.deletedStreamListProvider = deletedStreamListProvider;
        this.cleanupLeasesOfCompletedShards = cleanupLeasesOfCompletedShards;
        this.streamArn = KinesisMapperUtil.createDynamoDBStreamsArnFromKinesisStreamName(streamIdentifier);
    }

    public synchronized boolean checkAndCreateLeaseForNewShards(@NonNull ShardDetector shardDetector, LeaseRefresher leaseRefresher, InitialPositionInStreamExtended initialPosition, MetricsScope scope, boolean ignoreUnexpectedChildShards, boolean isLeaseTableEmpty) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector is marked non-null but is null");
        }
        this.syncShardLeases(shardDetector, leaseRefresher, initialPosition, scope, ignoreUnexpectedChildShards, isLeaseTableEmpty);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncShardLeases(@NonNull ShardDetector shardDetector, LeaseRefresher leaseRefresher, InitialPositionInStreamExtended initialPosition, MetricsScope scope, boolean ignoreUnexpectedChildShards, boolean isLeaseTableEmpty) throws ProvisionedThroughputException, InvalidStateException, DependencyException {
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector is marked non-null but is null");
        }
        LOG.info((Object)("syncShardLeases " + this.streamArn + ": begin"));
        long startTimeMillis = System.currentTimeMillis();
        String consumerId = leaseRefresher.getLeaseTableIdentifier();
        List<Shard> shards = this.getShardList(shardDetector, consumerId);
        LOG.debug((Object)("Num shards " + this.streamArn + ": " + shards.size()));
        Map<String, Shard> shardIdToShardMap = this.constructShardIdToShardMap(shards);
        Map<String, Set<String>> shardIdToChildShardIdsMap = this.constructShardIdToChildShardIdsMap(shardIdToShardMap);
        Set<String> inconsistentShardIds = this.findInconsistentShardIds(shardIdToChildShardIdsMap, shardIdToShardMap);
        if (!ignoreUnexpectedChildShards) {
            this.assertAllParentShardsAreClosed(inconsistentShardIds);
        }
        List currentLeases = this.isMultiStreamMode ? leaseRefresher.listLeasesForStream(shardDetector.streamIdentifier()) : leaseRefresher.listLeases();
        MultiStreamArgs multiStreamArgs = new MultiStreamArgs(this.isMultiStreamMode, shardDetector.streamIdentifier());
        List<Lease> newLeasesToCreate = this.determineNewLeasesToCreate(shards, currentLeases, initialPosition, inconsistentShardIds, multiStreamArgs);
        LOG.debug((Object)("Num new leases to create " + this.streamArn + ": " + newLeasesToCreate.size()));
        for (Lease lease : newLeasesToCreate) {
            long leaseCreationStartTimeMillis = System.currentTimeMillis();
            boolean success = false;
            try {
                success = leaseRefresher.createLeaseIfNotExists(lease);
            }
            finally {
                if (this.isMultiStreamMode) {
                    MetricsUtil.addOperation((MetricsScope)scope, (String)"StreamId", (String)this.streamArn);
                }
                MetricsUtil.addSuccessAndLatency((MetricsScope)scope, (String)"CreateLease", (boolean)success, (long)leaseCreationStartTimeMillis, (MetricsLevel)MetricsLevel.DETAILED);
            }
        }
        ArrayList<Lease> trackedLeases = new ArrayList<Lease>();
        if (!currentLeases.isEmpty()) {
            trackedLeases.addAll(currentLeases);
        }
        trackedLeases.addAll(newLeasesToCreate);
        this.cleanupGarbageLeases(shards, trackedLeases, shardDetector, leaseRefresher, multiStreamArgs);
        if (this.cleanupLeasesOfCompletedShards) {
            this.cleanupLeasesOfFinishedShards(currentLeases, shardIdToShardMap, shardIdToChildShardIdsMap, trackedLeases, leaseRefresher, multiStreamArgs);
        }
        MetricsUtil.addLatency((MetricsScope)scope, (String)("ShardSyncLatency:" + this.streamArn), (long)startTimeMillis, (MetricsLevel)MetricsLevel.SUMMARY);
        LOG.info((Object)("syncShardLeases: " + this.streamArn + ": end"));
    }

    private List<Shard> getShardList(@NonNull ShardDetector shardDetector, String consumerId) throws KinesisClientLibIOException {
        List shardList;
        block4: {
            if (shardDetector == null) {
                throw new NullPointerException("shardDetector is marked non-null but is null");
            }
            shardList = Collections.emptyList();
            try {
                shardList = shardDetector.listShards(consumerId);
            }
            catch (ResourceNotFoundException e) {
                if (!Objects.nonNull(this.deletedStreamListProvider) || !this.isMultiStreamMode) break block4;
                this.deletedStreamListProvider.add(StreamIdentifier.multiStreamInstance((String)this.streamIdentifier));
            }
        }
        if (Objects.isNull(shardList)) {
            throw new KinesisClientLibIOException(String.format("Could not get shards for the stream: %s - will retry getting the shard list", this.streamArn));
        }
        return shardList;
    }

    private void assertAllParentShardsAreClosed(Set<String> inconsistentShardIds) {
        if (!inconsistentShardIds.isEmpty()) {
            String ids = StringUtils.join(inconsistentShardIds, (char)' ');
            throw new KinesisClientLibIOException(String.format("%d open child shards (%s) are inconsistent. This can happen due to a race condition between describeStream and a reshard operation.", inconsistentShardIds.size(), ids));
        }
    }

    private static Lease newKCLLease(Shard shard) {
        Lease newLease = new Lease();
        newLease.leaseKey(shard.shardId());
        DynamoDBStreamsShardSyncer.setupLeaseProperties(shard, newLease);
        return newLease;
    }

    private static Lease newKCLMultiStreamLease(Shard shard, StreamIdentifier streamIdentifier) {
        MultiStreamLease newLease = new MultiStreamLease();
        newLease.leaseKey(MultiStreamLease.getLeaseKey((String)streamIdentifier.serialize(), (String)shard.shardId()));
        newLease.streamIdentifier(streamIdentifier.serialize());
        newLease.shardId(shard.shardId());
        DynamoDBStreamsShardSyncer.setupLeaseProperties(shard, (Lease)newLease);
        return newLease;
    }

    private static void setupLeaseProperties(Shard shard, Lease lease) {
        ArrayList<String> parentShardIds = new ArrayList<String>(2);
        if (shard.parentShardId() != null) {
            parentShardIds.add(shard.parentShardId());
        }
        lease.parentShardIds(parentShardIds);
        lease.ownerSwitchesSinceCheckpoint(Long.valueOf(0L));
        lease.hashKeyRange(HashKeyRangeForLease.fromHashKeyRange((HashKeyRange)shard.hashKeyRange()));
    }

    @VisibleForTesting
    List<Lease> determineNewLeasesToCreate(List<Shard> shards, List<Lease> currentLeases, InitialPositionInStreamExtended initialPosition, Set<String> inconsistentShardIds, MultiStreamArgs multiStreamArgs) {
        LOG.info((Object)("determineNewLeasesToCreate " + this.streamArn + ": begin"));
        String streamIdentifier = Optional.ofNullable(multiStreamArgs.streamIdentifier()).map(StreamIdentifier::serialize).orElse("");
        Set<String> shardIdsOfCurrentLeases = currentLeases.stream().peek(lease -> LOG.debug((Object)("Existing lease, streamIdentifier: " + streamIdentifier + " lease: " + lease))).map(lease -> SHARD_ID_FROM_LEASE_DEDUCER.apply((Lease)lease, multiStreamArgs)).collect(Collectors.toSet());
        HashMap<String, Lease> shardIdToNewLeaseMap = new HashMap<String, Lease>();
        Map<String, Shard> shardIdToShardMapOfAllKinesisShards = this.constructShardIdToShardMap(shards);
        List<Shard> openShards = this.getOpenShards(shards);
        HashMap<String, Boolean> memoizationContext = new HashMap<String, Boolean>();
        for (Shard shard : openShards) {
            String shardId = shard.shardId();
            LOG.debug((Object)("Evaluating leases for open shard " + shardId + " and its ancestors."));
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                LOG.debug((Object)("Lease for shardId " + shardId + " already exists. Not creating a lease"));
                continue;
            }
            if (inconsistentShardIds.contains(shardId)) {
                LOG.info((Object)String.format("shardId: %s for stream: %s is an inconsistent child. Not creating a lease", shardId, this.streamArn));
                continue;
            }
            LOG.debug((Object)("Need to create a lease for shardId " + shardId));
            Lease newLease = multiStreamArgs.isMultiStreamMode != false ? DynamoDBStreamsShardSyncer.newKCLMultiStreamLease(shard, multiStreamArgs.streamIdentifier) : DynamoDBStreamsShardSyncer.newKCLLease(shard);
            boolean isDescendant = this.checkIfDescendantAndAddNewLeasesForAncestors(shardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToNewLeaseMap, memoizationContext, multiStreamArgs);
            if (isDescendant) {
                newLease.checkpoint(ExtendedSequenceNumber.TRIM_HORIZON);
            } else {
                newLease.checkpoint(DynamoDBStreamsShardSyncer.convertToCheckpoint(initialPosition));
            }
            LOG.debug((Object)("Set checkpoint of " + newLease.leaseKey() + " to " + newLease.checkpoint()));
            shardIdToNewLeaseMap.put(shardId, newLease);
        }
        ArrayList<Lease> newLeasesToCreate = new ArrayList<Lease>(shardIdToNewLeaseMap.values());
        StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMapOfAllKinesisShards, multiStreamArgs);
        newLeasesToCreate.sort(startingSequenceNumberComparator);
        LOG.info((Object)("determineNewLeasesToCreate " + this.streamArn + ": done"));
        return newLeasesToCreate;
    }

    boolean checkIfDescendantAndAddNewLeasesForAncestors(String shardId, InitialPositionInStreamExtended initialPosition, Set<String> shardIdsOfCurrentLeases, Map<String, Shard> shardIdToShardMapOfAllKinesisShards, Map<String, Lease> shardIdToLeaseMapOfNewShards, Map<String, Boolean> memoizationContext, MultiStreamArgs multiStreamArgs) {
        Boolean previousValue = memoizationContext.get(shardId);
        if (previousValue != null) {
            return previousValue;
        }
        boolean isDescendant = false;
        HashSet<String> descendantParentShardIds = new HashSet<String>();
        if (shardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(shardId)) {
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                isDescendant = true;
            } else {
                Shard shard = shardIdToShardMapOfAllKinesisShards.get(shardId);
                Set<String> parentShardIds = this.getParentShardIds(shard, shardIdToShardMapOfAllKinesisShards);
                for (String parentShardId : parentShardIds) {
                    if (this.checkIfDescendantAndAddNewLeasesForAncestors(parentShardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToLeaseMapOfNewShards, memoizationContext, multiStreamArgs)) {
                        isDescendant = true;
                        descendantParentShardIds.add(parentShardId);
                        LOG.debug((Object)("Parent shard " + parentShardId + " is a descendant."));
                        continue;
                    }
                    LOG.debug((Object)("Parent shard " + parentShardId + " is NOT a descendant."));
                }
                if (isDescendant) {
                    for (String parentShardId : parentShardIds) {
                        if (shardIdsOfCurrentLeases.contains(parentShardId)) continue;
                        LOG.debug((Object)("Need to create a lease for shardId " + parentShardId));
                        Lease lease = shardIdToLeaseMapOfNewShards.get(parentShardId);
                        if (lease == null) {
                            lease = multiStreamArgs.isMultiStreamMode != false ? DynamoDBStreamsShardSyncer.newKCLMultiStreamLease(shardIdToShardMapOfAllKinesisShards.get(parentShardId), multiStreamArgs.streamIdentifier()) : DynamoDBStreamsShardSyncer.newKCLLease(shardIdToShardMapOfAllKinesisShards.get(parentShardId));
                            shardIdToLeaseMapOfNewShards.put(parentShardId, lease);
                        }
                        if (descendantParentShardIds.contains(parentShardId)) {
                            lease.checkpoint(ExtendedSequenceNumber.TRIM_HORIZON);
                            continue;
                        }
                        lease.checkpoint(DynamoDBStreamsShardSyncer.convertToCheckpoint(initialPosition));
                    }
                } else if (initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.TRIM_HORIZON)) {
                    isDescendant = true;
                }
            }
        }
        memoizationContext.put(shardId, isDescendant);
        return isDescendant;
    }

    private void cleanupGarbageLeases(List<Shard> shards, List<Lease> trackedLeases, ShardDetector shardDetector, LeaseRefresher leaseRefresher, MultiStreamArgs multiStreamArgs) throws ProvisionedThroughputException, InvalidStateException, DependencyException {
        LOG.info((Object)("cleanupGarbageLeases: " + this.streamArn + ": begin"));
        HashSet<String> kinesisShards = new HashSet<String>();
        for (Shard shard : shards) {
            kinesisShards.add(shard.shardId());
        }
        ArrayList<Lease> garbageLeases = new ArrayList<Lease>();
        for (Lease lease : trackedLeases) {
            if (!StreamsLeaseCleanupValidator.isCandidateForCleanup(lease, kinesisShards, this.isMultiStreamMode)) continue;
            garbageLeases.add(lease);
        }
        if (!garbageLeases.isEmpty()) {
            LOG.info((Object)("Found " + garbageLeases.size() + " candidate leases for cleanup. Refreshing list of dynamoDb shards to pick up recent/latest shards from stream " + this.streamArn));
            HashSet<String> hashSet = new HashSet<String>();
            for (Shard shard : shards) {
                hashSet.add(shard.shardId());
            }
            for (Lease lease : garbageLeases) {
                if (!StreamsLeaseCleanupValidator.isCandidateForCleanup(lease, hashSet, this.isMultiStreamMode)) continue;
                LOG.info((Object)("Deleting lease for shard " + SHARD_ID_FROM_LEASE_DEDUCER.apply(lease, multiStreamArgs) + " as it is not present in stream. " + this.streamArn));
                leaseRefresher.deleteLease(lease);
            }
        }
        LOG.info((Object)("cleanupGarbageLeases " + this.streamArn + ": done"));
    }

    private synchronized void cleanupLeasesOfFinishedShards(Collection<Lease> currentLeases, Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap, List<Lease> trackedLeases, LeaseRefresher leaseRefresher, MultiStreamArgs multiStreamArgs) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        LOG.info((Object)("cleanupLeasesOfFinishedShards " + this.streamArn + ": begin"));
        HashSet<String> shardIdsOfClosedShards = new HashSet<String>();
        ArrayList<Lease> leasesOfClosedShards = new ArrayList<Lease>();
        for (Lease lease : currentLeases) {
            if (!lease.checkpoint().equals((Object)ExtendedSequenceNumber.SHARD_END)) continue;
            shardIdsOfClosedShards.add(SHARD_ID_FROM_LEASE_DEDUCER.apply(lease, multiStreamArgs));
            leasesOfClosedShards.add(lease);
        }
        if (!leasesOfClosedShards.isEmpty()) {
            this.assertClosedShardsAreCoveredOrAbsent(shardIdToShardMap, shardIdToChildShardIdsMap, shardIdsOfClosedShards);
            StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMap, multiStreamArgs);
            leasesOfClosedShards.sort(startingSequenceNumberComparator);
            Map<String, Lease> trackedLeaseMap = this.constructShardIdToKCLLeaseMap(trackedLeases, multiStreamArgs);
            for (Lease leaseOfClosedShard : leasesOfClosedShards) {
                String closedShardId = SHARD_ID_FROM_LEASE_DEDUCER.apply(leaseOfClosedShard, multiStreamArgs);
                Set<String> childShardIds = shardIdToChildShardIdsMap.get(closedShardId);
                if (closedShardId == null || childShardIds == null || childShardIds.isEmpty()) continue;
                this.cleanupLeaseForClosedShard(closedShardId, childShardIds, trackedLeaseMap, leaseRefresher, multiStreamArgs);
            }
        }
        LOG.info((Object)("cleanupLeasesOfFinishedShards: " + this.streamArn + ": done"));
    }

    synchronized void cleanupLeaseForClosedShard(String closedShardId, Set<String> childShardIds, Map<String, Lease> trackedLeases, LeaseRefresher leaseRefresher, MultiStreamArgs multiStreamArgs) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        Lease leaseForClosedShard = trackedLeases.get(closedShardId);
        ArrayList<Lease> childShardLeases = new ArrayList<Lease>();
        for (String string : childShardIds) {
            Lease childLease = trackedLeases.get(string);
            if (childLease == null) continue;
            childShardLeases.add(childLease);
        }
        if (leaseForClosedShard != null && leaseForClosedShard.checkpoint().equals((Object)ExtendedSequenceNumber.SHARD_END) && childShardLeases.size() == childShardIds.size()) {
            boolean okayToDelete = true;
            for (Lease lease : childShardLeases) {
                if (lease.checkpoint().equals((Object)ExtendedSequenceNumber.SHARD_END)) continue;
                okayToDelete = false;
                break;
            }
            try {
                if (Instant.now().isBefore(KinesisMapperUtil.getShardCreationTime(closedShardId).plus(KinesisMapperUtil.MIN_LEASE_RETENTION_DURATION_IN_HOURS))) {
                    okayToDelete = false;
                }
            }
            catch (RuntimeException runtimeException) {
                LOG.info((Object)("Could not extract creation time from ShardId [" + closedShardId + "] " + this.streamArn));
                LOG.debug((Object)runtimeException);
            }
            if (okayToDelete) {
                LOG.info((Object)("Deleting lease for shard " + SHARD_ID_FROM_LEASE_DEDUCER.apply(leaseForClosedShard, multiStreamArgs) + " as it is eligible for cleanup - its child shard is check-pointed at SHARD_END for the stream " + this.streamArn));
                leaseRefresher.deleteLease(leaseForClosedShard);
            }
        }
    }

    Map<String, Lease> constructShardIdToKCLLeaseMap(List<Lease> trackedLeaseList, MultiStreamArgs multiStreamArgs) {
        HashMap<String, Lease> trackedLeasesMap = new HashMap<String, Lease>();
        for (Lease lease : trackedLeaseList) {
            trackedLeasesMap.put(SHARD_ID_FROM_LEASE_DEDUCER.apply(lease, multiStreamArgs), lease);
        }
        return trackedLeasesMap;
    }

    synchronized void assertClosedShardsAreCoveredOrAbsent(Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap, Set<String> shardIdsOfClosedShards) throws KinesisClientLibIOException {
        String exceptionMessageSuffix = "This can happen if we constructed the list of shards  while a reshard operation was in progress.";
        for (String shardId : shardIdsOfClosedShards) {
            Shard shard = shardIdToShardMap.get(shardId);
            if (Instant.now().isBefore(KinesisMapperUtil.getShardCreationTime(shardId).plus(KinesisMapperUtil.MIN_LEASE_RETENTION_DURATION_IN_HOURS))) {
                LOG.info((Object)("Delaying deleting Shard " + shardId + " till lease retention duration is reached. " + this.streamArn));
                continue;
            }
            if (shard == null) {
                LOG.info((Object)("Shard " + shardId + " is not present in stream " + this.streamArn + "anymore."));
                continue;
            }
            String endingSequenceNumber = shard.sequenceNumberRange().endingSequenceNumber();
            if (endingSequenceNumber == null) {
                throw new KinesisClientLibIOException("Shard " + shardId + " is not closed. " + exceptionMessageSuffix);
            }
            Set<String> childShardIds = shardIdToChildShardIdsMap.get(shardId);
            if (childShardIds != null) continue;
            throw new KinesisClientLibIOException("Incomplete shard list: Closed shard " + shardId + " has no children." + exceptionMessageSuffix);
        }
    }

    Set<String> getParentShardIds(Shard shard, Map<String, Shard> shardIdToShardMapOfAllKinesisShards) {
        HashSet<String> parentShardIds = new HashSet<String>(2);
        String parentShardId = shard.parentShardId();
        if (parentShardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(parentShardId)) {
            parentShardIds.add(parentShardId);
        }
        return parentShardIds;
    }

    private static ExtendedSequenceNumber convertToCheckpoint(InitialPositionInStreamExtended position) {
        ExtendedSequenceNumber checkpoint = null;
        checkpoint = position.getInitialPositionInStream().equals((Object)InitialPositionInStream.TRIM_HORIZON) ? ExtendedSequenceNumber.TRIM_HORIZON : ExtendedSequenceNumber.LATEST;
        return checkpoint;
    }

    List<Shard> getOpenShards(List<Shard> allShards) {
        ArrayList<Shard> openShards = new ArrayList<Shard>();
        for (Shard shard : allShards) {
            String endingSequenceNumber = shard.sequenceNumberRange().endingSequenceNumber();
            if (endingSequenceNumber != null) continue;
            openShards.add(shard);
            LOG.debug((Object)("Found open shard: " + shard.shardId()));
        }
        return openShards;
    }

    private Set<String> findInconsistentShardIds(Map<String, Set<String>> shardIdToChildShardIdsMap, Map<String, Shard> shardIdToShardMap) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : shardIdToChildShardIdsMap.entrySet()) {
            String parentShardId = entry.getKey();
            Shard parentShard = shardIdToShardMap.get(parentShardId);
            if (parentShardId != null && parentShard.sequenceNumberRange().endingSequenceNumber() != null) continue;
            Set<String> childShardIdsMap = entry.getValue();
            result.addAll(childShardIdsMap);
        }
        return result;
    }

    Map<String, Shard> constructShardIdToShardMap(List<Shard> shards) {
        return shards.stream().collect(Collectors.toMap(Shard::shardId, Function.identity()));
    }

    Map<String, Set<String>> constructShardIdToChildShardIdsMap(Map<String, Shard> shardIdToShardMap) {
        HashMap<String, Set<String>> shardIdToChildShardIdsMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Shard> entry : shardIdToShardMap.entrySet()) {
            String shardId = entry.getKey();
            Shard shard = entry.getValue();
            String parentShardId = shard.parentShardId();
            if (parentShardId == null || !shardIdToShardMap.containsKey(parentShardId)) continue;
            Set childShardIds = shardIdToChildShardIdsMap.computeIfAbsent(parentShardId, k -> new HashSet());
            childShardIds.add(shardId);
        }
        return shardIdToChildShardIdsMap;
    }

    @VisibleForTesting
    static class MultiStreamArgs {
        private final Boolean isMultiStreamMode;
        private final StreamIdentifier streamIdentifier;

        public MultiStreamArgs(Boolean isMultiStreamMode, StreamIdentifier streamIdentifier) {
            this.isMultiStreamMode = isMultiStreamMode;
            this.streamIdentifier = streamIdentifier;
        }

        public Boolean isMultiStreamMode() {
            return this.isMultiStreamMode;
        }

        public StreamIdentifier streamIdentifier() {
            return this.streamIdentifier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiStreamArgs)) {
                return false;
            }
            MultiStreamArgs other = (MultiStreamArgs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isMultiStreamMode = this.isMultiStreamMode();
            Boolean other$isMultiStreamMode = other.isMultiStreamMode();
            if (this$isMultiStreamMode == null ? other$isMultiStreamMode != null : !((Object)this$isMultiStreamMode).equals(other$isMultiStreamMode)) {
                return false;
            }
            StreamIdentifier this$streamIdentifier = this.streamIdentifier();
            StreamIdentifier other$streamIdentifier = other.streamIdentifier();
            return !(this$streamIdentifier == null ? other$streamIdentifier != null : !this$streamIdentifier.equals(other$streamIdentifier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MultiStreamArgs;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isMultiStreamMode = this.isMultiStreamMode();
            result = result * 59 + ($isMultiStreamMode == null ? 43 : ((Object)$isMultiStreamMode).hashCode());
            StreamIdentifier $streamIdentifier = this.streamIdentifier();
            result = result * 59 + ($streamIdentifier == null ? 43 : $streamIdentifier.hashCode());
            return result;
        }

        public String toString() {
            return "DynamoDBStreamsShardSyncer.MultiStreamArgs(isMultiStreamMode=" + this.isMultiStreamMode() + ", streamIdentifier=" + this.streamIdentifier() + ")";
        }
    }

    private static class StartingSequenceNumberAndShardIdBasedComparator
    implements Comparator<Lease>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, Shard> shardIdToShardMap;
        private final MultiStreamArgs multiStreamArgs;

        @Override
        public int compare(Lease lease1, Lease lease2) {
            int result = 0;
            String shardId1 = (String)SHARD_ID_FROM_LEASE_DEDUCER.apply(lease1, this.multiStreamArgs);
            String shardId2 = (String)SHARD_ID_FROM_LEASE_DEDUCER.apply(lease2, this.multiStreamArgs);
            Shard shard1 = this.shardIdToShardMap.get(shardId1);
            Shard shard2 = this.shardIdToShardMap.get(shardId2);
            if (shard1 != null && shard2 != null) {
                BigInteger sequenceNumber1 = new BigInteger(shard1.sequenceNumberRange().startingSequenceNumber());
                BigInteger sequenceNumber2 = new BigInteger(shard2.sequenceNumberRange().startingSequenceNumber());
                result = sequenceNumber1.compareTo(sequenceNumber2);
            }
            if (result == 0) {
                result = shardId1.compareTo(shardId2);
            }
            return result;
        }

        public StartingSequenceNumberAndShardIdBasedComparator(Map<String, Shard> shardIdToShardMap, MultiStreamArgs multiStreamArgs) {
            this.shardIdToShardMap = shardIdToShardMap;
            this.multiStreamArgs = multiStreamArgs;
        }
    }
}

