/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class AttributeValueSerializer
extends JsonSerializer<AttributeValue> {
    public void serialize(AttributeValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        if (value.s() != null) {
            gen.writeStringField("S", value.s());
        }
        if (value.n() != null) {
            gen.writeStringField("N", value.n());
        }
        if (value.b() != null) {
            gen.writeBinaryField("B", value.b().asByteArray());
        }
        if (value.bool() != null) {
            gen.writeBooleanField("BOOL", value.bool().booleanValue());
        }
        if (value.nul() != null) {
            gen.writeBooleanField("NULL", value.nul().booleanValue());
        }
        if (value.hasSs()) {
            gen.writeFieldName("SS");
            gen.writeStartArray();
            for (String s : value.ss()) {
                gen.writeString(s);
            }
            gen.writeEndArray();
        }
        if (value.hasNs()) {
            gen.writeFieldName("NS");
            gen.writeStartArray();
            for (String n : value.ns()) {
                gen.writeString(n);
            }
            gen.writeEndArray();
        }
        if (value.hasBs()) {
            gen.writeFieldName("BS");
            gen.writeStartArray();
            for (SdkBytes b : value.bs()) {
                gen.writeBinary(b.asByteArray());
            }
            gen.writeEndArray();
        }
        if (value.hasM()) {
            gen.writeFieldName("M");
            if (value.m().isEmpty()) {
                gen.writeStartObject();
                gen.writeEndObject();
            } else {
                gen.writeObject((Object)value.m());
            }
        }
        if (value.hasL()) {
            gen.writeFieldName("L");
            if (value.l().isEmpty()) {
                gen.writeStartArray();
                gen.writeEndArray();
            } else {
                gen.writeObject((Object)value.l());
            }
        }
        gen.writeEndObject();
    }
}

