/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsPeriodicShardSyncManager;
import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsProxy;
import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsShardConsumerFactory;
import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsShardSyncer;
import com.amazonaws.services.dynamodbv2.streamsadapter.StreamsDeterministicShuffleShardSyncLeaderDecider;
import com.amazonaws.services.dynamodbv2.streamsadapter.StreamsLeaseCleanupValidator;
import com.amazonaws.services.dynamodbv2.streamsadapter.leases.StreamsLeaseTaker;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.IPeriodicShardSyncManager;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.IShardConsumerFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaderDecider;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncStrategyType;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLeaseManager;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.util.StringUtils;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamsWorkerFactory {
    private static final Log LOG = LogFactory.getLog(StreamsWorkerFactory.class);

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, ExecutorService execService) {
        AmazonDynamoDBStreamsAdapterClient streamsClient = new AmazonDynamoDBStreamsAdapterClient(config.getKinesisCredentialsProvider(), config.getKinesisClientConfiguration());
        AmazonDynamoDB dynamoDBClient = (AmazonDynamoDB)StreamsWorkerFactory.createClient(AmazonDynamoDBClientBuilder.standard(), config.getDynamoDBCredentialsProvider(), config.getDynamoDBClientConfiguration(), config.getDynamoDBEndpoint(), config.getRegionName());
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), dynamoDBClient, config.getBillingMode());
        boolean isAuditorMode = config.getShardSyncStrategyType() != ShardSyncStrategyType.PERIODIC;
        DynamoDBStreamsProxy dynamoDBStreamsProxy = StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient);
        AmazonCloudWatch cloudWatchClient = (AmazonCloudWatch)StreamsWorkerFactory.createClient(AmazonCloudWatchClientBuilder.standard(), config.getCloudWatchCredentialsProvider(), config.getCloudWatchClientConfiguration(), null, config.getRegionName());
        IMetricsFactory metricsFactory = Worker.getMetricsFactory((AmazonCloudWatch)cloudWatchClient, (KinesisClientLibConfiguration)config);
        DynamoDBStreamsShardSyncer shardSyncer = new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator());
        StreamsDeterministicShuffleShardSyncLeaderDecider leaderDecider = new StreamsDeterministicShuffleShardSyncLeaderDecider(config, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager);
        DynamoDBStreamsPeriodicShardSyncManager dynamoDBStreamsPeriodicShardSyncManager = new DynamoDBStreamsPeriodicShardSyncManager(config.getWorkerIdentifier(), leaderDecider, new ShardSyncTask((IKinesisProxy)dynamoDBStreamsProxy, (ILeaseManager)kinesisClientLeaseManager, config.getInitialPositionInStreamExtended(), config.shouldCleanupLeasesUponShardCompletion(), config.shouldIgnoreUnexpectedChildShards(), 0L, (ShardSyncer)shardSyncer, null), metricsFactory, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager, (IKinesisProxy)dynamoDBStreamsProxy, isAuditorMode, config.getLeasesRecoveryAuditorExecutionFrequencyMillis(), config.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).execService(execService).metricsFactory(metricsFactory).periodicShardSyncManager((IPeriodicShardSyncManager)dynamoDBStreamsPeriodicShardSyncManager).shardConsumerFactory((IShardConsumerFactory)new DynamoDBStreamsShardConsumerFactory()).kinesisProxy((IKinesisProxy)dynamoDBStreamsProxy).shardSyncer((ShardSyncer)shardSyncer).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager((ILeaseManager)kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider((LeaderDecider)leaderDecider).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), dynamoDBClient, config.getBillingMode());
        boolean isAuditorMode = config.getShardSyncStrategyType() != ShardSyncStrategyType.PERIODIC;
        DynamoDBStreamsProxy dynamoDBStreamsProxy = StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient);
        IMetricsFactory metricsFactory = Worker.getMetricsFactory((AmazonCloudWatch)cloudWatchClient, (KinesisClientLibConfiguration)config);
        DynamoDBStreamsShardSyncer shardSyncer = new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator());
        StreamsDeterministicShuffleShardSyncLeaderDecider leaderDecider = new StreamsDeterministicShuffleShardSyncLeaderDecider(config, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager);
        DynamoDBStreamsPeriodicShardSyncManager dynamoDBStreamsPeriodicShardSyncManager = new DynamoDBStreamsPeriodicShardSyncManager(config.getWorkerIdentifier(), leaderDecider, new ShardSyncTask((IKinesisProxy)dynamoDBStreamsProxy, (ILeaseManager)kinesisClientLeaseManager, config.getInitialPositionInStreamExtended(), config.shouldCleanupLeasesUponShardCompletion(), config.shouldIgnoreUnexpectedChildShards(), 0L, (ShardSyncer)shardSyncer, null), metricsFactory, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager, (IKinesisProxy)dynamoDBStreamsProxy, isAuditorMode, config.getLeasesRecoveryAuditorExecutionFrequencyMillis(), config.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).metricsFactory(metricsFactory).periodicShardSyncManager((IPeriodicShardSyncManager)dynamoDBStreamsPeriodicShardSyncManager).shardConsumerFactory((IShardConsumerFactory)new DynamoDBStreamsShardConsumerFactory()).kinesisProxy((IKinesisProxy)dynamoDBStreamsProxy).shardSyncer((ShardSyncer)shardSyncer).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager((ILeaseManager)kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider((LeaderDecider)leaderDecider).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient, ExecutorService execService) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), dynamoDBClient, config.getBillingMode());
        boolean isAuditorMode = config.getShardSyncStrategyType() != ShardSyncStrategyType.PERIODIC;
        DynamoDBStreamsProxy dynamoDBStreamsProxy = StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient);
        IMetricsFactory metricsFactory = Worker.getMetricsFactory((AmazonCloudWatch)cloudWatchClient, (KinesisClientLibConfiguration)config);
        DynamoDBStreamsShardSyncer shardSyncer = new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator());
        StreamsDeterministicShuffleShardSyncLeaderDecider leaderDecider = new StreamsDeterministicShuffleShardSyncLeaderDecider(config, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager);
        DynamoDBStreamsPeriodicShardSyncManager dynamoDBStreamsPeriodicShardSyncManager = new DynamoDBStreamsPeriodicShardSyncManager(config.getWorkerIdentifier(), leaderDecider, new ShardSyncTask((IKinesisProxy)dynamoDBStreamsProxy, (ILeaseManager)kinesisClientLeaseManager, config.getInitialPositionInStreamExtended(), config.shouldCleanupLeasesUponShardCompletion(), config.shouldIgnoreUnexpectedChildShards(), 0L, (ShardSyncer)shardSyncer, null), metricsFactory, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager, (IKinesisProxy)dynamoDBStreamsProxy, isAuditorMode, config.getLeasesRecoveryAuditorExecutionFrequencyMillis(), config.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).metricsFactory(metricsFactory).periodicShardSyncManager((IPeriodicShardSyncManager)dynamoDBStreamsPeriodicShardSyncManager).shardConsumerFactory((IShardConsumerFactory)new DynamoDBStreamsShardConsumerFactory()).execService(execService).kinesisProxy((IKinesisProxy)dynamoDBStreamsProxy).shardSyncer((ShardSyncer)shardSyncer).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager((ILeaseManager)kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider((LeaderDecider)leaderDecider).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), dynamoDBClient, config.getBillingMode());
        boolean isAuditorMode = config.getShardSyncStrategyType() != ShardSyncStrategyType.PERIODIC;
        DynamoDBStreamsProxy dynamoDBStreamsProxy = StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient);
        DynamoDBStreamsShardSyncer shardSyncer = new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator());
        StreamsDeterministicShuffleShardSyncLeaderDecider leaderDecider = new StreamsDeterministicShuffleShardSyncLeaderDecider(config, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager);
        DynamoDBStreamsPeriodicShardSyncManager dynamoDBStreamsPeriodicShardSyncManager = new DynamoDBStreamsPeriodicShardSyncManager(config.getWorkerIdentifier(), leaderDecider, new ShardSyncTask((IKinesisProxy)dynamoDBStreamsProxy, (ILeaseManager)kinesisClientLeaseManager, config.getInitialPositionInStreamExtended(), config.shouldCleanupLeasesUponShardCompletion(), config.shouldIgnoreUnexpectedChildShards(), 0L, (ShardSyncer)shardSyncer, null), metricsFactory, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager, (IKinesisProxy)dynamoDBStreamsProxy, isAuditorMode, config.getLeasesRecoveryAuditorExecutionFrequencyMillis(), config.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient(dynamoDBClient).metricsFactory(metricsFactory).periodicShardSyncManager((IPeriodicShardSyncManager)dynamoDBStreamsPeriodicShardSyncManager).shardConsumerFactory((IShardConsumerFactory)new DynamoDBStreamsShardConsumerFactory()).execService(execService).kinesisProxy((IKinesisProxy)dynamoDBStreamsProxy).shardSyncer((ShardSyncer)shardSyncer).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager((ILeaseManager)kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider((LeaderDecider)leaderDecider).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), (AmazonDynamoDB)dynamoDBClient, config.getBillingMode());
        boolean isAuditorMode = config.getShardSyncStrategyType() != ShardSyncStrategyType.PERIODIC;
        DynamoDBStreamsProxy dynamoDBStreamsProxy = StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient);
        IMetricsFactory metricsFactory = Worker.getMetricsFactory((AmazonCloudWatch)cloudWatchClient, (KinesisClientLibConfiguration)config);
        DynamoDBStreamsShardSyncer shardSyncer = new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator());
        StreamsDeterministicShuffleShardSyncLeaderDecider leaderDecider = new StreamsDeterministicShuffleShardSyncLeaderDecider(config, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager);
        DynamoDBStreamsPeriodicShardSyncManager dynamoDBStreamsPeriodicShardSyncManager = new DynamoDBStreamsPeriodicShardSyncManager(config.getWorkerIdentifier(), leaderDecider, new ShardSyncTask((IKinesisProxy)dynamoDBStreamsProxy, (ILeaseManager)kinesisClientLeaseManager, config.getInitialPositionInStreamExtended(), config.shouldCleanupLeasesUponShardCompletion(), config.shouldIgnoreUnexpectedChildShards(), 0L, (ShardSyncer)shardSyncer, null), metricsFactory, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager, (IKinesisProxy)dynamoDBStreamsProxy, isAuditorMode, config.getLeasesRecoveryAuditorExecutionFrequencyMillis(), config.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient((AmazonDynamoDB)dynamoDBClient).cloudWatchClient((AmazonCloudWatch)cloudWatchClient).metricsFactory(metricsFactory).periodicShardSyncManager((IPeriodicShardSyncManager)dynamoDBStreamsPeriodicShardSyncManager).shardConsumerFactory((IShardConsumerFactory)new DynamoDBStreamsShardConsumerFactory()).kinesisProxy((IKinesisProxy)dynamoDBStreamsProxy).shardSyncer((ShardSyncer)shardSyncer).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager((ILeaseManager)kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider((LeaderDecider)leaderDecider).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient, ExecutorService execService) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), (AmazonDynamoDB)dynamoDBClient, config.getBillingMode());
        boolean isAuditorMode = config.getShardSyncStrategyType() != ShardSyncStrategyType.PERIODIC;
        DynamoDBStreamsProxy dynamoDBStreamsProxy = StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient);
        IMetricsFactory metricsFactory = Worker.getMetricsFactory((AmazonCloudWatch)cloudWatchClient, (KinesisClientLibConfiguration)config);
        DynamoDBStreamsShardSyncer shardSyncer = new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator());
        StreamsDeterministicShuffleShardSyncLeaderDecider leaderDecider = new StreamsDeterministicShuffleShardSyncLeaderDecider(config, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager);
        DynamoDBStreamsPeriodicShardSyncManager dynamoDBStreamsPeriodicShardSyncManager = new DynamoDBStreamsPeriodicShardSyncManager(config.getWorkerIdentifier(), leaderDecider, new ShardSyncTask((IKinesisProxy)dynamoDBStreamsProxy, (ILeaseManager)kinesisClientLeaseManager, config.getInitialPositionInStreamExtended(), config.shouldCleanupLeasesUponShardCompletion(), config.shouldIgnoreUnexpectedChildShards(), 0L, (ShardSyncer)shardSyncer, null), metricsFactory, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager, (IKinesisProxy)dynamoDBStreamsProxy, isAuditorMode, config.getLeasesRecoveryAuditorExecutionFrequencyMillis(), config.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient((AmazonDynamoDB)dynamoDBClient).cloudWatchClient((AmazonCloudWatch)cloudWatchClient).metricsFactory(metricsFactory).periodicShardSyncManager((IPeriodicShardSyncManager)dynamoDBStreamsPeriodicShardSyncManager).shardConsumerFactory((IShardConsumerFactory)new DynamoDBStreamsShardConsumerFactory()).execService(execService).kinesisProxy((IKinesisProxy)dynamoDBStreamsProxy).shardSyncer((ShardSyncer)shardSyncer).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager((ILeaseManager)kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider((LeaderDecider)leaderDecider).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), (AmazonDynamoDB)dynamoDBClient, config.getBillingMode());
        boolean isAuditorMode = config.getShardSyncStrategyType() != ShardSyncStrategyType.PERIODIC;
        DynamoDBStreamsProxy dynamoDBStreamsProxy = StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient);
        DynamoDBStreamsShardSyncer shardSyncer = new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator());
        StreamsDeterministicShuffleShardSyncLeaderDecider leaderDecider = new StreamsDeterministicShuffleShardSyncLeaderDecider(config, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager);
        DynamoDBStreamsPeriodicShardSyncManager dynamoDBStreamsPeriodicShardSyncManager = new DynamoDBStreamsPeriodicShardSyncManager(config.getWorkerIdentifier(), leaderDecider, new ShardSyncTask((IKinesisProxy)dynamoDBStreamsProxy, (ILeaseManager)kinesisClientLeaseManager, config.getInitialPositionInStreamExtended(), config.shouldCleanupLeasesUponShardCompletion(), config.shouldIgnoreUnexpectedChildShards(), 0L, (ShardSyncer)shardSyncer, null), metricsFactory, (ILeaseManager<KinesisClientLease>)kinesisClientLeaseManager, (IKinesisProxy)dynamoDBStreamsProxy, isAuditorMode, config.getLeasesRecoveryAuditorExecutionFrequencyMillis(), config.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient((AmazonDynamoDB)dynamoDBClient).metricsFactory(metricsFactory).periodicShardSyncManager((IPeriodicShardSyncManager)dynamoDBStreamsPeriodicShardSyncManager).shardConsumerFactory((IShardConsumerFactory)new DynamoDBStreamsShardConsumerFactory()).execService(execService).kinesisProxy((IKinesisProxy)dynamoDBStreamsProxy).shardSyncer((ShardSyncer)shardSyncer).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager((ILeaseManager)kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider((LeaderDecider)leaderDecider).build();
    }

    private static DynamoDBStreamsProxy getDynamoDBStreamsProxy(KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient) {
        return new DynamoDBStreamsProxy.Builder(config.getStreamName(), config.getKinesisCredentialsProvider(), (AmazonKinesis)streamsClient).build();
    }

    private static <R, T extends AwsClientBuilder<T, R>> R createClient(T builder, AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, String endpointUrl, String region) {
        if (credentialsProvider != null) {
            builder.withCredentials(credentialsProvider);
        }
        if (clientConfiguration != null) {
            builder.withClientConfiguration(clientConfiguration);
        }
        if (!StringUtils.isNullOrEmpty((String)endpointUrl)) {
            LOG.warn((Object)("Received configuration for endpoint as " + endpointUrl + ", and region as " + region + "."));
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpointUrl, region));
        } else if (!StringUtils.isNullOrEmpty((String)region)) {
            LOG.warn((Object)("Received configuration for region as " + region + "."));
            builder.withRegion(region);
        } else {
            LOG.warn((Object)"No configuration received for endpoint and region, will default region to us-east-1");
            builder.withRegion(Regions.US_EAST_1);
        }
        return (R)builder.build();
    }
}

