/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.dynamodbv2.streamsadapter.StreamsWorkerFactory;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.multilang.MultiLangDaemon;
import com.amazonaws.services.kinesis.multilang.MultiLangDaemonConfig;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamsMultiLangDaemon {
    private static final Log LOG = LogFactory.getLog(StreamsMultiLangDaemon.class);

    public static void main(String[] args) {
        if (args.length == 0) {
            MultiLangDaemon.printUsage((PrintStream)System.err, (String)"You must provide a properties file");
            System.exit(1);
        }
        MultiLangDaemonConfig config = null;
        try {
            config = new MultiLangDaemonConfig(args[0]);
        }
        catch (IOException | IllegalArgumentException e) {
            MultiLangDaemon.printUsage((PrintStream)System.err, (String)"You must provide a valid properties file");
            System.exit(1);
        }
        ExecutorService executorService = config.getExecutorService();
        Worker worker = StreamsWorkerFactory.createDynamoDbStreamsWorker((IRecordProcessorFactory)config.getRecordProcessorFactory(), config.getKinesisClientLibConfiguration(), executorService);
        MultiLangDaemon daemon = new MultiLangDaemon(worker);
        Future future = executorService.submit(daemon);
        try {
            System.exit((Integer)future.get());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error((Object)"Encountered an error while running daemon", (Throwable)e);
        }
        System.exit(1);
    }
}

