/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import java.util.Optional;

public class GetLockOptions {
    private final String partitionKey;
    private final Optional<String> sortKey;
    private final boolean deleteLockOnRelease;

    public static GetLockOptionsBuilder builder(String partitionKey) {
        return new GetLockOptionsBuilder(partitionKey);
    }

    private GetLockOptions(String key, Optional<String> sortKey, boolean deleteLockOnRelease) {
        this.partitionKey = key;
        this.sortKey = sortKey;
        this.deleteLockOnRelease = deleteLockOnRelease;
    }

    String getPartitionKey() {
        return this.partitionKey;
    }

    Optional<String> getSortKey() {
        return this.sortKey;
    }

    boolean isDeleteLockOnRelease() {
        return this.deleteLockOnRelease;
    }

    public static class GetLockOptionsBuilder {
        private String partitionKey;
        private Optional<String> sortKey = Optional.empty();
        private boolean deleteLockOnRelease = false;

        GetLockOptionsBuilder(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public GetLockOptionsBuilder withSortKey(String sortKey) {
            this.sortKey = Optional.ofNullable(sortKey);
            return this;
        }

        public GetLockOptionsBuilder withDeleteLockOnRelease(boolean deleteLockOnRelease) {
            this.deleteLockOnRelease = deleteLockOnRelease;
            return this;
        }

        public GetLockOptions build() {
            return new GetLockOptions(this.partitionKey, this.sortKey, this.deleteLockOnRelease);
        }

        public String toString() {
            return "GetLockOptions.GetLockOptionsBuilder(partitionKey=" + this.partitionKey + ", sortKey=" + this.sortKey + ", deleteLockOnRelease=" + this.deleteLockOnRelease + ")";
        }
    }
}

