/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.services.dynamodbv2.SessionMonitor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class AcquireLockOptions {
    private final String partitionKey;
    private final Optional<String> sortKey;
    private final Optional<ByteBuffer> data;
    private final Boolean replaceData;
    private final Boolean deleteLockOnRelease;
    private final Boolean acquireOnlyIfLockAlreadyExists;
    private final Long refreshPeriod;
    private final Long additionalTimeToWaitForLock;
    private final TimeUnit timeUnit;
    private final Map<String, AttributeValue> additionalAttributes;
    private final Boolean updateExistingLockRecord;
    private final Boolean acquireReleasedLocksConsistently;
    private final Optional<SessionMonitor> sessionMonitor;
    private final Boolean reentrant;
    private final boolean shouldSkipBlockingWait;

    public static AcquireLockOptionsBuilder builder(String partitionKey) {
        return new AcquireLockOptionsBuilder(partitionKey);
    }

    private AcquireLockOptions(String partitionKey, Optional<String> sortKey, Optional<ByteBuffer> data, Boolean replaceData, Boolean deleteLockOnRelease, Boolean acquireOnlyIfLockAlreadyExists, Long refreshPeriod, Long additionalTimeToWaitForLock, TimeUnit timeUnit, Map<String, AttributeValue> additionalAttributes, Optional<SessionMonitor> sessionMonitor, Boolean updateExistingLockRecord, Boolean shouldSkipBlockingWait, Boolean acquireReleasedLocksConsistently, Boolean reentrant) {
        this.partitionKey = partitionKey;
        this.sortKey = sortKey;
        this.data = data;
        this.replaceData = replaceData;
        this.deleteLockOnRelease = deleteLockOnRelease;
        this.acquireOnlyIfLockAlreadyExists = acquireOnlyIfLockAlreadyExists;
        this.refreshPeriod = refreshPeriod;
        this.additionalTimeToWaitForLock = additionalTimeToWaitForLock;
        this.timeUnit = timeUnit;
        this.additionalAttributes = additionalAttributes;
        this.sessionMonitor = sessionMonitor;
        this.updateExistingLockRecord = updateExistingLockRecord;
        this.shouldSkipBlockingWait = shouldSkipBlockingWait;
        this.acquireReleasedLocksConsistently = acquireReleasedLocksConsistently;
        this.reentrant = reentrant;
    }

    String getPartitionKey() {
        return this.partitionKey;
    }

    Optional<String> getSortKey() {
        return this.sortKey;
    }

    Optional<ByteBuffer> getData() {
        return this.data;
    }

    Boolean getReplaceData() {
        return this.replaceData;
    }

    Boolean getDeleteLockOnRelease() {
        return this.deleteLockOnRelease;
    }

    Boolean getUpdateExistingLockRecord() {
        return this.updateExistingLockRecord;
    }

    Boolean getAcquireReleasedLocksConsistently() {
        return this.acquireReleasedLocksConsistently;
    }

    Boolean getAcquireOnlyIfLockAlreadyExists() {
        return this.acquireOnlyIfLockAlreadyExists;
    }

    Long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    Long getAdditionalTimeToWaitForLock() {
        return this.additionalTimeToWaitForLock;
    }

    TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    Boolean getReentrant() {
        return this.reentrant;
    }

    Map<String, AttributeValue> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    Optional<SessionMonitor> getSessionMonitor() {
        return this.sessionMonitor;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof AcquireLockOptions)) {
            return false;
        }
        AcquireLockOptions otherOptions = (AcquireLockOptions)other;
        return Objects.equals(this.partitionKey, otherOptions.partitionKey) && Objects.equals(this.sortKey, otherOptions.sortKey) && Objects.equals(this.data, otherOptions.data) && Objects.equals(this.replaceData, otherOptions.replaceData) && Objects.equals(this.deleteLockOnRelease, otherOptions.deleteLockOnRelease) && Objects.equals(this.acquireOnlyIfLockAlreadyExists, otherOptions.acquireOnlyIfLockAlreadyExists) && Objects.equals(this.refreshPeriod, otherOptions.refreshPeriod) && Objects.equals(this.additionalTimeToWaitForLock, otherOptions.additionalTimeToWaitForLock) && Objects.equals((Object)this.timeUnit, (Object)otherOptions.timeUnit) && Objects.equals(this.additionalAttributes, otherOptions.additionalAttributes) && Objects.equals(this.sessionMonitor, otherOptions.sessionMonitor) && Objects.equals(this.updateExistingLockRecord, otherOptions.updateExistingLockRecord) && Objects.equals(this.shouldSkipBlockingWait, otherOptions.shouldSkipBlockingWait) && Objects.equals(this.acquireReleasedLocksConsistently, otherOptions.acquireReleasedLocksConsistently) && Objects.equals(this.reentrant, otherOptions.reentrant);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitionKey, this.sortKey, this.data, this.replaceData, this.deleteLockOnRelease, this.acquireOnlyIfLockAlreadyExists, this.refreshPeriod, this.additionalTimeToWaitForLock, this.timeUnit, this.additionalAttributes, this.sessionMonitor, this.updateExistingLockRecord, this.shouldSkipBlockingWait, this.acquireReleasedLocksConsistently, this.reentrant});
    }

    public boolean shouldSkipBlockingWait() {
        return this.shouldSkipBlockingWait;
    }

    public static class AcquireLockOptionsBuilder {
        private String partitionKey;
        private Optional<String> sortKey;
        private Optional<ByteBuffer> data;
        private Boolean replaceData;
        private Boolean deleteLockOnRelease;
        private Boolean acquireOnlyIfLockAlreadyExists;
        private Long refreshPeriod;
        private Long additionalTimeToWaitForLock;
        private TimeUnit timeUnit;
        private Map<String, AttributeValue> additionalAttributes;
        private Boolean updateExistingLockRecord;
        private Boolean acquireReleasedLocksConsistently;
        private Boolean reentrant;
        private long safeTimeWithoutHeartbeat;
        private Optional<Runnable> sessionMonitorCallback;
        private boolean isSessionMonitorSet = false;
        private boolean shouldSkipBlockingWait;

        AcquireLockOptionsBuilder(String partitionKey) {
            this.partitionKey = partitionKey;
            this.additionalAttributes = new HashMap<String, AttributeValue>();
            this.sortKey = Optional.empty();
            this.data = Optional.empty();
            this.replaceData = true;
            this.deleteLockOnRelease = true;
            this.acquireOnlyIfLockAlreadyExists = false;
            this.updateExistingLockRecord = false;
            this.shouldSkipBlockingWait = false;
            this.acquireReleasedLocksConsistently = false;
            this.reentrant = false;
        }

        public AcquireLockOptionsBuilder withSortKey(String sortKey) {
            this.sortKey = Optional.of(sortKey);
            return this;
        }

        public AcquireLockOptionsBuilder withData(ByteBuffer data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public AcquireLockOptionsBuilder withReplaceData(Boolean replaceData) {
            this.replaceData = replaceData;
            return this;
        }

        public AcquireLockOptionsBuilder withDeleteLockOnRelease(Boolean deleteLockOnRelease) {
            this.deleteLockOnRelease = deleteLockOnRelease;
            return this;
        }

        public AcquireLockOptionsBuilder withAcquireOnlyIfLockAlreadyExists(Boolean acquireOnlyIfLockAlreadyExists) {
            this.acquireOnlyIfLockAlreadyExists = acquireOnlyIfLockAlreadyExists;
            return this;
        }

        public AcquireLockOptionsBuilder withRefreshPeriod(Long refreshPeriod) {
            this.refreshPeriod = refreshPeriod;
            return this;
        }

        public AcquireLockOptionsBuilder withAdditionalTimeToWaitForLock(Long additionalTimeToWaitForLock) {
            this.additionalTimeToWaitForLock = additionalTimeToWaitForLock;
            return this;
        }

        public AcquireLockOptionsBuilder withTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public AcquireLockOptionsBuilder withAdditionalAttributes(Map<String, AttributeValue> additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public AcquireLockOptionsBuilder withUpdateExistingLockRecord(Boolean updateExistingLockRecord) {
            this.updateExistingLockRecord = updateExistingLockRecord;
            return this;
        }

        public AcquireLockOptionsBuilder withShouldSkipBlockingWait(boolean shouldSkipBlockingWait) {
            this.shouldSkipBlockingWait = shouldSkipBlockingWait;
            return this;
        }

        public AcquireLockOptionsBuilder withAcquireReleasedLocksConsistently(boolean acquireReleasedLocksConsistently) {
            this.acquireReleasedLocksConsistently = acquireReleasedLocksConsistently;
            return this;
        }

        public AcquireLockOptionsBuilder withReentrant(boolean reentrant) {
            this.reentrant = reentrant;
            return this;
        }

        public AcquireLockOptionsBuilder withSessionMonitor(long safeTimeWithoutHeartbeat, Optional<Runnable> sessionMonitorCallback) {
            this.safeTimeWithoutHeartbeat = safeTimeWithoutHeartbeat;
            this.sessionMonitorCallback = sessionMonitorCallback;
            this.isSessionMonitorSet = true;
            return this;
        }

        public AcquireLockOptions build() {
            Optional<Object> sessionMonitor;
            if (this.isSessionMonitorSet) {
                Objects.requireNonNull(this.timeUnit, "timeUnit must not be null if sessionMonitor is non-null");
                sessionMonitor = Optional.of(new SessionMonitor(this.timeUnit.toMillis(this.safeTimeWithoutHeartbeat), this.sessionMonitorCallback));
            } else {
                sessionMonitor = Optional.empty();
            }
            return new AcquireLockOptions(this.partitionKey, this.sortKey, this.data, this.replaceData, this.deleteLockOnRelease, this.acquireOnlyIfLockAlreadyExists, this.refreshPeriod, this.additionalTimeToWaitForLock, this.timeUnit, this.additionalAttributes, sessionMonitor, this.updateExistingLockRecord, this.shouldSkipBlockingWait, this.acquireReleasedLocksConsistently, this.reentrant);
        }

        public String toString() {
            return "AcquireLockOptions.AcquireLockOptionsBuilder(key=" + this.partitionKey + ", sortKey=" + this.sortKey + ", data=" + this.data + ", replaceData=" + this.replaceData + ", deleteLockOnRelease=" + this.deleteLockOnRelease + ", refreshPeriod=" + this.refreshPeriod + ", additionalTimeToWaitForLock=" + this.additionalTimeToWaitForLock + ", timeUnit=" + (Object)((Object)this.timeUnit) + ", additionalAttributes=" + this.additionalAttributes + ", safeTimeWithoutHeartbeat=" + this.safeTimeWithoutHeartbeat + ", sessionMonitorCallback=" + this.sessionMonitorCallback + ", acquireReleasedLocksConsistently=" + this.acquireReleasedLocksConsistently + ", reentrant=" + this.reentrant + ")";
        }
    }
}

