/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codedeploy;

import com.amazonaws.codedeploy.AWSClients;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.codedeploy.model.BundleType;
import com.amazonaws.services.codedeploy.model.CreateDeploymentRequest;
import com.amazonaws.services.codedeploy.model.CreateDeploymentResult;
import com.amazonaws.services.codedeploy.model.DeploymentInfo;
import com.amazonaws.services.codedeploy.model.DeploymentOverview;
import com.amazonaws.services.codedeploy.model.DeploymentStatus;
import com.amazonaws.services.codedeploy.model.GetDeploymentRequest;
import com.amazonaws.services.codedeploy.model.ListApplicationsResult;
import com.amazonaws.services.codedeploy.model.ListDeploymentGroupsRequest;
import com.amazonaws.services.codedeploy.model.ListDeploymentGroupsResult;
import com.amazonaws.services.codedeploy.model.RegisterApplicationRevisionRequest;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import com.amazonaws.services.codedeploy.model.RevisionLocationType;
import com.amazonaws.services.codedeploy.model.S3Location;
import com.amazonaws.services.s3.model.PutObjectResult;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.DirScanner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AWSCodeDeployPublisher
extends Publisher
implements SimpleBuildStep {
    public static final long DEFAULT_TIMEOUT_SECONDS = 900L;
    public static final long DEFAULT_POLLING_FREQUENCY_SECONDS = 15L;
    public static final String ROLE_SESSION_NAME = "jenkins-codedeploy-plugin";
    private static final Regions[] AVAILABLE_REGIONS = new Regions[]{Regions.AP_NORTHEAST_1, Regions.AP_SOUTHEAST_1, Regions.AP_SOUTHEAST_2, Regions.EU_WEST_1, Regions.US_EAST_1, Regions.US_WEST_2, Regions.EU_CENTRAL_1, Regions.US_WEST_1, Regions.SA_EAST_1, Regions.AP_NORTHEAST_2, Regions.AP_SOUTH_1, Regions.US_EAST_2, Regions.CA_CENTRAL_1, Regions.EU_WEST_2, Regions.CN_NORTH_1};
    private final String s3bucket;
    private final String s3prefix;
    private final String applicationName;
    private final String deploymentGroupName;
    private final String deploymentConfig;
    private final Long pollingTimeoutSec;
    private final Long pollingFreqSec;
    private final boolean deploymentGroupAppspec;
    private final boolean waitForCompletion;
    private final String externalId;
    private final String iamRoleArn;
    private final String region;
    private final String includes;
    private final String excludes;
    private final String subdirectory;
    private final String proxyHost;
    private final int proxyPort;
    private final String awsAccessKey;
    private final String awsSecretKey;
    private final String credentials;
    private final String deploymentMethod;
    private final String versionFileName;
    private PrintStream logger;
    private Map<String, String> envVars;

    @DataBoundConstructor
    public AWSCodeDeployPublisher(String s3bucket, String s3prefix, String applicationName, String deploymentGroupName, String deploymentConfig, String region, Boolean deploymentGroupAppspec, Boolean waitForCompletion, Long pollingTimeoutSec, Long pollingFreqSec, String credentials, String versionFileName, String deploymentMethod, String awsAccessKey, String awsSecretKey, String iamRoleArn, String externalId, String includes, String proxyHost, int proxyPort, String excludes, String subdirectory) {
        this.externalId = externalId;
        this.applicationName = applicationName;
        this.deploymentGroupName = deploymentGroupName;
        this.deploymentConfig = deploymentConfig != null && deploymentConfig.length() == 0 ? null : deploymentConfig;
        this.region = region;
        this.includes = includes;
        this.excludes = excludes;
        this.subdirectory = subdirectory;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.credentials = credentials;
        this.deploymentMethod = deploymentMethod;
        this.versionFileName = versionFileName;
        this.awsAccessKey = awsAccessKey;
        this.awsSecretKey = awsSecretKey;
        this.iamRoleArn = iamRoleArn;
        this.deploymentGroupAppspec = deploymentGroupAppspec;
        if (waitForCompletion != null && waitForCompletion.booleanValue()) {
            this.waitForCompletion = waitForCompletion;
            this.pollingTimeoutSec = pollingTimeoutSec == null ? Long.valueOf(900L) : pollingTimeoutSec;
            this.pollingFreqSec = pollingFreqSec == null ? Long.valueOf(15L) : pollingFreqSec;
        } else {
            this.waitForCompletion = false;
            this.pollingTimeoutSec = null;
            this.pollingFreqSec = null;
        }
        this.s3bucket = s3bucket;
        this.s3prefix = s3prefix == null || s3prefix.equals("/") || s3prefix.length() == 0 ? "" : s3prefix;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        boolean buildFailed;
        this.logger = listener.getLogger();
        this.envVars = build.getEnvironment(listener);
        boolean bl = buildFailed = build.getResult() == Result.FAILURE;
        if (buildFailed) {
            this.logger.println("Skipping CodeDeploy publisher as build failed");
            return;
        }
        AWSClients aws = "awsAccessKey".equals(this.credentials) ? (StringUtils.isEmpty((String)this.awsAccessKey) && StringUtils.isEmpty((String)this.awsSecretKey) ? AWSClients.fromDefaultCredentialChain(this.region, this.proxyHost, this.proxyPort) : AWSClients.fromBasicCredentials(this.region, this.awsAccessKey, this.awsSecretKey, this.proxyHost, this.proxyPort)) : AWSClients.fromIAMRole(this.region, this.iamRoleArn, this.getDescriptor().getExternalId(), this.proxyHost, this.proxyPort);
        boolean success = false;
        try {
            this.verifyCodeDeployApplication(aws);
            String projectName = build.getDisplayName();
            if (workspace == null) {
                throw new IllegalArgumentException("No workspace present for the build.");
            }
            FilePath sourceDirectory = this.getSourceDirectory(workspace);
            RevisionLocation revisionLocation = this.zipAndUpload(aws, projectName, sourceDirectory);
            this.registerRevision(aws, revisionLocation);
            if ("onlyRevision".equals(this.deploymentMethod)) {
                success = true;
            } else {
                String deploymentId = this.createDeployment(aws, revisionLocation);
                success = this.waitForDeployment(aws, deploymentId);
            }
        }
        catch (Exception e) {
            this.logger.println("Failed CodeDeploy post-build step; exception follows.");
            this.logger.println(e.getMessage());
            e.printStackTrace(this.logger);
        }
        if (!success) {
            throw new AbortException();
        }
    }

    private FilePath getSourceDirectory(FilePath basePath) throws IOException, InterruptedException {
        FilePath sourcePath;
        String subdirectory = StringUtils.trimToEmpty((String)this.getSubdirectoryFromEnv());
        if (!subdirectory.isEmpty() && !subdirectory.startsWith("/")) {
            subdirectory = "/" + subdirectory;
        }
        if (!(sourcePath = basePath.withSuffix(subdirectory).absolutize()).isDirectory() || !this.isSubDirectory(basePath, sourcePath)) {
            throw new IllegalArgumentException("Provided path (resolved as '" + sourcePath + "') is not a subdirectory of the workspace (resolved as '" + basePath + "')");
        }
        return sourcePath;
    }

    private boolean isSubDirectory(FilePath parent, FilePath child) {
        for (FilePath parentFolder = child; parentFolder != null; parentFolder = parentFolder.getParent()) {
            if (!parent.equals((Object)parentFolder)) continue;
            return true;
        }
        return false;
    }

    private void verifyCodeDeployApplication(AWSClients aws) throws IllegalArgumentException {
        ListApplicationsResult applications = aws.codedeploy.listApplications();
        String applicationName = this.getApplicationNameFromEnv();
        String deploymentGroupName = this.getDeploymentGroupNameFromEnv();
        if (!applications.getApplications().contains(applicationName)) {
            throw new IllegalArgumentException("Cannot find application named '" + applicationName + "'");
        }
        ListDeploymentGroupsResult deploymentGroups = aws.codedeploy.listDeploymentGroups(new ListDeploymentGroupsRequest().withApplicationName(applicationName));
        if (!deploymentGroups.getDeploymentGroups().contains(deploymentGroupName)) {
            throw new IllegalArgumentException("Cannot find deployment group named '" + deploymentGroupName + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevisionLocation zipAndUpload(AWSClients aws, String projectName, FilePath sourceDirectory) throws IOException, InterruptedException, IllegalArgumentException {
        File zipFile = null;
        File versionFile = new File(sourceDirectory + "/" + this.versionFileName);
        String version = null;
        try (InputStreamReader reader = null;){
            reader = new InputStreamReader((InputStream)new FileInputStream(versionFile), "UTF-8");
            char[] chars = new char[(int)versionFile.length() - 1];
            reader.read(chars);
            version = new String(chars);
            reader.close();
        }
        if (version != null) {
            zipFile = new File("/tmp/" + projectName + "-" + version + ".zip");
            boolean fileCreated = zipFile.createNewFile();
            if (!fileCreated) {
                this.logger.println("File already exists, overwriting: " + zipFile.getPath());
            }
        } else {
            zipFile = File.createTempFile(projectName + "-", ".zip");
        }
        String deploymentGroupName = this.getDeploymentGroupNameFromEnv();
        String prefix = this.getS3PrefixFromEnv();
        String bucket = this.getS3BucketFromEnv();
        if (bucket.indexOf("/") > 0) {
            throw new IllegalArgumentException("S3 Bucket field cannot contain any subdirectories.  Bucket name only!");
        }
        try {
            String key;
            if (this.deploymentGroupAppspec) {
                File appspec = new File(sourceDirectory + "/appspec." + deploymentGroupName + ".yml");
                if (appspec.exists()) {
                    File dest = new File(sourceDirectory + "/appspec.yml");
                    FileUtils.copyFile((File)appspec, (File)dest);
                    this.logger.println("Use appspec." + deploymentGroupName + ".yml");
                }
                if (!appspec.exists()) {
                    throw new IllegalArgumentException("/appspec." + deploymentGroupName + ".yml file does not exist");
                }
            }
            this.logger.println("Zipping files into " + zipFile.getAbsolutePath());
            try (FileOutputStream outputStream = new FileOutputStream(zipFile);){
                sourceDirectory.zip((OutputStream)outputStream, (DirScanner)new DirScanner.Glob(this.includes, this.excludes));
            }
            if (prefix.isEmpty()) {
                key = zipFile.getName();
            } else {
                key = Util.replaceMacro((String)prefix, this.envVars);
                key = prefix.endsWith("/") ? key + zipFile.getName() : key + "/" + zipFile.getName();
            }
            this.logger.println("Uploading zip to s3://" + bucket + "/" + key);
            PutObjectResult s3result = aws.s3.putObject(bucket, key, zipFile);
            S3Location s3Location = new S3Location();
            s3Location.setBucket(bucket);
            s3Location.setKey(key);
            s3Location.setBundleType(BundleType.Zip);
            s3Location.setETag(s3result.getETag());
            RevisionLocation revisionLocation = new RevisionLocation();
            revisionLocation.setRevisionType(RevisionLocationType.S3);
            revisionLocation.setS3Location(s3Location);
            RevisionLocation revisionLocation2 = revisionLocation;
            return revisionLocation2;
        }
        finally {
            boolean deleted = zipFile.delete();
            if (!deleted) {
                this.logger.println("Failed to clean up file " + zipFile.getPath());
            }
        }
    }

    private void registerRevision(AWSClients aws, RevisionLocation revisionLocation) {
        String applicationName = this.getApplicationNameFromEnv();
        this.logger.println("Registering revision for application '" + applicationName + "'");
        aws.codedeploy.registerApplicationRevision(new RegisterApplicationRevisionRequest().withApplicationName(applicationName).withRevision(revisionLocation).withDescription("Application revision registered via Jenkins"));
    }

    private String createDeployment(AWSClients aws, RevisionLocation revisionLocation) throws Exception {
        this.logger.println("Creating deployment with revision at " + revisionLocation);
        CreateDeploymentResult createDeploymentResult = aws.codedeploy.createDeployment(new CreateDeploymentRequest().withDeploymentConfigName(this.getDeploymentConfigFromEnv()).withDeploymentGroupName(this.getDeploymentGroupNameFromEnv()).withApplicationName(this.getApplicationNameFromEnv()).withRevision(revisionLocation).withDescription("Deployment created by Jenkins"));
        return createDeploymentResult.getDeploymentId();
    }

    private boolean waitForDeployment(AWSClients aws, String deploymentId) throws InterruptedException {
        if (!this.waitForCompletion) {
            return true;
        }
        this.logger.println("Monitoring deployment with ID " + deploymentId + "...");
        GetDeploymentRequest deployInfoRequest = new GetDeploymentRequest();
        deployInfoRequest.setDeploymentId(deploymentId);
        DeploymentInfo deployStatus = aws.codedeploy.getDeployment(deployInfoRequest).getDeploymentInfo();
        long startTimeMillis = deployStatus == null || deployStatus.getStartTime() == null ? new Date().getTime() : deployStatus.getStartTime().getTime();
        boolean success = true;
        long pollingTimeoutMillis = this.pollingTimeoutSec * 1000L;
        long pollingFreqMillis = this.pollingFreqSec * 1000L;
        while (deployStatus == null || deployStatus.getCompleteTime() == null) {
            if (deployStatus == null) {
                this.logger.println("Deployment status: unknown.");
            } else {
                DeploymentOverview overview = deployStatus.getDeploymentOverview();
                this.logger.println("Deployment status: " + deployStatus.getStatus() + "; instances: " + overview);
            }
            deployStatus = aws.codedeploy.getDeployment(deployInfoRequest).getDeploymentInfo();
            Date now = new Date();
            if (now.getTime() - startTimeMillis >= pollingTimeoutMillis) {
                this.logger.println("Exceeded maximum polling time of " + pollingTimeoutMillis + " milliseconds.");
                success = false;
                break;
            }
            Thread.sleep(pollingFreqMillis);
        }
        this.logger.println("Deployment status: " + deployStatus.getStatus() + "; instances: " + deployStatus.getDeploymentOverview());
        if (!deployStatus.getStatus().equals(DeploymentStatus.Succeeded.toString())) {
            this.logger.println("Deployment did not succeed. Final status: " + deployStatus.getStatus());
            success = false;
        }
        return success;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getDeploymentGroupName() {
        return this.deploymentGroupName;
    }

    public String getDeploymentConfig() {
        return this.deploymentConfig;
    }

    public String getS3bucket() {
        return this.s3bucket;
    }

    public String getS3prefix() {
        return this.s3prefix;
    }

    public Long getPollingTimeoutSec() {
        return this.pollingTimeoutSec;
    }

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public Long getPollingFreqSec() {
        return this.pollingFreqSec;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getDeploymentMethod() {
        return this.deploymentMethod;
    }

    public String getVersionFileName() {
        return this.versionFileName;
    }

    public boolean getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public boolean getDeploymentGroupAppspec() {
        return this.deploymentGroupAppspec;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public String getRegion() {
        return this.region;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getApplicationNameFromEnv() {
        return Util.replaceMacro((String)this.applicationName, this.envVars);
    }

    public String getDeploymentGroupNameFromEnv() {
        return Util.replaceMacro((String)this.deploymentGroupName, this.envVars);
    }

    public String getDeploymentConfigFromEnv() {
        return Util.replaceMacro((String)this.deploymentConfig, this.envVars);
    }

    public String getS3BucketFromEnv() {
        return Util.replaceMacro((String)this.s3bucket, this.envVars);
    }

    public String getS3PrefixFromEnv() {
        return Util.replaceMacro((String)this.s3prefix, this.envVars);
    }

    public String getSubdirectoryFromEnv() {
        return Util.replaceMacro((String)this.subdirectory, this.envVars);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String externalId;
        private String awsAccessKey;
        private String awsSecretKey;
        private String proxyHost;
        private int proxyPort;

        public DescriptorImpl() {
            this.load();
            if (this.externalId == null) {
                this.setExternalId(UUID.randomUUID().toString());
            }
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please add the appropriate values");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Deploy an application to AWS CodeDeploy";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.awsAccessKey = formData.getString("awsAccessKey");
            this.awsSecretKey = formData.getString("awsSecretKey");
            this.proxyHost = formData.getString("proxyHost");
            this.proxyPort = Integer.parseInt(formData.getString("proxyPort"));
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }

        public String getExternalId() {
            return this.externalId;
        }

        public void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public String getAccountId() {
            return AWSClients.getAccountId(this.getProxyHost(), this.getProxyPort());
        }

        public FormValidation doTestConnection(@QueryParameter String s3bucket, @QueryParameter String applicationName, @QueryParameter String region, @QueryParameter String iamRoleArn, @QueryParameter String proxyHost, @QueryParameter int proxyPort) {
            System.out.println("Testing connection with parameters: " + s3bucket + "," + applicationName + "," + region + "," + iamRoleArn + "," + this.externalId + "," + proxyHost + "," + proxyPort);
            try {
                AWSClients awsClients = AWSClients.fromIAMRole(region, iamRoleArn, this.externalId, proxyHost, proxyPort);
                awsClients.testConnection(s3bucket, applicationName);
            }
            catch (Exception e) {
                return FormValidation.error((String)("Connection test failed with error: " + e.getMessage()));
            }
            return FormValidation.ok((String)"Connection test passed.");
        }

        public ListBoxModel doFillRegionItems() {
            ListBoxModel items = new ListBoxModel();
            for (Regions region : AVAILABLE_REGIONS) {
                items.add(region.toString(), region.getName());
            }
            return items;
        }

        public String getAwsSecretKey() {
            return this.awsSecretKey;
        }

        public void setAwsSecretKey(String awsSecretKey) {
            this.awsSecretKey = awsSecretKey;
        }

        public String getAwsAccessKey() {
            return this.awsAccessKey;
        }

        public void setAwsAccessKey(String awsAccessKey) {
            this.awsAccessKey = awsAccessKey;
        }
    }
}

