/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.sql;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.sql.SqlSubsegments;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class TracingStatement {
    private static final Log logger = LogFactory.getLog(TracingStatement.class);

    public static Statement decorateStatement(Statement statement) {
        return (Statement)Proxy.newProxyInstance(TracingStatement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new TracingStatementHandler(statement, null));
    }

    public static PreparedStatement decoratePreparedStatement(PreparedStatement statement, String sql) {
        return (PreparedStatement)Proxy.newProxyInstance(TracingStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new TracingStatementHandler(statement, sql));
    }

    public static CallableStatement decorateCallableStatement(CallableStatement statement, String sql) {
        return (CallableStatement)Proxy.newProxyInstance(TracingStatement.class.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new TracingStatementHandler(statement, sql));
    }

    private static class TracingStatementHandler
    implements InvocationHandler {
        private static final String EXECUTE = "execute";
        private static final String EXECUTE_QUERY = "executeQuery";
        private static final String EXECUTE_UPDATE = "executeUpdate";
        private static final String EXECUTE_BATCH = "executeBatch";
        private final Statement delegate;
        private final String sql;

        TracingStatementHandler(Statement statement, String sql) {
            this.delegate = statement;
            this.sql = sql;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Subsegment subsegment = null;
            if (this.isExecution(method)) {
                subsegment = this.createSubsegment();
            }
            logger.debug((Object)String.format("Invoking statement execution with X-Ray tracing. Tracing active: %s", subsegment != null));
            try {
                Object object = method.invoke((Object)this.delegate, args);
                return object;
            }
            catch (Throwable t) {
                Throwable rootThrowable = t;
                if (t instanceof InvocationTargetException) {
                    InvocationTargetException ite = (InvocationTargetException)t;
                    if (ite.getTargetException() != null) {
                        rootThrowable = ite.getTargetException();
                    } else if (ite.getCause() != null) {
                        rootThrowable = ite.getCause();
                    }
                }
                if (subsegment != null) {
                    subsegment.addException(rootThrowable);
                }
                throw rootThrowable;
            }
            finally {
                if (subsegment != null && this.isExecution(method)) {
                    AWSXRay.endSubsegment();
                }
            }
        }

        private boolean isExecution(Method method) {
            return EXECUTE.equals(method.getName()) || EXECUTE_QUERY.equals(method.getName()) || EXECUTE_UPDATE.equals(method.getName()) || EXECUTE_BATCH.equals(method.getName());
        }

        private Subsegment createSubsegment() {
            try {
                return SqlSubsegments.forQuery(this.delegate.getConnection(), null);
            }
            catch (SQLException exception) {
                logger.warn((Object)"Failed to create X-Ray subsegment for the statement execution.", (Throwable)exception);
                return null;
            }
        }
    }
}

