/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.sql;

import com.amazonaws.xray.sql.ConnectionInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class OracleConnectionUrlParser {
    private static final Log log = LogFactory.getLog(OracleConnectionUrlParser.class);
    private static final Pattern HOST_PATTERN = Pattern.compile("\\(\\s*host\\s*=\\s*([^ )]+)\\s*\\)");
    private static final Pattern INSTANCE_PATTERN = Pattern.compile("\\(\\s*service_name\\s*=\\s*([^ )]+)\\s*\\)");

    static ConnectionInfo parseUrl(String jdbcUrl, ConnectionInfo.Builder builder) {
        jdbcUrl = jdbcUrl.toLowerCase();
        OracleConnectionUrlParser.recordSanitizedUrl(jdbcUrl, builder);
        int subtypeEndIndex = jdbcUrl.indexOf(":", "jdbc:oracle:".length());
        if (subtypeEndIndex < 0) {
            return builder.build();
        }
        if ((jdbcUrl = jdbcUrl.substring(subtypeEndIndex + 1)).contains("@")) {
            return OracleConnectionUrlParser.parseUrlWithAt(jdbcUrl, builder).build();
        }
        return OracleConnectionUrlParser.parseOracleConnectInfo(jdbcUrl, builder).build();
    }

    private static ConnectionInfo.Builder recordSanitizedUrl(String jdbcUrl, ConnectionInfo.Builder builder) {
        int atLoc = jdbcUrl.indexOf("@");
        int userEndLoc = jdbcUrl.indexOf("/");
        if (userEndLoc != -1 && userEndLoc < atLoc) {
            builder.sanitizedUrl(jdbcUrl.substring(0, userEndLoc) + jdbcUrl.substring(atLoc));
        } else {
            builder.sanitizedUrl(jdbcUrl);
        }
        return builder;
    }

    private static ConnectionInfo.Builder parseOracleConnectInfo(String jdbcUrl, ConnectionInfo.Builder builder) {
        String instance;
        String host;
        int hostEnd = jdbcUrl.indexOf(":");
        int instanceLoc = jdbcUrl.indexOf("/");
        if (hostEnd > 0) {
            host = jdbcUrl.substring(0, hostEnd);
            int afterHostEnd = jdbcUrl.indexOf(":", hostEnd + 1);
            if (afterHostEnd > 0) {
                instance = jdbcUrl.substring(afterHostEnd + 1);
            } else if (instanceLoc > 0) {
                instance = jdbcUrl.substring(instanceLoc + 1);
            } else {
                String portOrInstance = jdbcUrl.substring(hostEnd + 1);
                Integer parsedPort = null;
                try {
                    parsedPort = Integer.parseInt(portOrInstance);
                }
                catch (NumberFormatException e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                instance = parsedPort == null ? portOrInstance : null;
            }
        } else if (instanceLoc > 0) {
            host = jdbcUrl.substring(0, instanceLoc);
            instance = jdbcUrl.substring(instanceLoc + 1);
        } else {
            if (jdbcUrl.isEmpty()) {
                return builder;
            }
            host = null;
            instance = jdbcUrl;
        }
        if (host != null) {
            builder.host(host);
        }
        return builder.dbName(instance);
    }

    private static ConnectionInfo.Builder parseUrlWithAt(String jdbcUrl, ConnectionInfo.Builder builder) {
        if (jdbcUrl.contains("@(description")) {
            return OracleConnectionUrlParser.parseDescription(jdbcUrl, builder);
        }
        String[] atSplit = jdbcUrl.split("@", 2);
        int userInfoLoc = atSplit[0].indexOf("/");
        String user = userInfoLoc > 0 ? atSplit[0].substring(0, userInfoLoc) : null;
        String connectInfo = atSplit[1];
        int hostStart = connectInfo.startsWith("//") ? "//".length() : (connectInfo.startsWith("ldap://") ? "ldap://".length() : 0);
        if (user != null) {
            builder.user(user);
        }
        return OracleConnectionUrlParser.parseOracleConnectInfo(connectInfo.substring(hostStart), builder);
    }

    private static ConnectionInfo.Builder parseDescription(String jdbcUrl, ConnectionInfo.Builder builder) {
        Matcher instanceMatcher;
        Matcher hostMatcher;
        String[] atSplit = jdbcUrl.split("@", 2);
        int userInfoLoc = atSplit[0].indexOf("/");
        if (userInfoLoc > 0) {
            builder.user(atSplit[0].substring(0, userInfoLoc));
        }
        if ((hostMatcher = HOST_PATTERN.matcher(atSplit[1])).find()) {
            builder.host(hostMatcher.group(1));
        }
        if ((instanceMatcher = INSTANCE_PATTERN.matcher(atSplit[1])).find()) {
            builder.dbName(instanceMatcher.group(1));
        }
        return builder;
    }

    private OracleConnectionUrlParser() {
    }
}

