/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.spring.aop;

import com.amazonaws.xray.spring.aop.BaseAbstractXRayInterceptor;
import com.amazonaws.xray.spring.aop.XRayEnabled;
import com.amazonaws.xray.spring.aop.XRayInterceptorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;

public abstract class AbstractXRayInterceptor
extends BaseAbstractXRayInterceptor {
    private static final Log logger = LogFactory.getLog(AbstractXRayInterceptor.class);

    @Pointcut(value="execution(public !void org.springframework.data.repository.Repository+.*(..))")
    protected void springRepositories() {
    }

    @Around(value="springRepositories()")
    public Object traceAroundRepositoryMethods(ProceedingJoinPoint pjp) throws Throwable {
        logger.trace((Object)"Advising repository");
        boolean hasClassAnnotation = false;
        for (Class<?> i : pjp.getTarget().getClass().getInterfaces()) {
            if (i.getAnnotation(XRayEnabled.class) == null) continue;
            hasClassAnnotation = true;
            break;
        }
        if (hasClassAnnotation) {
            return this.processXRayTrace(pjp);
        }
        return XRayInterceptorUtils.conditionalProceed(pjp);
    }
}

