/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.handlers;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.ThreadLocalStorage;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Namespace;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.TraceHeader;
import com.amazonaws.xray.handlers.config.AWSOperationHandler;
import com.amazonaws.xray.handlers.config.AWSOperationHandlerManifest;
import com.amazonaws.xray.handlers.config.AWSServiceHandlerManifest;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TracingHandler
extends RequestHandler2 {
    private static final Log logger = LogFactory.getLog(TracingHandler.class);
    private AWSServiceHandlerManifest awsServiceHandlerManifest;
    private ObjectMapper mapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    private static final URL DEFAULT_OPERATION_PARAMETER_WHITELIST = TracingHandler.class.getResource("/com/amazonaws/xray/handlers/DefaultOperationParameterWhitelist.json");
    private final String accountId;
    private AWSXRayRecorder recorder;
    private static final String REGEX = "([a-z])([A-Z]+)";
    private static final String REPLACE = "$1_$2";

    private void initRequestManifest(URL operationParameterWhitelist) {
        if (null != operationParameterWhitelist) {
            try {
                this.awsServiceHandlerManifest = (AWSServiceHandlerManifest)this.mapper.readValue(operationParameterWhitelist, AWSServiceHandlerManifest.class);
                return;
            }
            catch (IOException e) {
                logger.error((Object)("Unable to parse operation parameter whitelist at " + operationParameterWhitelist.getPath() + ". Falling back to default operation parameter whitelist at " + DEFAULT_OPERATION_PARAMETER_WHITELIST.getPath() + "."), (Throwable)e);
            }
        }
        try {
            this.awsServiceHandlerManifest = (AWSServiceHandlerManifest)this.mapper.readValue(DEFAULT_OPERATION_PARAMETER_WHITELIST, AWSServiceHandlerManifest.class);
        }
        catch (IOException e) {
            logger.error((Object)("Unable to parse default operation parameter whitelist at " + DEFAULT_OPERATION_PARAMETER_WHITELIST.getPath() + ". This will affect this handler's ability to capture AWS operation parameter information."), (Throwable)e);
        }
    }

    public TracingHandler() {
        this(AWSXRay.getGlobalRecorder(), null, null);
    }

    public TracingHandler(AWSXRayRecorder recorder) {
        this(recorder, null, null);
    }

    public TracingHandler(String accountId) {
        this(AWSXRay.getGlobalRecorder(), accountId, null);
    }

    public TracingHandler(AWSXRayRecorder recorder, String accountId) {
        this(recorder, accountId, null);
    }

    public TracingHandler(URL operationParameterWhitelist) {
        this(AWSXRay.getGlobalRecorder(), null, operationParameterWhitelist);
    }

    public TracingHandler(AWSXRayRecorder recorder, URL operationParameterWhitelist) {
        this(recorder, null, operationParameterWhitelist);
    }

    public TracingHandler(String accountId, URL operationParameterWhitelist) {
        this(AWSXRay.getGlobalRecorder(), accountId, operationParameterWhitelist);
    }

    public TracingHandler(AWSXRayRecorder recorder, String accountId, URL operationParameterWhitelist) {
        this.recorder = recorder;
        this.accountId = accountId;
        this.initRequestManifest(operationParameterWhitelist);
    }

    private boolean isSubsegmentDuplicate(Entity entity, Request<?> request) {
        return null != entity && Namespace.AWS.toString().equals(entity.getNamespace()) && null != this.extractServiceName(request) && this.extractServiceName(request).equals(entity.getName());
    }

    public void beforeRequest(Request<?> request) {
        if (this.isSubsegmentDuplicate(ThreadLocalStorage.get(), request)) {
            return;
        }
        Subsegment currentSubsegment = this.recorder.beginSubsegment(this.extractServiceName(request));
        currentSubsegment.putAllAws(this.extractRequestParameters(request));
        currentSubsegment.putAws("operation", (Object)this.extractOperationName(request));
        if (null != this.accountId) {
            currentSubsegment.putAws("account_id", (Object)this.accountId);
        }
        currentSubsegment.setNamespace(Namespace.AWS.toString());
        TraceHeader header = new TraceHeader(this.recorder.getCurrentSegment().getTraceId(), this.recorder.getCurrentSegment().isSampled() ? currentSubsegment.getId() : null, this.recorder.getCurrentSegment().isSampled() ? TraceHeader.SampleDecision.SAMPLED : TraceHeader.SampleDecision.NOT_SAMPLED);
        request.addHeader("X-Amzn-Trace-Id", header.toString());
    }

    private String extractServiceName(Request<?> request) {
        return request.getServiceName();
    }

    private String extractOperationName(Request<?> request) {
        String ret = request.getOriginalRequest().getClass().getSimpleName();
        ret = ret.substring(0, ret.length() - 7);
        return ret;
    }

    private static String toSnakeCase(String camelCase) {
        return camelCase.replaceAll(REGEX, REPLACE).toLowerCase();
    }

    private HashMap<String, Object> extractRequestParameters(Request<?> request) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (null == this.awsServiceHandlerManifest) {
            return ret;
        }
        AWSOperationHandlerManifest serviceHandler = this.awsServiceHandlerManifest.getOperationHandlerManifest(this.extractServiceName(request));
        if (null == serviceHandler) {
            return ret;
        }
        AWSOperationHandler operationHandler = serviceHandler.getOperationHandler(this.extractOperationName(request));
        if (null == operationHandler) {
            return ret;
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (null != operationHandler.getRequestParameters()) {
            operationHandler.getRequestParameters().forEach(parameterName -> {
                try {
                    Object parameterValue = originalRequest.getClass().getMethod("get" + parameterName, new Class[0]).invoke(originalRequest, new Object[0]);
                    if (null != parameterValue) {
                        ret.put(TracingHandler.toSnakeCase(parameterName), parameterValue);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error((Object)("Error getting request parameter: " + parameterName), (Throwable)e);
                }
            });
        }
        if (null != operationHandler.getRequestDescriptors()) {
            operationHandler.getRequestDescriptors().forEach((requestKeyName, requestDescriptor) -> {
                try {
                    List parameterValue;
                    if (requestDescriptor.isMap() && requestDescriptor.shouldGetKeys()) {
                        Map parameterValue2 = (Map)originalRequest.getClass().getMethod("get" + requestKeyName, new Class[0]).invoke(originalRequest, new Object[0]);
                        if (null != parameterValue2) {
                            String renameTo = null != requestDescriptor.getRenameTo() ? requestDescriptor.getRenameTo() : requestKeyName;
                            ret.put(TracingHandler.toSnakeCase(renameTo), parameterValue2.keySet());
                        }
                    } else if (requestDescriptor.isList() && requestDescriptor.shouldGetCount() && null != (parameterValue = (List)originalRequest.getClass().getMethod("get" + requestKeyName, new Class[0]).invoke(originalRequest, new Object[0]))) {
                        String renameTo = null != requestDescriptor.getRenameTo() ? requestDescriptor.getRenameTo() : requestKeyName;
                        ret.put(TracingHandler.toSnakeCase(renameTo), parameterValue.size());
                    }
                }
                catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error((Object)("Error getting request parameter: " + requestKeyName), (Throwable)e);
                }
            });
        }
        return ret;
    }

    private HashMap<String, Object> extractResponseParameters(Request<?> request, Object response) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (null == this.awsServiceHandlerManifest) {
            return ret;
        }
        AWSOperationHandlerManifest serviceHandler = this.awsServiceHandlerManifest.getOperationHandlerManifest(this.extractServiceName(request));
        if (null == serviceHandler) {
            return ret;
        }
        AWSOperationHandler operationHandler = serviceHandler.getOperationHandler(this.extractOperationName(request));
        if (null == operationHandler) {
            return ret;
        }
        if (null != operationHandler.getResponseParameters()) {
            operationHandler.getResponseParameters().forEach(parameterName -> {
                try {
                    Object parameterValue = response.getClass().getMethod("get" + parameterName, new Class[0]).invoke(response, new Object[0]);
                    if (null != parameterValue) {
                        ret.put(TracingHandler.toSnakeCase(parameterName), parameterValue);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error((Object)("Error getting response parameter: " + parameterName), (Throwable)e);
                }
            });
        }
        if (null != operationHandler.getResponseDescriptors()) {
            operationHandler.getResponseDescriptors().forEach((responseKeyName, responseDescriptor) -> {
                try {
                    List parameterValue;
                    if (responseDescriptor.isMap() && responseDescriptor.shouldGetKeys()) {
                        Map parameterValue2 = (Map)response.getClass().getMethod("get" + responseKeyName, new Class[0]).invoke(response, new Object[0]);
                        if (null != parameterValue2) {
                            String renameTo = null != responseDescriptor.getRenameTo() ? responseDescriptor.getRenameTo() : responseKeyName;
                            ret.put(TracingHandler.toSnakeCase(renameTo), parameterValue2.keySet());
                        }
                    } else if (responseDescriptor.isList() && responseDescriptor.shouldGetCount() && null != (parameterValue = (List)response.getClass().getMethod("get" + responseKeyName, new Class[0]).invoke(response, new Object[0]))) {
                        String renameTo = null != responseDescriptor.getRenameTo() ? responseDescriptor.getRenameTo() : responseKeyName;
                        ret.put(TracingHandler.toSnakeCase(renameTo), parameterValue.size());
                    }
                }
                catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error((Object)("Error getting request parameter: " + responseKeyName), (Throwable)e);
                }
            });
        }
        return ret;
    }

    public HashMap<String, Object> extractHttpResponseInformation(HttpResponse httpResponse) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HashMap<String, Number> response = new HashMap<String, Number>();
        response.put("status", httpResponse.getStatusCode());
        try {
            if (null != httpResponse.getHeaders().get("Content-Length")) {
                response.put("content_length", Long.parseLong((String)httpResponse.getHeaders().get("Content-Length")));
            }
        }
        catch (NumberFormatException nfe) {
            logger.warn((Object)"Unable to parse Content-Length header.", (Throwable)nfe);
        }
        ret.put("response", response);
        return ret;
    }

    public void afterResponse(Request<?> request, Response<?> response) {
        if (this.isSubsegmentDuplicate(ThreadLocalStorage.get(), request)) {
            this.after(this.recorder.getCurrentSubsegment(), request, response);
        }
    }

    public void afterError(Request<?> request, Response<?> response, Exception e) {
        if (this.isSubsegmentDuplicate(ThreadLocalStorage.get(), request)) {
            Subsegment currentSubsegment = this.recorder.getCurrentSubsegment();
            currentSubsegment.addException((Throwable)e);
            if (null != response) {
                int statusCode = response.getHttpResponse().getStatusCode();
                int statusCodePrefix = statusCode / 100;
                if (4 == statusCodePrefix) {
                    currentSubsegment.setError(true);
                    if (429 == statusCode || e instanceof AmazonServiceException && RetryUtils.isThrottlingException((AmazonServiceException)((AmazonServiceException)e))) {
                        currentSubsegment.setThrottle(true);
                    }
                } else if (5 == statusCodePrefix) {
                    currentSubsegment.setFault(true);
                }
            } else if (e instanceof AmazonServiceException && RetryUtils.isThrottlingException((AmazonServiceException)((AmazonServiceException)e))) {
                currentSubsegment.setError(true);
                currentSubsegment.setThrottle(true);
            }
            this.after(currentSubsegment, request, response);
        }
    }

    private void after(Subsegment currentSubsegment, Request<?> request, Response<?> response) {
        if (null != response) {
            try {
                String requestId = null;
                ResponseMetadata metadata = ((AmazonWebServiceResult)response.getAwsResponse()).getSdkResponseMetadata();
                if (null != metadata && null != (requestId = metadata.getRequestId())) {
                    currentSubsegment.putAws("request_id", (Object)requestId);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            currentSubsegment.putAllAws(this.extractResponseParameters(request, response.getAwsResponse()));
            currentSubsegment.putAllHttp(this.extractHttpResponseInformation(response.getHttpResponse()));
        }
        this.recorder.endSubsegment();
        currentSubsegment = null;
    }
}

