/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.serialization.factories;

import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.annotation.JsonInclude;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.JsonFactory;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.TSFBuilder;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.json.JsonReadFeature;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.DeserializationConfig;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.DeserializationFeature;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.MapperFeature;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.ObjectMapper;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.ObjectReader;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.ObjectWriter;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.SerializationConfig;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.SerializationFeature;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.json.JsonMapper;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.module.SimpleModule;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.amazonaws.services.lambda.runtime.serialization.PojoSerializer;
import com.amazonaws.services.lambda.runtime.serialization.factories.PojoSerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;

public class JacksonFactory
implements PojoSerializerFactory {
    private static final ObjectMapper globalMapper = JacksonFactory.createObjectMapper();
    private static final JacksonFactory instance = new JacksonFactory(globalMapper);
    private final ObjectMapper mapper;

    public static JacksonFactory getInstance() {
        return instance;
    }

    private JacksonFactory(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private static ObjectMapper createObjectMapper() {
        Object mapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder(JacksonFactory.createJsonFactory()).enable(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS)).enable(MapperFeature.AUTO_DETECT_FIELDS)).enable(MapperFeature.AUTO_DETECT_GETTERS)).enable(MapperFeature.AUTO_DETECT_IS_GETTERS)).enable(MapperFeature.AUTO_DETECT_SETTERS)).enable(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)).enable(MapperFeature.USE_STD_BEAN_NAMING)).enable(MapperFeature.USE_ANNOTATIONS)).disable(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)).disable(MapperFeature.AUTO_DETECT_CREATORS)).disable(MapperFeature.INFER_PROPERTY_MUTATORS)).disable(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY)).disable(MapperFeature.USE_GETTERS_AS_SETTERS)).disable(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME)).disable(MapperFeature.USE_STATIC_TYPING)).disable(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS)).build();
        SerializationConfig scfg = ((ObjectMapper)mapper).getSerializationConfig();
        scfg = scfg.withFeatures(SerializationFeature.FAIL_ON_SELF_REFERENCES, SerializationFeature.FAIL_ON_UNWRAPPED_TYPE_IDENTIFIERS, SerializationFeature.WRAP_EXCEPTIONS);
        scfg = scfg.withoutFeatures(SerializationFeature.CLOSE_CLOSEABLE, SerializationFeature.EAGER_SERIALIZER_FETCH, SerializationFeature.FAIL_ON_EMPTY_BEANS, SerializationFeature.FLUSH_AFTER_WRITE_VALUE, SerializationFeature.INDENT_OUTPUT, SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID, SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS, SerializationFeature.WRAP_ROOT_VALUE);
        ((ObjectMapper)mapper).setConfig(scfg);
        DeserializationConfig dcfg = ((ObjectMapper)mapper).getDeserializationConfig();
        dcfg = dcfg.withFeatures(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS, DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, DeserializationFeature.WRAP_EXCEPTIONS);
        dcfg = dcfg.withoutFeatures(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ((ObjectMapper)mapper).setConfig(dcfg);
        ((ObjectMapper)mapper).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Void.class, new VoidDeserializer());
        ((ObjectMapper)mapper).registerModule(module);
        ((ObjectMapper)mapper).registerModule(new JavaTimeModule());
        ((ObjectMapper)mapper).registerModule(new Jdk8Module());
        return mapper;
    }

    private static JsonFactory createJsonFactory() {
        Object factory = ((TSFBuilder)((TSFBuilder)((TSFBuilder)((TSFBuilder)((TSFBuilder)((TSFBuilder)((TSFBuilder)((TSFBuilder)((TSFBuilder)((TSFBuilder)((TSFBuilder)((TSFBuilder)JsonFactory.builder().enable(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS)).enable(JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS)).enable(JsonReadFeature.ALLOW_SINGLE_QUOTES)).enable(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)).enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS)).enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES)).disable(JsonReadFeature.ALLOW_JAVA_COMMENTS)).disable(JsonReadFeature.ALLOW_YAML_COMMENTS)).enable(JsonWriteFeature.QUOTE_FIELD_NAMES)).enable(JsonWriteFeature.WRITE_NAN_AS_STRINGS)).disable(JsonWriteFeature.ESCAPE_NON_ASCII)).disable(JsonWriteFeature.WRITE_NUMBERS_AS_STRINGS)).build();
        ((JsonFactory)factory).disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        ((JsonFactory)factory).disable(JsonParser.Feature.STRICT_DUPLICATE_DETECTION);
        ((JsonFactory)factory).enable(JsonGenerator.Feature.IGNORE_UNKNOWN);
        ((JsonFactory)factory).disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
        ((JsonFactory)factory).disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        ((JsonFactory)factory).disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
        ((JsonFactory)factory).disable(JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION);
        ((JsonFactory)factory).disable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
        return factory;
    }

    @Override
    public <T> PojoSerializer<T> getSerializer(Class<T> clazz) {
        return new ClassSerializer<T>(this.mapper, clazz);
    }

    @Override
    public PojoSerializer<Object> getSerializer(Type type) {
        return new TypeSerializer(this.mapper, type);
    }

    public JacksonFactory withNamingStrategy(PropertyNamingStrategy strategy) {
        return new JacksonFactory(this.mapper.copy().setPropertyNamingStrategy(strategy));
    }

    public JacksonFactory withMixin(Class<?> clazz, Class<?> mixin) {
        return new JacksonFactory(this.mapper.copy().addMixIn(clazz, mixin));
    }

    private static final class ClassSerializer<T>
    extends InternalSerializer<T> {
        public ClassSerializer(ObjectMapper mapper, Class<T> clazz) {
            super(mapper.readerFor(clazz), mapper.writerFor(clazz));
        }
    }

    private static final class TypeSerializer
    extends InternalSerializer<Object> {
        public TypeSerializer(ObjectMapper mapper, JavaType type) {
            super(mapper.readerFor(type), mapper.writerFor(type));
        }

        public TypeSerializer(ObjectMapper mapper, Type type) {
            this(mapper, mapper.constructType(type));
        }
    }

    private static class InternalSerializer<T>
    implements PojoSerializer<T> {
        private final ObjectReader reader;
        private final ObjectWriter writer;

        public InternalSerializer(ObjectReader reader, ObjectWriter writer) {
            this.reader = reader;
            this.writer = writer;
        }

        @Override
        public T fromJson(InputStream input) {
            try {
                return this.reader.readValue(input);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public T fromJson(String input) {
            try {
                return this.reader.readValue(input);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void toJson(T value, OutputStream output) {
            try {
                this.writer.writeValue(output, value);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static final class VoidDeserializer
    extends JsonDeserializer<Void> {
        private static final Void VOID = VoidDeserializer.createVoid();

        private static Void createVoid() {
            try {
                Constructor constructor = Void.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (Void)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Void deserialize(JsonParser parser, DeserializationContext ctx) {
            return VOID;
        }
    }
}

