/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.events;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IamPolicyResponseV1
implements Serializable,
Cloneable {
    public static final String EXECUTE_API_INVOKE = "execute-api:Invoke";
    public static final String VERSION_2012_10_17 = "2012-10-17";
    public static final String ALLOW = "Allow";
    public static final String DENY = "Deny";
    private String principalId;
    private PolicyDocument policyDocument;
    private Map<String, Object> context;
    private String usageIdentifierKey;

    public Map<String, Object> getPolicyDocument() {
        HashMap<String, Object> serializablePolicy = new HashMap<String, Object>();
        serializablePolicy.put("Version", this.policyDocument.getVersion());
        int numberOfStatements = this.policyDocument.getStatement().size();
        Map[] serializableStatementArray = new Map[numberOfStatements];
        for (int i = 0; i < numberOfStatements; ++i) {
            Statement statement = this.policyDocument.getStatement().get(i);
            HashMap<String, Object> serializableStatement = new HashMap<String, Object>();
            serializableStatement.put("Effect", statement.getEffect());
            serializableStatement.put("Action", statement.getAction());
            serializableStatement.put("Resource", statement.getResource().toArray(new String[0]));
            serializableStatement.put("Condition", statement.getCondition());
            serializableStatementArray[i] = serializableStatement;
        }
        serializablePolicy.put("Statement", serializableStatementArray);
        return serializablePolicy;
    }

    public static Statement allowStatement(String resource) {
        return Statement.builder().withEffect(ALLOW).withResource(Collections.singletonList(resource)).withAction(EXECUTE_API_INVOKE).build();
    }

    public static Statement denyStatement(String resource) {
        return Statement.builder().withEffect(DENY).withResource(Collections.singletonList(resource)).withAction(EXECUTE_API_INVOKE).build();
    }

    public static IamPolicyResponseV1Builder builder() {
        return new IamPolicyResponseV1Builder();
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public String getUsageIdentifierKey() {
        return this.usageIdentifierKey;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public void setPolicyDocument(PolicyDocument policyDocument) {
        this.policyDocument = policyDocument;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public void setUsageIdentifierKey(String usageIdentifierKey) {
        this.usageIdentifierKey = usageIdentifierKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IamPolicyResponseV1)) {
            return false;
        }
        IamPolicyResponseV1 other = (IamPolicyResponseV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$principalId = this.getPrincipalId();
        String other$principalId = other.getPrincipalId();
        if (this$principalId == null ? other$principalId != null : !this$principalId.equals(other$principalId)) {
            return false;
        }
        Map<String, Object> this$policyDocument = this.getPolicyDocument();
        Map<String, Object> other$policyDocument = other.getPolicyDocument();
        if (this$policyDocument == null ? other$policyDocument != null : !((Object)this$policyDocument).equals(other$policyDocument)) {
            return false;
        }
        Map<String, Object> this$context = this.getContext();
        Map<String, Object> other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        String this$usageIdentifierKey = this.getUsageIdentifierKey();
        String other$usageIdentifierKey = other.getUsageIdentifierKey();
        return !(this$usageIdentifierKey == null ? other$usageIdentifierKey != null : !this$usageIdentifierKey.equals(other$usageIdentifierKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IamPolicyResponseV1;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $principalId = this.getPrincipalId();
        result = result * 59 + ($principalId == null ? 43 : $principalId.hashCode());
        Map<String, Object> $policyDocument = this.getPolicyDocument();
        result = result * 59 + ($policyDocument == null ? 43 : ((Object)$policyDocument).hashCode());
        Map<String, Object> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        String $usageIdentifierKey = this.getUsageIdentifierKey();
        result = result * 59 + ($usageIdentifierKey == null ? 43 : $usageIdentifierKey.hashCode());
        return result;
    }

    public String toString() {
        return "IamPolicyResponseV1(principalId=" + this.getPrincipalId() + ", policyDocument=" + this.getPolicyDocument() + ", context=" + this.getContext() + ", usageIdentifierKey=" + this.getUsageIdentifierKey() + ")";
    }

    public IamPolicyResponseV1() {
    }

    public IamPolicyResponseV1(String principalId, PolicyDocument policyDocument, Map<String, Object> context, String usageIdentifierKey) {
        this.principalId = principalId;
        this.policyDocument = policyDocument;
        this.context = context;
        this.usageIdentifierKey = usageIdentifierKey;
    }

    public static class IamPolicyResponseV1Builder {
        private String principalId;
        private PolicyDocument policyDocument;
        private Map<String, Object> context;
        private String usageIdentifierKey;

        IamPolicyResponseV1Builder() {
        }

        public IamPolicyResponseV1Builder withPrincipalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public IamPolicyResponseV1Builder withPolicyDocument(PolicyDocument policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public IamPolicyResponseV1Builder withContext(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public IamPolicyResponseV1Builder withUsageIdentifierKey(String usageIdentifierKey) {
            this.usageIdentifierKey = usageIdentifierKey;
            return this;
        }

        public IamPolicyResponseV1 build() {
            return new IamPolicyResponseV1(this.principalId, this.policyDocument, this.context, this.usageIdentifierKey);
        }

        public String toString() {
            return "IamPolicyResponseV1.IamPolicyResponseV1Builder(principalId=" + this.principalId + ", policyDocument=" + this.policyDocument + ", context=" + this.context + ", usageIdentifierKey=" + this.usageIdentifierKey + ")";
        }
    }

    public static class Statement
    implements Serializable,
    Cloneable {
        private String action;
        private String effect;
        private List<String> resource;
        private Map<String, Map<String, Object>> condition;

        public static StatementBuilder builder() {
            return new StatementBuilder();
        }

        public String getAction() {
            return this.action;
        }

        public String getEffect() {
            return this.effect;
        }

        public List<String> getResource() {
            return this.resource;
        }

        public Map<String, Map<String, Object>> getCondition() {
            return this.condition;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }

        public void setResource(List<String> resource) {
            this.resource = resource;
        }

        public void setCondition(Map<String, Map<String, Object>> condition) {
            this.condition = condition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Statement)) {
                return false;
            }
            Statement other = (Statement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$effect = this.getEffect();
            String other$effect = other.getEffect();
            if (this$effect == null ? other$effect != null : !this$effect.equals(other$effect)) {
                return false;
            }
            List<String> this$resource = this.getResource();
            List<String> other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
                return false;
            }
            Map<String, Map<String, Object>> this$condition = this.getCondition();
            Map<String, Map<String, Object>> other$condition = other.getCondition();
            return !(this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Statement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $effect = this.getEffect();
            result = result * 59 + ($effect == null ? 43 : $effect.hashCode());
            List<String> $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
            Map<String, Map<String, Object>> $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
            return result;
        }

        public String toString() {
            return "IamPolicyResponseV1.Statement(action=" + this.getAction() + ", effect=" + this.getEffect() + ", resource=" + this.getResource() + ", condition=" + this.getCondition() + ")";
        }

        public Statement() {
        }

        public Statement(String action, String effect, List<String> resource, Map<String, Map<String, Object>> condition) {
            this.action = action;
            this.effect = effect;
            this.resource = resource;
            this.condition = condition;
        }

        public static class StatementBuilder {
            private String action;
            private String effect;
            private List<String> resource;
            private Map<String, Map<String, Object>> condition;

            StatementBuilder() {
            }

            public StatementBuilder withAction(String action) {
                this.action = action;
                return this;
            }

            public StatementBuilder withEffect(String effect) {
                this.effect = effect;
                return this;
            }

            public StatementBuilder withResource(List<String> resource) {
                this.resource = resource;
                return this;
            }

            public StatementBuilder withCondition(Map<String, Map<String, Object>> condition) {
                this.condition = condition;
                return this;
            }

            public Statement build() {
                return new Statement(this.action, this.effect, this.resource, this.condition);
            }

            public String toString() {
                return "IamPolicyResponseV1.Statement.StatementBuilder(action=" + this.action + ", effect=" + this.effect + ", resource=" + this.resource + ", condition=" + this.condition + ")";
            }
        }
    }

    public static class PolicyDocument
    implements Serializable,
    Cloneable {
        private String version;
        private List<Statement> statement;

        public static PolicyDocumentBuilder builder() {
            return new PolicyDocumentBuilder();
        }

        public String getVersion() {
            return this.version;
        }

        public List<Statement> getStatement() {
            return this.statement;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setStatement(List<Statement> statement) {
            this.statement = statement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PolicyDocument)) {
                return false;
            }
            PolicyDocument other = (PolicyDocument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            List<Statement> this$statement = this.getStatement();
            List<Statement> other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !((Object)this$statement).equals(other$statement));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PolicyDocument;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            List<Statement> $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : ((Object)$statement).hashCode());
            return result;
        }

        public String toString() {
            return "IamPolicyResponseV1.PolicyDocument(version=" + this.getVersion() + ", statement=" + this.getStatement() + ")";
        }

        public PolicyDocument() {
        }

        public PolicyDocument(String version, List<Statement> statement) {
            this.version = version;
            this.statement = statement;
        }

        public static class PolicyDocumentBuilder {
            private String version;
            private List<Statement> statement;

            PolicyDocumentBuilder() {
            }

            public PolicyDocumentBuilder withVersion(String version) {
                this.version = version;
                return this;
            }

            public PolicyDocumentBuilder withStatement(List<Statement> statement) {
                this.statement = statement;
                return this;
            }

            public PolicyDocument build() {
                return new PolicyDocument(this.version, this.statement);
            }

            public String toString() {
                return "IamPolicyResponseV1.PolicyDocument.PolicyDocumentBuilder(version=" + this.version + ", statement=" + this.statement + ")";
            }
        }
    }
}

