/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.events;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class APIGatewayV2CustomAuthorizerEvent {
    private String version;
    private String type;
    private String routeArn;
    private List<String> identitySource;
    private String routeKey;
    private String rawPath;
    private String rawQueryString;
    private List<String> cookies;
    private Map<String, String> headers;
    private Map<String, String> queryStringParameters;
    private RequestContext requestContext;
    private Map<String, String> pathParameters;
    private Map<String, String> stageVariables;

    public static APIGatewayV2CustomAuthorizerEventBuilder builder() {
        return new APIGatewayV2CustomAuthorizerEventBuilder();
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getRouteArn() {
        return this.routeArn;
    }

    public List<String> getIdentitySource() {
        return this.identitySource;
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public String getRawQueryString() {
        return this.rawQueryString;
    }

    public List<String> getCookies() {
        return this.cookies;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public Map<String, String> getStageVariables() {
        return this.stageVariables;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRouteArn(String routeArn) {
        this.routeArn = routeArn;
    }

    public void setIdentitySource(List<String> identitySource) {
        this.identitySource = identitySource;
    }

    public void setRouteKey(String routeKey) {
        this.routeKey = routeKey;
    }

    public void setRawPath(String rawPath) {
        this.rawPath = rawPath;
    }

    public void setRawQueryString(String rawQueryString) {
        this.rawQueryString = rawQueryString;
    }

    public void setCookies(List<String> cookies) {
        this.cookies = cookies;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setQueryStringParameters(Map<String, String> queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public void setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
    }

    public void setStageVariables(Map<String, String> stageVariables) {
        this.stageVariables = stageVariables;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIGatewayV2CustomAuthorizerEvent)) {
            return false;
        }
        APIGatewayV2CustomAuthorizerEvent other = (APIGatewayV2CustomAuthorizerEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$routeArn = this.getRouteArn();
        String other$routeArn = other.getRouteArn();
        if (this$routeArn == null ? other$routeArn != null : !this$routeArn.equals(other$routeArn)) {
            return false;
        }
        List<String> this$identitySource = this.getIdentitySource();
        List<String> other$identitySource = other.getIdentitySource();
        if (this$identitySource == null ? other$identitySource != null : !((Object)this$identitySource).equals(other$identitySource)) {
            return false;
        }
        String this$routeKey = this.getRouteKey();
        String other$routeKey = other.getRouteKey();
        if (this$routeKey == null ? other$routeKey != null : !this$routeKey.equals(other$routeKey)) {
            return false;
        }
        String this$rawPath = this.getRawPath();
        String other$rawPath = other.getRawPath();
        if (this$rawPath == null ? other$rawPath != null : !this$rawPath.equals(other$rawPath)) {
            return false;
        }
        String this$rawQueryString = this.getRawQueryString();
        String other$rawQueryString = other.getRawQueryString();
        if (this$rawQueryString == null ? other$rawQueryString != null : !this$rawQueryString.equals(other$rawQueryString)) {
            return false;
        }
        List<String> this$cookies = this.getCookies();
        List<String> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, String> this$queryStringParameters = this.getQueryStringParameters();
        Map<String, String> other$queryStringParameters = other.getQueryStringParameters();
        if (this$queryStringParameters == null ? other$queryStringParameters != null : !((Object)this$queryStringParameters).equals(other$queryStringParameters)) {
            return false;
        }
        RequestContext this$requestContext = this.getRequestContext();
        RequestContext other$requestContext = other.getRequestContext();
        if (this$requestContext == null ? other$requestContext != null : !((Object)this$requestContext).equals(other$requestContext)) {
            return false;
        }
        Map<String, String> this$pathParameters = this.getPathParameters();
        Map<String, String> other$pathParameters = other.getPathParameters();
        if (this$pathParameters == null ? other$pathParameters != null : !((Object)this$pathParameters).equals(other$pathParameters)) {
            return false;
        }
        Map<String, String> this$stageVariables = this.getStageVariables();
        Map<String, String> other$stageVariables = other.getStageVariables();
        return !(this$stageVariables == null ? other$stageVariables != null : !((Object)this$stageVariables).equals(other$stageVariables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof APIGatewayV2CustomAuthorizerEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $routeArn = this.getRouteArn();
        result = result * 59 + ($routeArn == null ? 43 : $routeArn.hashCode());
        List<String> $identitySource = this.getIdentitySource();
        result = result * 59 + ($identitySource == null ? 43 : ((Object)$identitySource).hashCode());
        String $routeKey = this.getRouteKey();
        result = result * 59 + ($routeKey == null ? 43 : $routeKey.hashCode());
        String $rawPath = this.getRawPath();
        result = result * 59 + ($rawPath == null ? 43 : $rawPath.hashCode());
        String $rawQueryString = this.getRawQueryString();
        result = result * 59 + ($rawQueryString == null ? 43 : $rawQueryString.hashCode());
        List<String> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, String> $queryStringParameters = this.getQueryStringParameters();
        result = result * 59 + ($queryStringParameters == null ? 43 : ((Object)$queryStringParameters).hashCode());
        RequestContext $requestContext = this.getRequestContext();
        result = result * 59 + ($requestContext == null ? 43 : ((Object)$requestContext).hashCode());
        Map<String, String> $pathParameters = this.getPathParameters();
        result = result * 59 + ($pathParameters == null ? 43 : ((Object)$pathParameters).hashCode());
        Map<String, String> $stageVariables = this.getStageVariables();
        result = result * 59 + ($stageVariables == null ? 43 : ((Object)$stageVariables).hashCode());
        return result;
    }

    public String toString() {
        return "APIGatewayV2CustomAuthorizerEvent(version=" + this.getVersion() + ", type=" + this.getType() + ", routeArn=" + this.getRouteArn() + ", identitySource=" + this.getIdentitySource() + ", routeKey=" + this.getRouteKey() + ", rawPath=" + this.getRawPath() + ", rawQueryString=" + this.getRawQueryString() + ", cookies=" + this.getCookies() + ", headers=" + this.getHeaders() + ", queryStringParameters=" + this.getQueryStringParameters() + ", requestContext=" + this.getRequestContext() + ", pathParameters=" + this.getPathParameters() + ", stageVariables=" + this.getStageVariables() + ")";
    }

    public APIGatewayV2CustomAuthorizerEvent() {
    }

    public APIGatewayV2CustomAuthorizerEvent(String version, String type, String routeArn, List<String> identitySource, String routeKey, String rawPath, String rawQueryString, List<String> cookies, Map<String, String> headers, Map<String, String> queryStringParameters, RequestContext requestContext, Map<String, String> pathParameters, Map<String, String> stageVariables) {
        this.version = version;
        this.type = type;
        this.routeArn = routeArn;
        this.identitySource = identitySource;
        this.routeKey = routeKey;
        this.rawPath = rawPath;
        this.rawQueryString = rawQueryString;
        this.cookies = cookies;
        this.headers = headers;
        this.queryStringParameters = queryStringParameters;
        this.requestContext = requestContext;
        this.pathParameters = pathParameters;
        this.stageVariables = stageVariables;
    }

    public static class APIGatewayV2CustomAuthorizerEventBuilder {
        private String version;
        private String type;
        private String routeArn;
        private List<String> identitySource;
        private String routeKey;
        private String rawPath;
        private String rawQueryString;
        private List<String> cookies;
        private Map<String, String> headers;
        private Map<String, String> queryStringParameters;
        private RequestContext requestContext;
        private Map<String, String> pathParameters;
        private Map<String, String> stageVariables;

        APIGatewayV2CustomAuthorizerEventBuilder() {
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withType(String type) {
            this.type = type;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withRouteArn(String routeArn) {
            this.routeArn = routeArn;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withIdentitySource(List<String> identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withRouteKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withRawPath(String rawPath) {
            this.rawPath = rawPath;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withRawQueryString(String rawQueryString) {
            this.rawQueryString = rawQueryString;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withCookies(List<String> cookies) {
            this.cookies = cookies;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withQueryStringParameters(Map<String, String> queryStringParameters) {
            this.queryStringParameters = queryStringParameters;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withRequestContext(RequestContext requestContext) {
            this.requestContext = requestContext;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withPathParameters(Map<String, String> pathParameters) {
            this.pathParameters = pathParameters;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEventBuilder withStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = stageVariables;
            return this;
        }

        public APIGatewayV2CustomAuthorizerEvent build() {
            return new APIGatewayV2CustomAuthorizerEvent(this.version, this.type, this.routeArn, this.identitySource, this.routeKey, this.rawPath, this.rawQueryString, this.cookies, this.headers, this.queryStringParameters, this.requestContext, this.pathParameters, this.stageVariables);
        }

        public String toString() {
            return "APIGatewayV2CustomAuthorizerEvent.APIGatewayV2CustomAuthorizerEventBuilder(version=" + this.version + ", type=" + this.type + ", routeArn=" + this.routeArn + ", identitySource=" + this.identitySource + ", routeKey=" + this.routeKey + ", rawPath=" + this.rawPath + ", rawQueryString=" + this.rawQueryString + ", cookies=" + this.cookies + ", headers=" + this.headers + ", queryStringParameters=" + this.queryStringParameters + ", requestContext=" + this.requestContext + ", pathParameters=" + this.pathParameters + ", stageVariables=" + this.stageVariables + ")";
        }
    }

    public static class Http {
        private String method;
        private String path;
        private String protocol;
        private String sourceIp;
        private String userAgent;

        public static HttpBuilder builder() {
            return new HttpBuilder();
        }

        public Http(String method, String path, String protocol, String sourceIp, String userAgent) {
            this.method = method;
            this.path = path;
            this.protocol = protocol;
            this.sourceIp = sourceIp;
            this.userAgent = userAgent;
        }

        public String getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getSourceIp() {
            return this.sourceIp;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Http)) {
                return false;
            }
            Http other = (Http)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
                return false;
            }
            String this$sourceIp = this.getSourceIp();
            String other$sourceIp = other.getSourceIp();
            if (this$sourceIp == null ? other$sourceIp != null : !this$sourceIp.equals(other$sourceIp)) {
                return false;
            }
            String this$userAgent = this.getUserAgent();
            String other$userAgent = other.getUserAgent();
            return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Http;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            String $sourceIp = this.getSourceIp();
            result = result * 59 + ($sourceIp == null ? 43 : $sourceIp.hashCode());
            String $userAgent = this.getUserAgent();
            result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
            return result;
        }

        public String toString() {
            return "APIGatewayV2CustomAuthorizerEvent.Http(method=" + this.getMethod() + ", path=" + this.getPath() + ", protocol=" + this.getProtocol() + ", sourceIp=" + this.getSourceIp() + ", userAgent=" + this.getUserAgent() + ")";
        }

        public Http() {
        }

        public static class HttpBuilder {
            private String method;
            private String path;
            private String protocol;
            private String sourceIp;
            private String userAgent;

            HttpBuilder() {
            }

            public HttpBuilder withMethod(String method) {
                this.method = method;
                return this;
            }

            public HttpBuilder withPath(String path) {
                this.path = path;
                return this;
            }

            public HttpBuilder withProtocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public HttpBuilder withSourceIp(String sourceIp) {
                this.sourceIp = sourceIp;
                return this;
            }

            public HttpBuilder withUserAgent(String userAgent) {
                this.userAgent = userAgent;
                return this;
            }

            public Http build() {
                return new Http(this.method, this.path, this.protocol, this.sourceIp, this.userAgent);
            }

            public String toString() {
                return "APIGatewayV2CustomAuthorizerEvent.Http.HttpBuilder(method=" + this.method + ", path=" + this.path + ", protocol=" + this.protocol + ", sourceIp=" + this.sourceIp + ", userAgent=" + this.userAgent + ")";
            }
        }
    }

    public static class RequestContext {
        private static DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"dd/MMM/yyyy:HH:mm:ss Z");
        private String accountId;
        private String apiId;
        private String domainName;
        private String domainPrefix;
        private Http http;
        private String requestId;
        private String routeKey;
        private String stage;
        private String time;
        private long timeEpoch;

        public Instant getTimeEpoch() {
            return Instant.ofEpochMilli(this.timeEpoch);
        }

        public DateTime getTime() {
            return fmt.parseDateTime(this.time);
        }

        public static RequestContextBuilder builder() {
            return new RequestContextBuilder();
        }

        public String getAccountId() {
            return this.accountId;
        }

        public String getApiId() {
            return this.apiId;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public String getDomainPrefix() {
            return this.domainPrefix;
        }

        public Http getHttp() {
            return this.http;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getRouteKey() {
            return this.routeKey;
        }

        public String getStage() {
            return this.stage;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public void setDomainPrefix(String domainPrefix) {
            this.domainPrefix = domainPrefix;
        }

        public void setHttp(Http http) {
            this.http = http;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }

        public void setStage(String stage) {
            this.stage = stage;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public void setTimeEpoch(long timeEpoch) {
            this.timeEpoch = timeEpoch;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestContext)) {
                return false;
            }
            RequestContext other = (RequestContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Instant this$timeEpoch = this.getTimeEpoch();
            Instant other$timeEpoch = other.getTimeEpoch();
            if (this$timeEpoch == null ? other$timeEpoch != null : !((Object)this$timeEpoch).equals(other$timeEpoch)) {
                return false;
            }
            String this$accountId = this.getAccountId();
            String other$accountId = other.getAccountId();
            if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
                return false;
            }
            String this$apiId = this.getApiId();
            String other$apiId = other.getApiId();
            if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) {
                return false;
            }
            String this$domainName = this.getDomainName();
            String other$domainName = other.getDomainName();
            if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
                return false;
            }
            String this$domainPrefix = this.getDomainPrefix();
            String other$domainPrefix = other.getDomainPrefix();
            if (this$domainPrefix == null ? other$domainPrefix != null : !this$domainPrefix.equals(other$domainPrefix)) {
                return false;
            }
            Http this$http = this.getHttp();
            Http other$http = other.getHttp();
            if (this$http == null ? other$http != null : !((Object)this$http).equals(other$http)) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            String this$routeKey = this.getRouteKey();
            String other$routeKey = other.getRouteKey();
            if (this$routeKey == null ? other$routeKey != null : !this$routeKey.equals(other$routeKey)) {
                return false;
            }
            String this$stage = this.getStage();
            String other$stage = other.getStage();
            if (this$stage == null ? other$stage != null : !this$stage.equals(other$stage)) {
                return false;
            }
            DateTime this$time = this.getTime();
            DateTime other$time = other.getTime();
            return !(this$time == null ? other$time != null : !this$time.equals(other$time));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Instant $timeEpoch = this.getTimeEpoch();
            result = result * 59 + ($timeEpoch == null ? 43 : ((Object)$timeEpoch).hashCode());
            String $accountId = this.getAccountId();
            result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
            String $apiId = this.getApiId();
            result = result * 59 + ($apiId == null ? 43 : $apiId.hashCode());
            String $domainName = this.getDomainName();
            result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
            String $domainPrefix = this.getDomainPrefix();
            result = result * 59 + ($domainPrefix == null ? 43 : $domainPrefix.hashCode());
            Http $http = this.getHttp();
            result = result * 59 + ($http == null ? 43 : ((Object)$http).hashCode());
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            String $routeKey = this.getRouteKey();
            result = result * 59 + ($routeKey == null ? 43 : $routeKey.hashCode());
            String $stage = this.getStage();
            result = result * 59 + ($stage == null ? 43 : $stage.hashCode());
            DateTime $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : $time.hashCode());
            return result;
        }

        public String toString() {
            return "APIGatewayV2CustomAuthorizerEvent.RequestContext(accountId=" + this.getAccountId() + ", apiId=" + this.getApiId() + ", domainName=" + this.getDomainName() + ", domainPrefix=" + this.getDomainPrefix() + ", http=" + this.getHttp() + ", requestId=" + this.getRequestId() + ", routeKey=" + this.getRouteKey() + ", stage=" + this.getStage() + ", time=" + this.getTime() + ", timeEpoch=" + this.getTimeEpoch() + ")";
        }

        public RequestContext() {
        }

        public RequestContext(String accountId, String apiId, String domainName, String domainPrefix, Http http, String requestId, String routeKey, String stage, String time, long timeEpoch) {
            this.accountId = accountId;
            this.apiId = apiId;
            this.domainName = domainName;
            this.domainPrefix = domainPrefix;
            this.http = http;
            this.requestId = requestId;
            this.routeKey = routeKey;
            this.stage = stage;
            this.time = time;
            this.timeEpoch = timeEpoch;
        }

        public static class RequestContextBuilder {
            private String accountId;
            private String apiId;
            private String domainName;
            private String domainPrefix;
            private Http http;
            private String requestId;
            private String routeKey;
            private String stage;
            private String time;
            private long timeEpoch;

            RequestContextBuilder() {
            }

            public RequestContextBuilder withAccountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            public RequestContextBuilder withApiId(String apiId) {
                this.apiId = apiId;
                return this;
            }

            public RequestContextBuilder withDomainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            public RequestContextBuilder withDomainPrefix(String domainPrefix) {
                this.domainPrefix = domainPrefix;
                return this;
            }

            public RequestContextBuilder withHttp(Http http) {
                this.http = http;
                return this;
            }

            public RequestContextBuilder withRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            public RequestContextBuilder withRouteKey(String routeKey) {
                this.routeKey = routeKey;
                return this;
            }

            public RequestContextBuilder withStage(String stage) {
                this.stage = stage;
                return this;
            }

            public RequestContextBuilder withTime(String time) {
                this.time = time;
                return this;
            }

            public RequestContextBuilder withTimeEpoch(long timeEpoch) {
                this.timeEpoch = timeEpoch;
                return this;
            }

            public RequestContext build() {
                return new RequestContext(this.accountId, this.apiId, this.domainName, this.domainPrefix, this.http, this.requestId, this.routeKey, this.stage, this.time, this.timeEpoch);
            }

            public String toString() {
                return "APIGatewayV2CustomAuthorizerEvent.RequestContext.RequestContextBuilder(accountId=" + this.accountId + ", apiId=" + this.apiId + ", domainName=" + this.domainName + ", domainPrefix=" + this.domainPrefix + ", http=" + this.http + ", requestId=" + this.requestId + ", routeKey=" + this.routeKey + ", stage=" + this.stage + ", time=" + this.time + ", timeEpoch=" + this.timeEpoch + ")";
            }
        }
    }
}

