/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.UnsubscribeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UnsubscribeRequestMarshaller
implements Marshaller<Request<UnsubscribeRequest>, UnsubscribeRequest> {
    @Override
    public Request<UnsubscribeRequest> marshall(UnsubscribeRequest unsubscribeRequest) {
        if (unsubscribeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UnsubscribeRequest> request = new DefaultRequest<UnsubscribeRequest>(unsubscribeRequest, "AmazonSNS");
        request.addParameter("Action", "Unsubscribe");
        request.addParameter("Version", "2010-03-31");
        if (unsubscribeRequest.getSubscriptionArn() != null) {
            request.addParameter("SubscriptionArn", StringUtils.fromString(unsubscribeRequest.getSubscriptionArn()));
        }
        return request;
    }
}

