/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.AttributeTransformer;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBReflector;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBSaveExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.KeyPair;
import com.amazonaws.services.dynamodbv2.datamodeling.MapAnd;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedParallelScanList;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedQueryList;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import com.amazonaws.services.dynamodbv2.datamodeling.ParallelScanTask;
import com.amazonaws.services.dynamodbv2.datamodeling.QueryResultPage;
import com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.ScanResultPage;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.Select;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.util.VersionInfoUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamoDBMapper {
    private final S3ClientCache s3cc;
    private final AmazonDynamoDB db;
    private final DynamoDBMapperConfig config;
    private final DynamoDBReflector reflector = new DynamoDBReflector();
    private final AttributeTransformer transformer;
    private static final long MAX_BACKOFF_IN_MILLISECONDS = 3000L;
    private static final String USER_AGENT = DynamoDBMapper.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String NO_RANGE_KEY = new String();

    public DynamoDBMapper(AmazonDynamoDB dynamoDB) {
        this(dynamoDB, DynamoDBMapperConfig.DEFAULT, null, null);
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config) {
        this(dynamoDB, config, null, null);
    }

    public DynamoDBMapper(AmazonDynamoDB ddb, AWSCredentialsProvider s3CredentialProvider) {
        this(ddb, DynamoDBMapperConfig.DEFAULT, s3CredentialProvider);
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config, AttributeTransformer transformer) {
        this(dynamoDB, config, transformer, null);
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config, AWSCredentialsProvider s3CredentialProvider) {
        this(dynamoDB, config, null, DynamoDBMapper.validate(s3CredentialProvider));
    }

    private static AWSCredentialsProvider validate(AWSCredentialsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("s3 credentials provider must not be null");
        }
        return provider;
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config, AttributeTransformer transformer, AWSCredentialsProvider s3CredentialsProvider) {
        this.db = dynamoDB;
        this.config = config;
        this.transformer = transformer;
        this.s3cc = s3CredentialsProvider == null ? null : new S3ClientCache(s3CredentialsProvider.getCredentials());
    }

    public <T> T load(Class<T> clazz, Object hashKey, DynamoDBMapperConfig config) {
        return this.load(clazz, hashKey, null, config);
    }

    public <T> T load(Class<T> clazz, Object hashKey) {
        return this.load(clazz, hashKey, null, this.config);
    }

    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey) {
        return this.load(clazz, hashKey, rangeKey, this.config);
    }

    public <T> T load(T keyObject) {
        return this.load(keyObject, this.config);
    }

    public <T> T load(T keyObject, DynamoDBMapperConfig config) {
        Class<?> clazz = keyObject.getClass();
        config = this.mergeConfig(config);
        String tableName = this.getTableName(clazz, config);
        GetItemRequest rq = new GetItemRequest();
        Map<String, AttributeValue> key = this.getKey(keyObject, clazz);
        rq.setKey(key);
        rq.setTableName(tableName);
        rq.setConsistentRead(config.getConsistentReads() == DynamoDBMapperConfig.ConsistentReads.CONSISTENT);
        GetItemResult item = this.db.getItem(DynamoDBMapper.applyUserAgent(rq));
        Map<String, AttributeValue> itemAttributes = item.getItem();
        if (itemAttributes == null) {
            return null;
        }
        Object object = this.marshalIntoObject(this.toParameters(itemAttributes, clazz, config));
        return (T)object;
    }

    private <T> Map<String, AttributeValue> getKey(T keyObject) {
        return this.getKey(keyObject, keyObject.getClass());
    }

    private <T> Map<String, AttributeValue> getKey(T keyObject, Class<T> clazz) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        for (Method keyGetter : this.reflector.getKeyGetters(clazz)) {
            Object getterResult;
            AttributeValue keyAttributeValue = this.getSimpleAttributeValue(keyGetter, getterResult = this.safeInvoke(keyGetter, keyObject, new Object[0]));
            if (keyAttributeValue == null) {
                throw new DynamoDBMappingException("Null key found for " + keyGetter);
            }
            key.put(this.reflector.getAttributeName(keyGetter), keyAttributeValue);
        }
        if (key.isEmpty()) {
            throw new DynamoDBMappingException("Class must be annotated with " + DynamoDBHashKey.class + " and " + DynamoDBRangeKey.class);
        }
        return key;
    }

    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        T keyObject = this.createKeyObject(clazz, hashKey, rangeKey);
        return this.load(keyObject, config);
    }

    private <T> T createKeyObject(Class<T> clazz, Object hashKey, Object rangeKey) {
        T keyObject = null;
        try {
            keyObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw new DynamoDBMappingException("Failed to instantiate class", e);
        }
        boolean seenHashKey = false;
        boolean seenRangeKey = false;
        for (Method getter : this.reflector.getKeyGetters(clazz)) {
            if (getter.isAnnotationPresent(DynamoDBHashKey.class)) {
                if (seenHashKey) {
                    throw new DynamoDBMappingException("Found more than one method annotated with " + DynamoDBHashKey.class + " for class " + clazz + ". Use load(Object) for tables with more than a single hash and range key.");
                }
                seenHashKey = true;
                this.safeInvoke(this.reflector.getSetter(getter), keyObject, hashKey);
                continue;
            }
            if (!getter.isAnnotationPresent(DynamoDBRangeKey.class)) continue;
            if (seenRangeKey) {
                throw new DynamoDBMappingException("Found more than one method annotated with " + DynamoDBRangeKey.class + " for class " + clazz + ". Use load(Object) for tables with more than a single hash and range key.");
            }
            seenRangeKey = true;
            this.safeInvoke(this.reflector.getSetter(getter), keyObject, rangeKey);
        }
        if (!seenHashKey) {
            throw new DynamoDBMappingException("No method annotated with " + DynamoDBHashKey.class + " for class " + clazz + ".");
        }
        if (rangeKey != null && !seenRangeKey) {
            throw new DynamoDBMappingException("No method annotated with " + DynamoDBRangeKey.class + " for class " + clazz + ".");
        }
        return keyObject;
    }

    private Map<String, Condition> getHashKeyEqualsConditions(Object obj) {
        HashMap<String, Condition> conditions = new HashMap<String, Condition>();
        for (Method getter : this.reflector.getKeyGetters(obj.getClass())) {
            if (!getter.isAnnotationPresent(DynamoDBHashKey.class)) continue;
            conditions.put(this.reflector.getAttributeName(getter), new Condition().withComparisonOperator(ComparisonOperator.EQ).withAttributeValueList(this.getSimpleAttributeValue(getter, this.safeInvoke(getter, obj, null))));
        }
        return conditions;
    }

    protected final String getTableName(Class<?> clazz, DynamoDBMapperConfig config) {
        return DynamoDBMapper.getTableName(clazz, config, this.reflector);
    }

    private static String getTableName(Class<?> clazz, DynamoDBMapperConfig config, DynamoDBReflector reflector) {
        DynamoDBTable table = reflector.getTable(clazz);
        String tableName = table.tableName();
        if (config.getTableNameOverride() != null) {
            tableName = config.getTableNameOverride().getTableName() != null ? config.getTableNameOverride().getTableName() : config.getTableNameOverride().getTableNamePrefix() + tableName;
        }
        return tableName;
    }

    private <T> T marshalIntoObject(AttributeTransformer.Parameters<T> parameters) {
        return this.marshallIntoObject(parameters.getModelClass(), MapAnd.wrap(parameters.getAttributeValues(), parameters));
    }

    @Deprecated
    public <T> T marshallIntoObject(Class<T> clazz, Map<String, AttributeValue> itemAttributes) {
        if (itemAttributes instanceof MapAnd) {
            AttributeTransformer.Parameters parameters = (AttributeTransformer.Parameters)((MapAnd)itemAttributes).getExtra();
            return this.privateMarshalIntoObject(parameters);
        }
        return this.privateMarshalIntoObject(this.toParameters(itemAttributes, clazz, this.config));
    }

    private <T> T privateMarshalIntoObject(AttributeTransformer.Parameters<T> parameters) {
        T toReturn = null;
        try {
            toReturn = parameters.getModelClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDBMappingException("Failed to instantiate new instance of class", e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Failed to instantiate new instance of class", e);
        }
        if (parameters.getAttributeValues() == null || parameters.getAttributeValues().isEmpty()) {
            return toReturn;
        }
        Map<String, AttributeValue> result = this.untransformAttributes(parameters);
        for (Method m : this.reflector.getRelevantGetters(parameters.getModelClass())) {
            String attributeName = this.reflector.getAttributeName(m);
            if (!result.containsKey(attributeName)) continue;
            this.setValue(toReturn, m, result.get(attributeName));
        }
        return toReturn;
    }

    @Deprecated
    public <T> List<T> marshallIntoObjects(Class<T> clazz, List<Map<String, AttributeValue>> itemAttributes) {
        ArrayList<T> result = new ArrayList<T>(itemAttributes.size());
        for (Map<String, AttributeValue> item : itemAttributes) {
            result.add(this.marshallIntoObject(clazz, item));
        }
        return result;
    }

    final <T> List<T> marshalIntoObjects(List<AttributeTransformer.Parameters<T>> parameters) {
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        Class<T> clazz = parameters.get(0).getModelClass();
        ArrayList<Map<String, AttributeValue>> list = new ArrayList<Map<String, AttributeValue>>(parameters.size());
        for (AttributeTransformer.Parameters<T> entry : parameters) {
            list.add(MapAnd.wrap(entry.getAttributeValues(), entry));
        }
        return this.marshallIntoObjects(clazz, list);
    }

    private <T> void setValue(T toReturn, Method getter, AttributeValue value) {
        Object argument;
        Method setter = this.reflector.getSetter(getter);
        ArgumentUnmarshaller unmarhsaller = this.reflector.getArgumentUnmarshaller(toReturn, getter, setter, this.s3cc);
        unmarhsaller.typeCheck(value, setter);
        try {
            argument = unmarhsaller.unmarshall(value);
        }
        catch (IllegalArgumentException e) {
            throw new DynamoDBMappingException("Couldn't unmarshall value " + value + " for " + setter, e);
        }
        catch (ParseException e) {
            throw new DynamoDBMappingException("Error attempting to parse date string " + value + " for " + setter, e);
        }
        this.safeInvoke(setter, toReturn, argument);
    }

    private AttributeValue getSimpleAttributeValue(Method getter, Object getterReturnResult) {
        if (getterReturnResult == null) {
            return null;
        }
        ArgumentMarshaller marshaller = this.reflector.getArgumentMarshaller(getter);
        return marshaller.marshall(getterReturnResult);
    }

    public <T> void save(T object) {
        this.save(object, null, this.config);
    }

    public <T> void save(T object, DynamoDBSaveExpression saveExpression) {
        this.save(object, saveExpression, this.config);
    }

    private boolean needAutoGenerateAssignableKey(Class<?> clazz, Object object) {
        Collection<Method> keyGetters = this.reflector.getKeyGetters(clazz);
        boolean forcePut = false;
        boolean hashKeyGetterFound = false;
        for (Method method : keyGetters) {
            Object getterResult = this.safeInvoke(method, object, new Object[0]);
            if (getterResult == null && this.reflector.isAssignableKey(method)) {
                forcePut = true;
            }
            if (!method.isAnnotationPresent(DynamoDBHashKey.class)) continue;
            hashKeyGetterFound = true;
        }
        if (!hashKeyGetterFound) {
            throw new DynamoDBMappingException("No " + DynamoDBHashKey.class + " annotation found in class " + clazz);
        }
        return forcePut;
    }

    public <T> void save(T object, DynamoDBMapperConfig config) {
        this.save(object, null, config);
    }

    public <T> void save(T object, DynamoDBSaveExpression saveExpression, DynamoDBMapperConfig config) {
        final DynamoDBMapperConfig finalConfig = this.mergeConfig(config);
        Class<?> clazz = object.getClass();
        String tableName = this.getTableName(clazz, finalConfig);
        final Map<String, ExpectedAttributeValue> userProvidedExpectedValues = saveExpression == null ? null : saveExpression.getExpected();
        boolean forcePut = finalConfig.getSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.CLOBBER || this.needAutoGenerateAssignableKey(clazz, object);
        SaveObjectHandler saveObjectHandler = forcePut ? new SaveObjectHandler(this, clazz, object, tableName, finalConfig.getSaveBehavior(), userProvidedExpectedValues){
            {
                DynamoDBMapper dynamoDBMapper2 = x0;
                dynamoDBMapper2.getClass();
                super(x1, x2, x3, x4, x5);
            }

            protected void onKeyAttributeValue(String attributeName, AttributeValue keyAttributeValue) {
                this.getAttributeValueUpdates().put(attributeName, new AttributeValueUpdate().withValue(keyAttributeValue).withAction("PUT"));
            }

            protected void onNullNonKeyAttribute(String attributeName) {
            }

            protected void executeLowLevelRequest(boolean onlyKeyAttributeSpecified) {
                Map attributeValues = DynamoDBMapper.this.convertToItem(this.getAttributeValueUpdates());
                attributeValues = DynamoDBMapper.this.transformAttributes(DynamoDBMapper.this.toParameters(attributeValues, this.clazz, finalConfig));
                DynamoDBMapper.this.db.putItem(DynamoDBMapper.applyUserAgent(new PutItemRequest().withTableName(this.getTableName()).withItem(attributeValues).withExpected(this.getExpectedAttributeValues())));
            }
        } : new SaveObjectHandler(this, clazz, object, tableName, finalConfig.getSaveBehavior(), userProvidedExpectedValues){
            {
                DynamoDBMapper dynamoDBMapper2 = x0;
                dynamoDBMapper2.getClass();
                super(x1, x2, x3, x4, x5);
            }

            protected void onKeyAttributeValue(String attributeName, AttributeValue keyAttributeValue) {
                this.getKeyAttributeValues().put(attributeName, keyAttributeValue);
            }

            protected void onNonKeyAttribute(String attributeName, AttributeValue currentValue) {
                if (this.getLocalSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.APPEND_SET && (currentValue.getBS() != null || currentValue.getNS() != null || currentValue.getSS() != null)) {
                    this.getAttributeValueUpdates().put(attributeName, new AttributeValueUpdate().withValue(currentValue).withAction("ADD"));
                    return;
                }
                super.onNonKeyAttribute(attributeName, currentValue);
            }

            protected void onNullNonKeyAttribute(String attributeName) {
                if (this.getLocalSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.UPDATE_SKIP_NULL_ATTRIBUTES || this.getLocalSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.APPEND_SET) {
                    return;
                }
                this.getAttributeValueUpdates().put(attributeName, new AttributeValueUpdate().withAction("DELETE"));
            }

            protected void executeLowLevelRequest(boolean onlyKeyAttributeSpecified) {
                boolean doUpdateItem = true;
                if (onlyKeyAttributeSpecified && this.getLocalSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.UPDATE) {
                    doUpdateItem = false;
                    try {
                        DynamoDBMapper.this.keyOnlyPut(this.clazz, this.object, this.getTableName(), DynamoDBMapper.this.reflector.getHashKeyGetter(this.clazz), DynamoDBMapper.this.reflector.getRangeKeyGetter(this.clazz), userProvidedExpectedValues, finalConfig);
                    }
                    catch (AmazonServiceException ase) {
                        if (ase.getErrorCode().equals("ConditionalCheckFailedException")) {
                            doUpdateItem = true;
                        }
                        throw ase;
                    }
                }
                if (doUpdateItem) {
                    DynamoDBMapper.this.db.updateItem(DynamoDBMapper.applyUserAgent(new UpdateItemRequest().withTableName(this.getTableName()).withKey(this.getKeyAttributeValues()).withAttributeUpdates(DynamoDBMapper.this.transformAttributeUpdates(this.clazz, this.getKeyAttributeValues(), this.getAttributeValueUpdates(), finalConfig)).withExpected(this.getExpectedAttributeValues())));
                }
            }
        };
        saveObjectHandler.execute();
    }

    private void keyOnlyPut(Class<?> clazz, Object object, String tableName, Method hashKeyGetter, Method rangeKeyGetter, Map<String, ExpectedAttributeValue> userProvidedExpectedValues, DynamoDBMapperConfig config) {
        Map<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        HashMap<String, ExpectedAttributeValue> expectedValues = new HashMap<String, ExpectedAttributeValue>();
        String hashKeyAttributeName = this.reflector.getAttributeName(hashKeyGetter);
        Object hashGetterResult = this.safeInvoke(hashKeyGetter, object, new Object[0]);
        attributes.put(hashKeyAttributeName, this.getSimpleAttributeValue(hashKeyGetter, hashGetterResult));
        expectedValues.put(hashKeyAttributeName, new ExpectedAttributeValue().withExists(false));
        if (rangeKeyGetter != null) {
            String rangeKeyAttributeName = this.reflector.getAttributeName(rangeKeyGetter);
            Object rangeGetterResult = this.safeInvoke(rangeKeyGetter, object, new Object[0]);
            attributes.put(rangeKeyAttributeName, this.getSimpleAttributeValue(rangeKeyGetter, rangeGetterResult));
            expectedValues.put(rangeKeyAttributeName, new ExpectedAttributeValue().withExists(false));
        }
        attributes = this.transformAttributes(this.toParameters(attributes, clazz, config));
        if (userProvidedExpectedValues != null) {
            expectedValues.putAll(userProvidedExpectedValues);
        }
        this.db.putItem(DynamoDBMapper.applyUserAgent(new PutItemRequest().withTableName(tableName).withItem(attributes).withExpected(expectedValues)));
    }

    public void delete(Object object) {
        this.delete(object, null, this.config);
    }

    public void delete(Object object, DynamoDBDeleteExpression deleteExpression) {
        this.delete(object, deleteExpression, this.config);
    }

    public void delete(Object object, DynamoDBMapperConfig config) {
        this.delete(object, null, config);
    }

    public <T> void delete(T object, DynamoDBDeleteExpression deleteExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        Class<?> clazz = object.getClass();
        String tableName = this.getTableName(clazz, config);
        Map<String, AttributeValue> key = this.getKey(object, clazz);
        HashMap<String, ExpectedAttributeValue> expectedValues = new HashMap<String, ExpectedAttributeValue>();
        if (config.getSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER) {
            for (Method method : this.reflector.getRelevantGetters(clazz)) {
                if (!this.reflector.isVersionAttributeGetter(method)) continue;
                Object getterResult = this.safeInvoke(method, object, new Object[0]);
                String attributeName = this.reflector.getAttributeName(method);
                ExpectedAttributeValue expected = new ExpectedAttributeValue();
                AttributeValue currentValue = this.getSimpleAttributeValue(method, getterResult);
                expected.setExists(currentValue != null);
                if (currentValue != null) {
                    expected.setValue(currentValue);
                }
                expectedValues.put(attributeName, expected);
                break;
            }
        }
        if (deleteExpression != null && deleteExpression.getExpected() != null) {
            expectedValues.putAll(deleteExpression.getExpected());
        }
        this.db.deleteItem(DynamoDBMapper.applyUserAgent(new DeleteItemRequest().withKey(key).withTableName(tableName).withExpected(expectedValues)));
    }

    public List<FailedBatch> batchDelete(List<? extends Object> objectsToDelete) {
        return this.batchWrite(Collections.emptyList(), objectsToDelete, this.config);
    }

    public List<FailedBatch> batchDelete(Object ... objectsToDelete) {
        return this.batchWrite(Collections.emptyList(), Arrays.asList(objectsToDelete), this.config);
    }

    public List<FailedBatch> batchSave(List<? extends Object> objectsToSave) {
        return this.batchWrite(objectsToSave, Collections.emptyList(), this.config);
    }

    public List<FailedBatch> batchSave(Object ... objectsToSave) {
        return this.batchWrite(Arrays.asList(objectsToSave), Collections.emptyList(), this.config);
    }

    public List<FailedBatch> batchWrite(List<? extends Object> objectsToWrite, List<? extends Object> objectsToDelete) {
        return this.batchWrite(objectsToWrite, objectsToDelete, this.config);
    }

    /*
     * WARNING - void declaration
     */
    public List<FailedBatch> batchWrite(List<? extends Object> objectsToWrite, List<? extends Object> objectsToDelete, DynamoDBMapperConfig config) {
        String tableName;
        Class<?> clazz;
        config = this.mergeConfig(config);
        LinkedList<FailedBatch> totalFailedBatches = new LinkedList<FailedBatch>();
        HashMap requestItems = new HashMap();
        LinkedList<ValueUpdate> inMemoryUpdates = new LinkedList<ValueUpdate>();
        for (Object object : objectsToWrite) {
            clazz = object.getClass();
            tableName = this.getTableName(clazz, config);
            HashMap<String, AttributeValue> attributeValues = new HashMap<String, AttributeValue>();
            for (Method method : this.reflector.getRelevantGetters(clazz)) {
                Object getterResult = this.safeInvoke(method, object, new Object[0]);
                String attributeName = this.reflector.getAttributeName(method);
                AttributeValue currentValue = null;
                if (getterResult == null && this.reflector.isAssignableKey(method)) {
                    currentValue = this.getAutoGeneratedKeyAttributeValue(method, getterResult);
                    inMemoryUpdates.add(new ValueUpdate(method, currentValue, object));
                } else {
                    currentValue = this.getSimpleAttributeValue(method, getterResult);
                }
                if (currentValue == null) continue;
                attributeValues.put(attributeName, currentValue);
            }
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, new LinkedList());
            }
            AttributeTransformer.Parameters<?> parameters = this.toParameters(attributeValues, clazz, config);
            ((List)requestItems.get(tableName)).add(new WriteRequest().withPutRequest(new PutRequest().withItem(this.transformAttributes(parameters))));
        }
        for (Object object : objectsToDelete) {
            clazz = object.getClass();
            tableName = this.getTableName(clazz, config);
            Map<String, AttributeValue> key = this.getKey(object);
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, new LinkedList());
            }
            ((List)requestItems.get(tableName)).add(new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(key)));
        }
        while (!requestItems.isEmpty()) {
            void var8_12;
            HashMap<String, List<WriteRequest>> batch = new HashMap<String, List<WriteRequest>>();
            boolean bl = false;
            Iterator tableIter = requestItems.entrySet().iterator();
            while (tableIter.hasNext() && var8_12 < 25) {
                Map.Entry tableRequest = tableIter.next();
                batch.put((String)tableRequest.getKey(), new LinkedList());
                Iterator writeRequestIter = ((List)tableRequest.getValue()).iterator();
                while (writeRequestIter.hasNext() && ++var8_12 < 25) {
                    WriteRequest writeRequest = (WriteRequest)writeRequestIter.next();
                    batch.get(tableRequest.getKey()).add(writeRequest);
                    writeRequestIter.remove();
                }
                if (writeRequestIter.hasNext()) continue;
                tableIter.remove();
            }
            List<FailedBatch> failedBatches = this.writeOneBatch(batch);
            if (failedBatches == null) continue;
            totalFailedBatches.addAll(failedBatches);
            if (!this.containsThrottlingException(failedBatches)) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AmazonClientException(e.getMessage(), e);
            }
        }
        for (ValueUpdate valueUpdate : inMemoryUpdates) {
            valueUpdate.apply();
        }
        return totalFailedBatches;
    }

    private List<FailedBatch> writeOneBatch(Map<String, List<WriteRequest>> batch) {
        LinkedList<FailedBatch> failedBatches = new LinkedList<FailedBatch>();
        HashMap<String, List<WriteRequest>> firstHalfBatch = new HashMap<String, List<WriteRequest>>();
        HashMap<String, List<WriteRequest>> secondHalfBatch = new HashMap<String, List<WriteRequest>>();
        FailedBatch failedBatch = this.callUntilCompletion(batch);
        if (failedBatch != null) {
            if (failedBatch.getException() instanceof AmazonServiceException && RetryUtils.isRequestEntityTooLargeException((AmazonServiceException)failedBatch.getException())) {
                if (this.computeFailedBatchSize(failedBatch) == 1) {
                    failedBatches.add(failedBatch);
                } else {
                    this.divideBatch(batch, firstHalfBatch, secondHalfBatch);
                    failedBatches.addAll(this.writeOneBatch(firstHalfBatch));
                    failedBatches.addAll(this.writeOneBatch(secondHalfBatch));
                }
            } else {
                failedBatches.add(failedBatch);
            }
        }
        return failedBatches;
    }

    private boolean containsThrottlingException(List<FailedBatch> failedBatches) {
        for (FailedBatch failedBatch : failedBatches) {
            Exception e = failedBatch.getException();
            if (!(e instanceof AmazonServiceException) || !RetryUtils.isThrottlingException((AmazonServiceException)e)) continue;
            return true;
        }
        return false;
    }

    private void divideBatch(Map<String, List<WriteRequest>> batch, Map<String, List<WriteRequest>> firstHalfBatch, Map<String, List<WriteRequest>> secondHalfBatch) {
        for (String key : batch.keySet()) {
            List<WriteRequest> requests = batch.get(key);
            List<WriteRequest> firstHalfRequests = requests.subList(0, requests.size() / 2);
            List<WriteRequest> secondHalfRequests = requests.subList(requests.size() / 2, requests.size());
            firstHalfBatch.put(key, firstHalfRequests);
            secondHalfBatch.put(key, secondHalfRequests);
        }
    }

    private int computeFailedBatchSize(FailedBatch failedBatch) {
        int count = 0;
        for (String tableName : failedBatch.getUnprocessedItems().keySet()) {
            count += failedBatch.getUnprocessedItems().get(tableName).size();
        }
        return count;
    }

    private FailedBatch callUntilCompletion(Map<String, List<WriteRequest>> batch) {
        BatchWriteItemResult result = null;
        int retries = 0;
        FailedBatch failedBatch = null;
        while (true) {
            try {
                result = this.db.batchWriteItem(new BatchWriteItemRequest().withRequestItems(batch));
            }
            catch (Exception e) {
                failedBatch = new FailedBatch();
                failedBatch.setUnprocessedItems(batch);
                failedBatch.setException(e);
                return failedBatch;
            }
            ++retries;
            batch = result.getUnprocessedItems();
            if (batch.size() <= 0) break;
            this.pauseExponentially(retries);
        }
        return failedBatch;
    }

    public Map<String, List<Object>> batchLoad(List<Object> itemsToGet) {
        return this.batchLoad(itemsToGet, this.config);
    }

    public Map<String, List<Object>> batchLoad(List<Object> itemsToGet, DynamoDBMapperConfig config) {
        boolean consistentReads;
        boolean bl = consistentReads = (config = this.mergeConfig(config)).getConsistentReads() == DynamoDBMapperConfig.ConsistentReads.CONSISTENT;
        if (itemsToGet == null || itemsToGet.isEmpty()) {
            return new HashMap<String, List<Object>>();
        }
        HashMap<String, KeysAndAttributes> requestItems = new HashMap<String, KeysAndAttributes>();
        HashMap classesByTableName = new HashMap();
        HashMap<String, List<Object>> resultSet = new HashMap<String, List<Object>>();
        int count = 0;
        for (Object keyObject : itemsToGet) {
            Class<?> clazz = keyObject.getClass();
            String tableName = this.getTableName(clazz, config);
            classesByTableName.put(tableName, clazz);
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, new KeysAndAttributes().withConsistentRead(consistentReads).withKeys(new LinkedList<Map<String, AttributeValue>>()));
            }
            ((KeysAndAttributes)requestItems.get(tableName)).getKeys().add(this.getKey(keyObject));
            if (++count != 100) continue;
            this.processBatchGetRequest(classesByTableName, requestItems, resultSet, config);
            requestItems.clear();
            count = 0;
        }
        if (count > 0) {
            this.processBatchGetRequest(classesByTableName, requestItems, resultSet, config);
        }
        return resultSet;
    }

    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet) {
        return this.batchLoad(itemsToGet, this.config);
    }

    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet, DynamoDBMapperConfig config) {
        ArrayList<Object> keys = new ArrayList<Object>();
        if (itemsToGet != null) {
            for (Class<?> clazz : itemsToGet.keySet()) {
                if (itemsToGet.get(clazz) == null) continue;
                for (KeyPair keyPair : itemsToGet.get(clazz)) {
                    keys.add(this.createKeyObject(clazz, keyPair.getHashKey(), keyPair.getRangeKey()));
                }
            }
        }
        return this.batchLoad(keys, config);
    }

    private void processBatchGetRequest(Map<String, Class<?>> classesByTableName, Map<String, KeysAndAttributes> requestItems, Map<String, List<Object>> resultSet, DynamoDBMapperConfig config) {
        BatchGetItemResult batchGetItemResult = null;
        BatchGetItemRequest batchGetItemRequest = new BatchGetItemRequest();
        batchGetItemRequest.setRequestItems(requestItems);
        do {
            if (batchGetItemResult != null) {
                batchGetItemRequest.setRequestItems(batchGetItemResult.getUnprocessedKeys());
            }
            batchGetItemResult = this.db.batchGetItem(batchGetItemRequest);
            Map<String, List<Map<String, AttributeValue>>> responses = batchGetItemResult.getResponses();
            for (String tableName : responses.keySet()) {
                List<Object> objects = null;
                objects = resultSet.get(tableName) != null ? resultSet.get(tableName) : new LinkedList();
                Class<?> clazz = classesByTableName.get(tableName);
                for (Map<String, AttributeValue> item : responses.get(tableName)) {
                    AttributeTransformer.Parameters<?> parameters = this.toParameters(item, clazz, config);
                    objects.add(this.marshalIntoObject(parameters));
                }
                resultSet.put(tableName, objects);
            }
        } while (batchGetItemResult.getUnprocessedKeys() != null && batchGetItemResult.getUnprocessedKeys().size() > 0);
    }

    private Object safeInvoke(Method method, Object object, Object ... arguments) {
        try {
            return method.invoke(object, arguments);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
        catch (IllegalArgumentException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
        catch (InvocationTargetException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
    }

    private Map<String, AttributeValue> convertToItem(Map<String, AttributeValueUpdate> putValues) {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, AttributeValueUpdate> entry : putValues.entrySet()) {
            if (entry.getValue().getValue() == null) continue;
            map.put(entry.getKey(), entry.getValue().getValue());
        }
        return map;
    }

    private AttributeValue getVersionAttributeValue(Method getter, Object getterReturnResult) {
        ArgumentMarshaller marshaller = this.reflector.getVersionedArgumentMarshaller(getter, getterReturnResult);
        return marshaller.marshall(getterReturnResult);
    }

    private AttributeValue getAutoGeneratedKeyAttributeValue(Method getter, Object getterResult) {
        ArgumentMarshaller marshaller = this.reflector.getAutoGeneratedKeyArgumentMarshaller(getter);
        return marshaller.marshall(getterResult);
    }

    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDBScanExpression scanExpression) {
        return this.scan(clazz, scanExpression, this.config);
    }

    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        ScanResult scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
        return new PaginatedScanList<T>(this, clazz, this.db, scanRequest, scanResult, config.getPaginationLoadingStrategy(), config);
    }

    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> clazz, DynamoDBScanExpression scanExpression, int totalSegments) {
        return this.parallelScan(clazz, scanExpression, totalSegments, this.config);
    }

    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> clazz, DynamoDBScanExpression scanExpression, int totalSegments, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        List<ScanRequest> parallelScanRequests = this.createParallelScanRequestsFromExpression(clazz, scanExpression, totalSegments, config);
        ParallelScanTask parallelScanTask = new ParallelScanTask(this, this.db, parallelScanRequests);
        return new PaginatedParallelScanList<T>(this, clazz, this.db, parallelScanTask, config.getPaginationLoadingStrategy(), config);
    }

    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        ScanResult scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
        ScanResultPage<T> result = new ScanResultPage<T>();
        List<AttributeTransformer.Parameters<T>> parameters = this.toParameters(scanResult.getItems(), clazz, config);
        result.setResults(this.marshalIntoObjects(parameters));
        result.setLastEvaluatedKey(scanResult.getLastEvaluatedKey());
        return result;
    }

    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDBScanExpression scanExpression) {
        return this.scanPage(clazz, scanExpression, this.config);
    }

    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression) {
        return this.query(clazz, queryExpression, this.config);
    }

    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        QueryResult queryResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
        return new PaginatedQueryList<T>(this, clazz, this.db, queryRequest, queryResult, config.getPaginationLoadingStrategy(), config);
    }

    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression) {
        return this.queryPage(clazz, queryExpression, this.config);
    }

    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        QueryResult scanResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
        QueryResultPage<T> result = new QueryResultPage<T>();
        List<AttributeTransformer.Parameters<T>> parameters = this.toParameters(scanResult.getItems(), clazz, config);
        result.setResults(this.marshalIntoObjects(parameters));
        result.setLastEvaluatedKey(scanResult.getLastEvaluatedKey());
        return result;
    }

    public int count(Class<?> clazz, DynamoDBScanExpression scanExpression) {
        return this.count(clazz, scanExpression, this.config);
    }

    public int count(Class<?> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        scanRequest.setSelect(Select.COUNT);
        int count = 0;
        ScanResult scanResult = null;
        do {
            scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
            count += scanResult.getCount().intValue();
            scanRequest.setExclusiveStartKey(scanResult.getLastEvaluatedKey());
        } while (scanResult.getLastEvaluatedKey() != null);
        return count;
    }

    public <T> int count(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression) {
        return this.count(clazz, queryExpression, this.config);
    }

    public <T> int count(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        queryRequest.setSelect(Select.COUNT);
        int count = 0;
        QueryResult queryResult = null;
        do {
            queryResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
            count += queryResult.getCount().intValue();
            queryRequest.setExclusiveStartKey(queryResult.getLastEvaluatedKey());
        } while (queryResult.getLastEvaluatedKey() != null);
        return count;
    }

    private DynamoDBMapperConfig mergeConfig(DynamoDBMapperConfig config) {
        if (config != this.config) {
            config = new DynamoDBMapperConfig(this.config, config);
        }
        return config;
    }

    private ScanRequest createScanRequestFromExpression(Class<?> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.setTableName(this.getTableName(clazz, config));
        scanRequest.setScanFilter(scanExpression.getScanFilter());
        scanRequest.setLimit(scanExpression.getLimit());
        scanRequest.setExclusiveStartKey(scanExpression.getExclusiveStartKey());
        return scanRequest;
    }

    private List<ScanRequest> createParallelScanRequestsFromExpression(Class<?> clazz, DynamoDBScanExpression scanExpression, int totalSegments, DynamoDBMapperConfig config) {
        if (totalSegments < 1) {
            throw new IllegalArgumentException("Parallel scan should have at least one scan segment.");
        }
        LinkedList<ScanRequest> parallelScanRequests = new LinkedList<ScanRequest>();
        for (int segment = 0; segment < totalSegments; ++segment) {
            ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
            parallelScanRequests.add(scanRequest.withSegment(segment).withTotalSegments(totalSegments));
        }
        return parallelScanRequests;
    }

    private <T> QueryRequest createQueryRequestFromExpression(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setConsistentRead(queryExpression.isConsistentRead());
        queryRequest.setTableName(this.getTableName(clazz, config));
        queryRequest.setIndexName(queryExpression.getIndexName());
        Map<String, Condition> keyConditions = this.getHashKeyEqualsConditions(queryExpression.getHashKeyValues());
        Map<String, Condition> rangeKeyConditions = queryExpression.getRangeKeyConditions();
        if (null != rangeKeyConditions) {
            this.processRangeKeyConditions(clazz, queryRequest, rangeKeyConditions);
            keyConditions.putAll(rangeKeyConditions);
        }
        queryRequest.setKeyConditions(keyConditions);
        queryRequest.setScanIndexForward(queryExpression.isScanIndexForward());
        queryRequest.setLimit(queryExpression.getLimit());
        queryRequest.setExclusiveStartKey(queryExpression.getExclusiveStartKey());
        return queryRequest;
    }

    private void processRangeKeyConditions(Class<?> clazz, QueryRequest queryRequest, Map<String, Condition> rangeKeyConditions) {
        if (rangeKeyConditions.size() > 1) {
            throw new AmazonClientException("Conditions on multiple range keys (" + rangeKeyConditions.keySet().toString() + ") are found in the query. DynamoDB service only accepts up to ONE range key condition.");
        }
        String assignedIndexName = queryRequest.getIndexName();
        for (String rangeKey : rangeKeyConditions.keySet()) {
            if (rangeKey.equals(this.reflector.getPrimaryRangeKeyName(clazz))) {
                if (null == assignedIndexName) continue;
                throw new AmazonClientException("The range key (" + rangeKey + ") in the query is the primary key of the table, not the range key of index (" + assignedIndexName + ").");
            }
            List<String> annotatedIndexNames = this.reflector.getIndexNameByIndexRangeKeyName(clazz, rangeKey);
            if (null != annotatedIndexNames) {
                if (null == assignedIndexName) {
                    if (1 == annotatedIndexNames.size()) {
                        queryRequest.setIndexName(annotatedIndexNames.get(0));
                        continue;
                    }
                    throw new AmazonClientException("Please specify which index to be used for this query. (Choose from " + annotatedIndexNames.toString() + ").");
                }
                if (annotatedIndexNames.contains(assignedIndexName)) continue;
                throw new AmazonClientException(assignedIndexName + " is not annotated as an index in the @DynamoDBIndexRangeKey annotation on " + rangeKey + "(Choose from " + annotatedIndexNames.toString() + ").");
            }
            throw new AmazonClientException("The range key used in the query (" + rangeKey + ") is not annotated with " + "either @DynamoDBRangeKey or @DynamoDBIndexRangeKey in class (" + clazz.getName() + ").");
        }
    }

    private <T> AttributeTransformer.Parameters<T> toParameters(Map<String, AttributeValue> attributeValues, Class<T> modelClass, DynamoDBMapperConfig mapperConfig) {
        return this.toParameters(attributeValues, false, modelClass, mapperConfig);
    }

    private <T> AttributeTransformer.Parameters<T> toParameters(Map<String, AttributeValue> attributeValues, boolean partialUpdate, Class<T> modelClass, DynamoDBMapperConfig mapperConfig) {
        return new TransformerParameters<T>(this.reflector, attributeValues, partialUpdate, modelClass, mapperConfig);
    }

    final <T> List<AttributeTransformer.Parameters<T>> toParameters(List<Map<String, AttributeValue>> attributeValues, Class<T> modelClass, DynamoDBMapperConfig mapperConfig) {
        ArrayList<AttributeTransformer.Parameters<T>> rval = new ArrayList<AttributeTransformer.Parameters<T>>(attributeValues.size());
        for (Map<String, AttributeValue> item : attributeValues) {
            rval.add(this.toParameters(item, modelClass, mapperConfig));
        }
        return rval;
    }

    private Map<String, AttributeValue> untransformAttributes(AttributeTransformer.Parameters parameters) {
        if (this.transformer != null) {
            return this.transformer.untransform(parameters);
        }
        return this.untransformAttributes(parameters.getModelClass(), parameters.getAttributeValues());
    }

    @Deprecated
    protected Map<String, AttributeValue> untransformAttributes(Class<?> clazz, Map<String, AttributeValue> attributeValues) {
        Method hashKeyGetter = this.reflector.getHashKeyGetter(clazz);
        String hashKeyName = this.reflector.getAttributeName(hashKeyGetter);
        Method rangeKeyGetter = this.reflector.getRangeKeyGetter(clazz);
        String rangeKeyName = rangeKeyGetter == null ? null : this.reflector.getAttributeName(rangeKeyGetter);
        return this.untransformAttributes(hashKeyName, rangeKeyName, attributeValues);
    }

    @Deprecated
    protected Map<String, AttributeValue> untransformAttributes(String hashKey, String rangeKey, Map<String, AttributeValue> attributeValues) {
        return attributeValues;
    }

    private Map<String, AttributeValue> transformAttributes(AttributeTransformer.Parameters parameters) {
        if (this.transformer != null) {
            return this.transformer.transform(parameters);
        }
        return this.transformAttributes(parameters.getModelClass(), parameters.getAttributeValues());
    }

    @Deprecated
    protected Map<String, AttributeValue> transformAttributes(Class<?> clazz, Map<String, AttributeValue> attributeValues) {
        Method hashKeyGetter = this.reflector.getHashKeyGetter(clazz);
        String hashKeyName = this.reflector.getAttributeName(hashKeyGetter);
        Method rangeKeyGetter = this.reflector.getRangeKeyGetter(clazz);
        String rangeKeyName = rangeKeyGetter == null ? null : this.reflector.getAttributeName(rangeKeyGetter);
        return this.transformAttributes(hashKeyName, rangeKeyName, attributeValues);
    }

    @Deprecated
    protected Map<String, AttributeValue> transformAttributes(String hashKey, String rangeKey, Map<String, AttributeValue> attributeValues) {
        return attributeValues;
    }

    private Map<String, AttributeValueUpdate> transformAttributeUpdates(Class<?> clazz, Map<String, AttributeValue> keys, Map<String, AttributeValueUpdate> updateValues, DynamoDBMapperConfig config) {
        Map<String, AttributeValue> item = this.convertToItem(updateValues);
        HashSet<String> keysAdded = new HashSet<String>();
        for (Map.Entry<String, AttributeValue> e : keys.entrySet()) {
            if (item.containsKey(e.getKey())) continue;
            keysAdded.add(e.getKey());
            item.put(e.getKey(), e.getValue());
        }
        AttributeTransformer.Parameters<?> parameters = this.toParameters(item, true, clazz, config);
        String hashKey = parameters.getHashKeyName();
        if (!item.containsKey(hashKey)) {
            item.put(hashKey, keys.get(hashKey));
        }
        item = this.transformAttributes(parameters);
        for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
            if (keysAdded.contains(entry.getKey())) continue;
            AttributeValueUpdate update = updateValues.get(entry.getKey());
            if (update != null) {
                update.getValue().withB(entry.getValue().getB()).withBS(entry.getValue().getBS()).withN(entry.getValue().getN()).withNS(entry.getValue().getNS()).withS(entry.getValue().getS()).withSS(entry.getValue().getSS());
                continue;
            }
            updateValues.put(entry.getKey(), new AttributeValueUpdate(entry.getValue(), "PUT"));
        }
        return updateValues;
    }

    private void pauseExponentially(int retries) {
        if (retries == 0) {
            return;
        }
        Random random = new Random();
        long delay = 0L;
        long scaleFactor = 500 + random.nextInt(100);
        delay = (long)(Math.pow(2.0, retries) * (double)scaleFactor);
        delay = Math.min(delay, 3000L);
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AmazonClientException(e.getMessage(), e);
        }
    }

    static <X extends AmazonWebServiceRequest> X applyUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return request;
    }

    public S3ClientCache getS3ClientCache() {
        return this.s3cc;
    }

    public S3Link createS3Link(String bucketName, String key) {
        return this.createS3Link(null, bucketName, key);
    }

    public S3Link createS3Link(Region s3region, String bucketName, String key) {
        if (this.s3cc == null) {
            throw new IllegalStateException("Mapper must be constructed with S3 AWS Credentials to create S3Link");
        }
        return new S3Link(this.s3cc, s3region, bucketName, key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FailedBatch {
        private Map<String, List<WriteRequest>> unprocessedItems;
        private Exception exception;

        public void setUnprocessedItems(Map<String, List<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = unprocessedItems;
        }

        public Map<String, List<WriteRequest>> getUnprocessedItems() {
            return this.unprocessedItems;
        }

        public void setException(Exception excetpion) {
            this.exception = excetpion;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformerParameters<T>
    implements AttributeTransformer.Parameters<T> {
        private final DynamoDBReflector reflector;
        private final Map<String, AttributeValue> attributeValues;
        private final boolean partialUpdate;
        private final Class<T> modelClass;
        private final DynamoDBMapperConfig mapperConfig;
        private String tableName;
        private String hashKeyName;
        private String rangeKeyName;

        public TransformerParameters(DynamoDBReflector reflector, Map<String, AttributeValue> attributeValues, boolean partialUpdate, Class<T> modelClass, DynamoDBMapperConfig mapperConfig) {
            this.reflector = reflector;
            this.attributeValues = Collections.unmodifiableMap(attributeValues);
            this.partialUpdate = partialUpdate;
            this.modelClass = modelClass;
            this.mapperConfig = mapperConfig;
        }

        @Override
        public Map<String, AttributeValue> getAttributeValues() {
            return this.attributeValues;
        }

        @Override
        public boolean isPartialUpdate() {
            return this.partialUpdate;
        }

        @Override
        public Class<T> getModelClass() {
            return this.modelClass;
        }

        @Override
        public DynamoDBMapperConfig getMapperConfig() {
            return this.mapperConfig;
        }

        @Override
        public String getTableName() {
            if (this.tableName == null) {
                this.tableName = DynamoDBMapper.getTableName(this.modelClass, this.mapperConfig, this.reflector);
            }
            return this.tableName;
        }

        @Override
        public String getHashKeyName() {
            if (this.hashKeyName == null) {
                Method hashKeyGetter = this.reflector.getHashKeyGetter(this.modelClass);
                this.hashKeyName = this.reflector.getAttributeName(hashKeyGetter);
            }
            return this.hashKeyName;
        }

        @Override
        public String getRangeKeyName() {
            if (this.rangeKeyName == null) {
                Method rangeKeyGetter = this.reflector.getRangeKeyGetter(this.modelClass);
                this.rangeKeyName = rangeKeyGetter == null ? NO_RANGE_KEY : this.reflector.getAttributeName(rangeKeyGetter);
            }
            if (this.rangeKeyName == NO_RANGE_KEY) {
                return null;
            }
            return this.rangeKeyName;
        }
    }

    private final class ValueUpdate {
        private Method method;
        private AttributeValue newValue;
        private Object target;

        public ValueUpdate(Method method, AttributeValue newValue, Object target) {
            this.method = method;
            this.newValue = newValue;
            this.target = target;
        }

        public void apply() {
            DynamoDBMapper.this.setValue(this.target, this.method, this.newValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class SaveObjectHandler {
        protected final Object object;
        protected final Class<?> clazz;
        private String tableName;
        private DynamoDBMapperConfig.SaveBehavior saveBehavior;
        private Map<String, AttributeValue> key;
        private Map<String, AttributeValueUpdate> updateValues;
        private Map<String, ExpectedAttributeValue> expectedValues;
        private List<ValueUpdate> inMemoryUpdates;
        private boolean nonKeyAttributePresent;

        public SaveObjectHandler(Class<?> clazz, Object object, String tableName, DynamoDBMapperConfig.SaveBehavior saveBehavior, Map<String, ExpectedAttributeValue> userProvidedExpectedValues) {
            this.clazz = clazz;
            this.object = object;
            this.tableName = tableName;
            this.saveBehavior = saveBehavior;
            this.updateValues = new HashMap<String, AttributeValueUpdate>();
            this.expectedValues = new HashMap<String, ExpectedAttributeValue>();
            if (userProvidedExpectedValues != null) {
                this.expectedValues.putAll(userProvidedExpectedValues);
            }
            this.inMemoryUpdates = new LinkedList<ValueUpdate>();
            this.key = new HashMap<String, AttributeValue>();
            this.nonKeyAttributePresent = false;
        }

        public void execute() {
            String attributeName;
            Object getterResult;
            Collection<Method> keyGetters = DynamoDBMapper.this.reflector.getKeyGetters(this.clazz);
            for (Method method : keyGetters) {
                getterResult = DynamoDBMapper.this.safeInvoke(method, this.object, new Object[0]);
                attributeName = DynamoDBMapper.this.reflector.getAttributeName(method);
                if (getterResult == null && DynamoDBMapper.this.reflector.isAssignableKey(method)) {
                    this.onAutoGenerateAssignableKey(method, attributeName);
                    continue;
                }
                AttributeValue newAttributeValue = DynamoDBMapper.this.getSimpleAttributeValue(method, getterResult);
                if (newAttributeValue == null) {
                    throw new DynamoDBMappingException("Null or empty value for key: " + method);
                }
                this.onKeyAttributeValue(attributeName, newAttributeValue);
            }
            for (Method method : DynamoDBMapper.this.reflector.getRelevantGetters(this.clazz)) {
                if (keyGetters.contains(method)) continue;
                getterResult = DynamoDBMapper.this.safeInvoke(method, this.object, new Object[0]);
                attributeName = DynamoDBMapper.this.reflector.getAttributeName(method);
                if (DynamoDBMapper.this.reflector.isVersionAttributeGetter(method)) {
                    this.onVersionAttribute(method, getterResult, attributeName);
                    this.nonKeyAttributePresent = true;
                    continue;
                }
                AttributeValue currentValue = DynamoDBMapper.this.getSimpleAttributeValue(method, getterResult);
                if (currentValue != null) {
                    this.onNonKeyAttribute(attributeName, currentValue);
                    this.nonKeyAttributePresent = true;
                    continue;
                }
                this.onNullNonKeyAttribute(attributeName);
            }
            this.executeLowLevelRequest(!this.nonKeyAttributePresent);
            for (ValueUpdate update : this.inMemoryUpdates) {
                update.apply();
            }
        }

        protected abstract void onKeyAttributeValue(String var1, AttributeValue var2);

        protected void onNonKeyAttribute(String attributeName, AttributeValue currentValue) {
            this.updateValues.put(attributeName, new AttributeValueUpdate().withValue(currentValue).withAction("PUT"));
        }

        protected abstract void onNullNonKeyAttribute(String var1);

        protected abstract void executeLowLevelRequest(boolean var1);

        protected DynamoDBMapperConfig.SaveBehavior getLocalSaveBehavior() {
            return this.saveBehavior;
        }

        protected String getTableName() {
            return this.tableName;
        }

        protected Map<String, AttributeValue> getKeyAttributeValues() {
            return this.key;
        }

        protected Map<String, AttributeValueUpdate> getAttributeValueUpdates() {
            return this.updateValues;
        }

        protected Map<String, ExpectedAttributeValue> getExpectedAttributeValues() {
            return this.expectedValues;
        }

        protected List<ValueUpdate> getInMemoryUpdates() {
            return this.inMemoryUpdates;
        }

        private void onAutoGenerateAssignableKey(Method method, String attributeName) {
            AttributeValue newVersionValue = DynamoDBMapper.this.getAutoGeneratedKeyAttributeValue(method, null);
            this.updateValues.put(attributeName, new AttributeValueUpdate().withAction("PUT").withValue(newVersionValue));
            this.inMemoryUpdates.add(new ValueUpdate(method, newVersionValue, this.object));
            if (this.getLocalSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER && !this.expectedValues.containsKey(attributeName)) {
                ExpectedAttributeValue expected = new ExpectedAttributeValue();
                expected.setExists(false);
                this.expectedValues.put(attributeName, expected);
            }
        }

        private void onVersionAttribute(Method method, Object getterResult, String attributeName) {
            if (this.getLocalSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER && !this.expectedValues.containsKey(attributeName)) {
                ExpectedAttributeValue expected = new ExpectedAttributeValue();
                AttributeValue currentValue = DynamoDBMapper.this.getSimpleAttributeValue(method, getterResult);
                expected.setExists(currentValue != null);
                if (currentValue != null) {
                    expected.setValue(currentValue);
                }
                this.expectedValues.put(attributeName, expected);
            }
            AttributeValue newVersionValue = DynamoDBMapper.this.getVersionAttributeValue(method, getterResult);
            this.updateValues.put(attributeName, new AttributeValueUpdate().withAction("PUT").withValue(newVersionValue));
            this.inMemoryUpdates.add(new ValueUpdate(method, newVersionValue, this.object));
        }
    }
}

