/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.metrics.MetricCollector;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.metrics.ServiceMetricCollector;
import com.amazonaws.regions.Regions;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.AWSServiceMetrics;
import com.amazonaws.util.jmx.MBeans;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AwsSdkMetrics {

    public static final String METRICS_NAMESPACE = "AWSSDK/Java";
    private static final String MBEAN_OBJECT_NAME = "com.amazonaws.management:type=" + AwsSdkMetrics.class.getSimpleName();
    public static final String EXCLUDE_MACHINE_METRICS = "excludeMachineMetrics";
    public static final String AWS_CREDENTAIL_PROPERTIES_FILE = "credentialFile";
    public static final String CLOUDWATCH_REGION = "cloudwatchRegion";
    public static final String METRIC_QUEUE_SIZE = "metricQueueSize";
    public static final String QUEUE_POLL_TIMEOUT_MILLI = "getQueuePollTimeoutMilli";
    private static final String DEFAULT_METRIC_COLLECTOR_FACTORY = "com.amazonaws.metrics.internal.cloudwatch.DefaultMetricCollectorFactory";
    private static final boolean defaultMetricsEnabled;
    private static volatile boolean machineMetricsExcluded;
    private static volatile AWSCredentialsProvider credentialProvider;
    private static volatile Regions region;
    private static volatile Integer metricQueueSize;
    private static volatile Long queuePollTimeoutMilli;
    private static final MetricRegistry registry;
    private static volatile MetricCollector mc;
    private static boolean dirtyEnabling;

    public static <T extends RequestMetricCollector> T getRequestMetricCollector() {
        if (mc == null && AwsSdkMetrics.isDefaultMetricsEnabled()) {
            AwsSdkMetrics.enableDefaultMetrics();
        }
        RequestMetricCollector t = mc == null ? RequestMetricCollector.NONE : mc.getRequestMetricCollector();
        return (T)t;
    }

    public static <T extends ServiceMetricCollector> T getServiceMetricCollector() {
        if (mc == null && AwsSdkMetrics.isDefaultMetricsEnabled()) {
            AwsSdkMetrics.enableDefaultMetrics();
        }
        ServiceMetricCollector t = mc == null ? ServiceMetricCollector.NONE : mc.getServiceMetricCollector();
        return (T)t;
    }

    public static <T extends MetricCollector> T getMetricCollector() {
        if (mc == null && AwsSdkMetrics.isDefaultMetricsEnabled()) {
            AwsSdkMetrics.enableDefaultMetrics();
        }
        MetricCollector t = mc == null ? MetricCollector.NONE : mc;
        return (T)t;
    }

    public static synchronized void setMetricCollector(MetricCollector mc) {
        MetricCollector old = AwsSdkMetrics.mc;
        AwsSdkMetrics.mc = mc;
        if (old != null) {
            old.stop();
        }
    }

    public static void setMachineMetricsExcluded(boolean excludeMachineMetrics) {
        machineMetricsExcluded = excludeMachineMetrics;
    }

    public static boolean isDefaultMetricsEnabled() {
        return defaultMetricsEnabled;
    }

    public static boolean isMetricsEnabled() {
        MetricCollector mc = AwsSdkMetrics.mc;
        return mc != null && mc.isEnabled();
    }

    public static boolean isMachineMetricExcluded() {
        return machineMetricsExcluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean enableDefaultMetrics() {
        if (mc == null || !mc.isEnabled()) {
            if (dirtyEnabling) {
                throw new IllegalStateException("Reentrancy is not allowed");
            }
            dirtyEnabling = true;
            try {
                Class<?> c = Class.forName(DEFAULT_METRIC_COLLECTOR_FACTORY);
                MetricCollector.Factory f = (MetricCollector.Factory)c.newInstance();
                MetricCollector instance = f.getInstance();
                if (instance != null) {
                    AwsSdkMetrics.setMetricCollector(instance);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                LogFactory.getLog(AwsSdkMetrics.class).warn((Object)"Failed to enable the default metrics", (Throwable)e);
            }
            finally {
                dirtyEnabling = false;
            }
        }
        return false;
    }

    public static void disableMetrics() {
        AwsSdkMetrics.setMetricCollector(MetricCollector.NONE);
    }

    public static boolean add(MetricType type) {
        return type == null ? false : registry.addMetricType(type);
    }

    public static <T extends MetricType> boolean addAll(Collection<T> types) {
        return types == null || types.size() == 0 ? false : registry.addMetricTypes(types);
    }

    public static <T extends MetricType> void set(Collection<T> types) {
        registry.setMetricTypes(types);
    }

    public static boolean remove(MetricType type) {
        return type == null ? false : registry.removeMetricType(type);
    }

    public static Set<MetricType> getPredefinedMetrics() {
        return registry.predefinedMetrics();
    }

    public static AWSCredentialsProvider getCredentialProvider() {
        StackTraceElement[] e = Thread.currentThread().getStackTrace();
        for (int i = 0; i < e.length; ++i) {
            if (!e[i].getClassName().equals(DEFAULT_METRIC_COLLECTOR_FACTORY)) continue;
            return credentialProvider;
        }
        SecurityException ex = new SecurityException();
        LogFactory.getLog(AwsSdkMetrics.class).warn((Object)"Illegal attempt to access the credential provider", (Throwable)ex);
        throw ex;
    }

    public static void setCredentialProvider(AWSCredentialsProvider provider) {
        credentialProvider = provider;
    }

    public static Regions getRegion() {
        return region;
    }

    public static void setRegion(Regions region) {
        AwsSdkMetrics.region = region;
    }

    public static Integer getMetricQueueSize() {
        return metricQueueSize;
    }

    public static void setMetricQueueSize(Integer size) {
        metricQueueSize = size;
    }

    public static Long getQueuePollTimeoutMilli() {
        return queuePollTimeoutMilli;
    }

    public static void setQueuePollTimeoutMilli(Long timeoutMilli) {
        queuePollTimeoutMilli = timeoutMilli;
    }

    static {
        String defaultMetrics = System.getProperty("com.amazonaws.sdk.enableDefaultMetrics");
        boolean bl = defaultMetricsEnabled = defaultMetrics != null;
        if (defaultMetricsEnabled) {
            String[] values = defaultMetrics.split(",");
            boolean excludeMachineMetrics = false;
            for (String s : values) {
                String part = s.trim();
                if (!excludeMachineMetrics && EXCLUDE_MACHINE_METRICS.equals(part)) {
                    excludeMachineMetrics = true;
                    continue;
                }
                String[] pair = part.split("=");
                if (pair.length != 2) continue;
                String key = pair[0].trim();
                String value = pair[1].trim();
                try {
                    Number i;
                    if (AWS_CREDENTAIL_PROPERTIES_FILE.equals(key)) {
                        final PropertiesCredentials cred = new PropertiesCredentials(new File(value));
                        credentialProvider = new AWSCredentialsProvider(){

                            public void refresh() {
                            }

                            public AWSCredentials getCredentials() {
                                return cred;
                            }
                        };
                        continue;
                    }
                    if (CLOUDWATCH_REGION.equals(key)) {
                        region = Regions.fromName(value);
                        continue;
                    }
                    if (METRIC_QUEUE_SIZE.equals(key)) {
                        i = new Integer(value);
                        if ((Integer)i < 1) {
                            throw new IllegalArgumentException("metricQueueSize must be at least 1");
                        }
                        metricQueueSize = i;
                        continue;
                    }
                    if (QUEUE_POLL_TIMEOUT_MILLI.equals(key)) {
                        i = new Long(value);
                        if (((Long)i).intValue() < 1000) {
                            throw new IllegalArgumentException("getQueuePollTimeoutMilli must be at least 1000");
                        }
                        queuePollTimeoutMilli = i;
                        continue;
                    }
                    LogFactory.getLog(AwsSdkMetrics.class).debug((Object)("Ignoring unrecognized parameter: " + part));
                }
                catch (Exception e) {
                    LogFactory.getLog(AwsSdkMetrics.class).debug((Object)"Ignoring failure", (Throwable)e);
                }
            }
            machineMetricsExcluded = excludeMachineMetrics;
        }
        registry = new MetricRegistry();
        try {
            MBeans.registerMBean(MBEAN_OBJECT_NAME, new Admin());
        }
        catch (Exception ex) {
            LogFactory.getLog(AwsSdkMetrics.class).warn((Object)"", (Throwable)ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetricRegistry {
        private final Set<MetricType> metricTypes = new HashSet<MetricType>();
        private volatile Set<MetricType> readOnly;

        MetricRegistry() {
            this.metricTypes.add(AWSRequestMetrics.Field.ClientExecuteTime);
            this.metricTypes.add(AWSRequestMetrics.Field.Exception);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpClientRetryCount);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpRequestTime);
            this.metricTypes.add(AWSRequestMetrics.Field.RequestCount);
            this.metricTypes.add(AWSRequestMetrics.Field.RetryCount);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpClientSendRequestTime);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
            this.metricTypes.add(AWSServiceMetrics.HttpClientGetConnectionTime);
            this.syncReadOnly();
        }

        private void syncReadOnly() {
            this.readOnly = Collections.unmodifiableSet(new HashSet<MetricType>(this.metricTypes));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addMetricType(MetricType type) {
            Set<MetricType> set = this.metricTypes;
            synchronized (set) {
                boolean added = this.metricTypes.add(type);
                if (added) {
                    this.syncReadOnly();
                }
                return added;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends MetricType> boolean addMetricTypes(Collection<T> types) {
            Set<MetricType> set = this.metricTypes;
            synchronized (set) {
                boolean added = this.metricTypes.addAll(types);
                if (added) {
                    this.syncReadOnly();
                }
                return added;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends MetricType> void setMetricTypes(Collection<T> types) {
            Set<MetricType> set = this.metricTypes;
            synchronized (set) {
                if (types == null || types.size() == 0) {
                    if (this.metricTypes.size() == 0) {
                        return;
                    }
                    if (types == null) {
                        types = Collections.emptyList();
                    }
                }
                this.metricTypes.clear();
                if (!this.addMetricTypes(types)) {
                    this.syncReadOnly();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeMetricType(MetricType type) {
            Set<MetricType> set = this.metricTypes;
            synchronized (set) {
                boolean removed = this.metricTypes.remove(type);
                if (removed) {
                    this.syncReadOnly();
                }
                return removed;
            }
        }

        public Set<MetricType> predefinedMetrics() {
            return this.readOnly;
        }
    }

    private static class Admin
    implements AdminMBean {
        private Admin() {
        }

        public boolean enableDefaultMetrics() {
            return AwsSdkMetrics.enableDefaultMetrics();
        }

        public void disableMetrics() {
            AwsSdkMetrics.disableMetrics();
        }

        public String getRequestMetricCollector() {
            MetricCollector mc = mc;
            RequestMetricCollector rmc = mc == null ? null : mc.getRequestMetricCollector();
            return mc == null || rmc == RequestMetricCollector.NONE ? "NONE" : rmc.getClass().getName();
        }

        public String getServiceMetricCollector() {
            MetricCollector mc = mc;
            ServiceMetricCollector smc = mc == null ? null : mc.getServiceMetricCollector();
            return mc == null || smc == ServiceMetricCollector.NONE ? "NONE" : smc.getClass().getName();
        }

        public boolean isMetricsEnabled() {
            return AwsSdkMetrics.isMetricsEnabled();
        }

        public boolean isMachineMetricsExcluded() {
            return machineMetricsExcluded;
        }

        public void setMachineMetricsExcluded(boolean excludeJvmMetrics) {
            AwsSdkMetrics.setMachineMetricsExcluded(excludeJvmMetrics);
        }

        public String getRegion() {
            return region == null ? null : region.getName();
        }

        public void setRegion(String region) {
            if (region == null || region.isEmpty()) {
                AwsSdkMetrics.setRegion(null);
            } else {
                AwsSdkMetrics.setRegion(Regions.fromName(region));
            }
        }

        public Integer getMetricQueueSize() {
            return metricQueueSize;
        }

        public void setMetricQueueSize(Integer metricQueueSize) {
            AwsSdkMetrics.setMetricQueueSize(metricQueueSize);
        }

        public Integer getQueuePollTimeoutMilli() {
            return queuePollTimeoutMilli == null ? null : Integer.valueOf(queuePollTimeoutMilli.intValue());
        }

        public void setQueuePollTimeoutMilli(Integer timeoutMilli) {
            AwsSdkMetrics.setQueuePollTimeoutMilli(timeoutMilli == null ? null : Long.valueOf(timeoutMilli.longValue()));
        }
    }

    public static interface AdminMBean {
        public boolean isMetricsEnabled();

        public String getRequestMetricCollector();

        public String getServiceMetricCollector();

        public boolean enableDefaultMetrics();

        public void disableMetrics();

        public boolean isMachineMetricsExcluded();

        public void setMachineMetricsExcluded(boolean var1);

        public String getRegion();

        public void setRegion(String var1);

        public Integer getMetricQueueSize();

        public void setMetricQueueSize(Integer var1);

        public Integer getQueuePollTimeoutMilli();

        public void setQueuePollTimeoutMilli(Integer var1);
    }
}

