/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskStatus;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeDetail;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeInfos;
import com.amazonaws.services.simpleworkflow.model.CountClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingActivityTasksRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingDecisionTasksRequest;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.DeprecateActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DomainDetail;
import com.amazonaws.services.simpleworkflow.model.DomainInfos;
import com.amazonaws.services.simpleworkflow.model.GetWorkflowExecutionHistoryRequest;
import com.amazonaws.services.simpleworkflow.model.History;
import com.amazonaws.services.simpleworkflow.model.ListActivityTypesRequest;
import com.amazonaws.services.simpleworkflow.model.ListClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListDomainsRequest;
import com.amazonaws.services.simpleworkflow.model.ListOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListWorkflowTypesRequest;
import com.amazonaws.services.simpleworkflow.model.PendingTaskCount;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.PollForDecisionTaskRequest;
import com.amazonaws.services.simpleworkflow.model.RecordActivityTaskHeartbeatRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterDomainRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RequestCancelWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCanceledRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskFailedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.Run;
import com.amazonaws.services.simpleworkflow.model.SignalWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.StartWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.TerminateWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionCount;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfos;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeInfos;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTaskJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTaskStatusJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTypeDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTypeInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountClosedWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountOpenWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountPendingActivityTasksRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountPendingDecisionTasksRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DecisionTaskJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DefaultUndefinedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateActivityTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateDomainRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateWorkflowTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeActivityTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeDomainRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeWorkflowTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainDeprecatedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.GetWorkflowExecutionHistoryRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.HistoryJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListActivityTypesRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListClosedWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListDomainsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListOpenWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListWorkflowTypesRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.OperationNotPermittedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PendingTaskCountJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PollForActivityTaskRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PollForDecisionTaskRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RecordActivityTaskHeartbeatRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterActivityTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterDomainRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterWorkflowTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RequestCancelWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskCanceledRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskCompletedRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskFailedRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondDecisionTaskCompletedRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RunJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.SignalWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.StartWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TerminateWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TypeAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TypeDeprecatedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.UnknownResourceExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionAlreadyStartedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionCountJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeInfosJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleWorkflowClient
extends AmazonWebServiceClient
implements AmazonSimpleWorkflow {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSimpleWorkflow.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AmazonSimpleWorkflowClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonSimpleWorkflowClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSimpleWorkflowClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSimpleWorkflowClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSimpleWorkflowClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonSimpleWorkflowClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DomainAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DomainDeprecatedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DefaultUndefinedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new OperationNotPermittedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new UnknownResourceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new WorkflowExecutionAlreadyStartedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TypeDeprecatedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TypeAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("swf.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("swf");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simpleworkflow/request.handlers"));
        this.clientConfiguration = new ClientConfiguration(this.clientConfiguration);
        if (this.clientConfiguration.getMaxConnections() == 50) {
            log.debug((Object)"Overriding default max connection value to: 1000");
            this.clientConfiguration.setMaxConnections(1000);
        }
        if (this.clientConfiguration.getSocketTimeout() == 50000) {
            log.debug((Object)"Overriding default socket timeout value to: 90000");
            this.clientConfiguration.setSocketTimeout(90000);
        }
        this.setConfiguration(this.clientConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deprecateWorkflowType(DeprecateWorkflowTypeRequest deprecateWorkflowTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeprecateWorkflowTypeRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deprecateWorkflowTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeprecateWorkflowTypeRequestMarshaller().marshall(deprecateWorkflowTypeRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deprecateDomain(DeprecateDomainRequest deprecateDomainRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeprecateDomainRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deprecateDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeprecateDomainRequestMarshaller().marshall(deprecateDomainRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerWorkflowType(RegisterWorkflowTypeRequest registerWorkflowTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<RegisterWorkflowTypeRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(registerWorkflowTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RegisterWorkflowTypeRequestMarshaller().marshall(registerWorkflowTypeRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowTypeInfos listWorkflowTypes(ListWorkflowTypesRequest listWorkflowTypesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListWorkflowTypesRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(listWorkflowTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ListWorkflowTypesRequestMarshaller().marshall(listWorkflowTypesRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        WorkflowTypeInfosJsonUnmarshaller unmarshaller = new WorkflowTypeInfosJsonUnmarshaller();
        JsonResponseHandler<WorkflowTypeInfos> responseHandler = new JsonResponseHandler<WorkflowTypeInfos>(unmarshaller);
        return (WorkflowTypeInfos)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Run startWorkflowExecution(StartWorkflowExecutionRequest startWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        Request<StartWorkflowExecutionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(startWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new StartWorkflowExecutionRequestMarshaller().marshall(startWorkflowExecutionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        RunJsonUnmarshaller unmarshaller = new RunJsonUnmarshaller();
        JsonResponseHandler<Run> responseHandler = new JsonResponseHandler<Run>(unmarshaller);
        return (Run)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalWorkflowExecution(SignalWorkflowExecutionRequest signalWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        Request<SignalWorkflowExecutionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(signalWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new SignalWorkflowExecutionRequestMarshaller().marshall(signalWorkflowExecutionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomainInfos listDomains(ListDomainsRequest listDomainsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListDomainsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(listDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ListDomainsRequestMarshaller().marshall(listDomainsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DomainInfosJsonUnmarshaller unmarshaller = new DomainInfosJsonUnmarshaller();
        JsonResponseHandler<DomainInfos> responseHandler = new JsonResponseHandler<DomainInfos>(unmarshaller);
        return (DomainInfos)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest requestCancelWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        Request<RequestCancelWorkflowExecutionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(requestCancelWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RequestCancelWorkflowExecutionRequestMarshaller().marshall(requestCancelWorkflowExecutionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowTypeDetail describeWorkflowType(DescribeWorkflowTypeRequest describeWorkflowTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeWorkflowTypeRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeWorkflowTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeWorkflowTypeRequestMarshaller().marshall(describeWorkflowTypeRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        WorkflowTypeDetailJsonUnmarshaller unmarshaller = new WorkflowTypeDetailJsonUnmarshaller();
        JsonResponseHandler<WorkflowTypeDetail> responseHandler = new JsonResponseHandler<WorkflowTypeDetail>(unmarshaller);
        return (WorkflowTypeDetail)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deprecateActivityType(DeprecateActivityTypeRequest deprecateActivityTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeprecateActivityTypeRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deprecateActivityTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeprecateActivityTypeRequestMarshaller().marshall(deprecateActivityTypeRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowExecutionCount countClosedWorkflowExecutions(CountClosedWorkflowExecutionsRequest countClosedWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<CountClosedWorkflowExecutionsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(countClosedWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new CountClosedWorkflowExecutionsRequestMarshaller().marshall(countClosedWorkflowExecutionsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        WorkflowExecutionCountJsonUnmarshaller unmarshaller = new WorkflowExecutionCountJsonUnmarshaller();
        JsonResponseHandler<WorkflowExecutionCount> responseHandler = new JsonResponseHandler<WorkflowExecutionCount>(unmarshaller);
        return (WorkflowExecutionCount)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingTaskCount countPendingActivityTasks(CountPendingActivityTasksRequest countPendingActivityTasksRequest) throws AmazonServiceException, AmazonClientException {
        Request<CountPendingActivityTasksRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(countPendingActivityTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new CountPendingActivityTasksRequestMarshaller().marshall(countPendingActivityTasksRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        PendingTaskCountJsonUnmarshaller unmarshaller = new PendingTaskCountJsonUnmarshaller();
        JsonResponseHandler<PendingTaskCount> responseHandler = new JsonResponseHandler<PendingTaskCount>(unmarshaller);
        return (PendingTaskCount)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void respondActivityTaskCanceled(RespondActivityTaskCanceledRequest respondActivityTaskCanceledRequest) throws AmazonServiceException, AmazonClientException {
        Request<RespondActivityTaskCanceledRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(respondActivityTaskCanceledRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RespondActivityTaskCanceledRequestMarshaller().marshall(respondActivityTaskCanceledRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void respondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest) throws AmazonServiceException, AmazonClientException {
        Request<RespondDecisionTaskCompletedRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(respondDecisionTaskCompletedRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RespondDecisionTaskCompletedRequestMarshaller().marshall(respondDecisionTaskCompletedRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void respondActivityTaskCompleted(RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest) throws AmazonServiceException, AmazonClientException {
        Request<RespondActivityTaskCompletedRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(respondActivityTaskCompletedRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RespondActivityTaskCompletedRequestMarshaller().marshall(respondActivityTaskCompletedRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityTask pollForActivityTask(PollForActivityTaskRequest pollForActivityTaskRequest) throws AmazonServiceException, AmazonClientException {
        Request<PollForActivityTaskRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(pollForActivityTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new PollForActivityTaskRequestMarshaller().marshall(pollForActivityTaskRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ActivityTaskJsonUnmarshaller unmarshaller = new ActivityTaskJsonUnmarshaller();
        JsonResponseHandler<ActivityTask> responseHandler = new JsonResponseHandler<ActivityTask>(unmarshaller);
        return (ActivityTask)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowExecutionCount countOpenWorkflowExecutions(CountOpenWorkflowExecutionsRequest countOpenWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<CountOpenWorkflowExecutionsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(countOpenWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new CountOpenWorkflowExecutionsRequestMarshaller().marshall(countOpenWorkflowExecutionsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        WorkflowExecutionCountJsonUnmarshaller unmarshaller = new WorkflowExecutionCountJsonUnmarshaller();
        JsonResponseHandler<WorkflowExecutionCount> responseHandler = new JsonResponseHandler<WorkflowExecutionCount>(unmarshaller);
        return (WorkflowExecutionCount)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityTypeDetail describeActivityType(DescribeActivityTypeRequest describeActivityTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeActivityTypeRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeActivityTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeActivityTypeRequestMarshaller().marshall(describeActivityTypeRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ActivityTypeDetailJsonUnmarshaller unmarshaller = new ActivityTypeDetailJsonUnmarshaller();
        JsonResponseHandler<ActivityTypeDetail> responseHandler = new JsonResponseHandler<ActivityTypeDetail>(unmarshaller);
        return (ActivityTypeDetail)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowExecutionInfos listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListOpenWorkflowExecutionsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(listOpenWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ListOpenWorkflowExecutionsRequestMarshaller().marshall(listOpenWorkflowExecutionsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        WorkflowExecutionInfosJsonUnmarshaller unmarshaller = new WorkflowExecutionInfosJsonUnmarshaller();
        JsonResponseHandler<WorkflowExecutionInfos> responseHandler = new JsonResponseHandler<WorkflowExecutionInfos>(unmarshaller);
        return (WorkflowExecutionInfos)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public History getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetWorkflowExecutionHistoryRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(getWorkflowExecutionHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new GetWorkflowExecutionHistoryRequestMarshaller().marshall(getWorkflowExecutionHistoryRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        HistoryJsonUnmarshaller unmarshaller = new HistoryJsonUnmarshaller();
        JsonResponseHandler<History> responseHandler = new JsonResponseHandler<History>(unmarshaller);
        return (History)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDomain(RegisterDomainRequest registerDomainRequest) throws AmazonServiceException, AmazonClientException {
        Request<RegisterDomainRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(registerDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RegisterDomainRequestMarshaller().marshall(registerDomainRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerActivityType(RegisterActivityTypeRequest registerActivityTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<RegisterActivityTypeRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(registerActivityTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RegisterActivityTypeRequestMarshaller().marshall(registerActivityTypeRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowExecutionInfos listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListClosedWorkflowExecutionsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(listClosedWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ListClosedWorkflowExecutionsRequestMarshaller().marshall(listClosedWorkflowExecutionsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        WorkflowExecutionInfosJsonUnmarshaller unmarshaller = new WorkflowExecutionInfosJsonUnmarshaller();
        JsonResponseHandler<WorkflowExecutionInfos> responseHandler = new JsonResponseHandler<WorkflowExecutionInfos>(unmarshaller);
        return (WorkflowExecutionInfos)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityTaskStatus recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest) throws AmazonServiceException, AmazonClientException {
        Request<RecordActivityTaskHeartbeatRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(recordActivityTaskHeartbeatRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RecordActivityTaskHeartbeatRequestMarshaller().marshall(recordActivityTaskHeartbeatRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ActivityTaskStatusJsonUnmarshaller unmarshaller = new ActivityTaskStatusJsonUnmarshaller();
        JsonResponseHandler<ActivityTaskStatus> responseHandler = new JsonResponseHandler<ActivityTaskStatus>(unmarshaller);
        return (ActivityTaskStatus)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecisionTask pollForDecisionTask(PollForDecisionTaskRequest pollForDecisionTaskRequest) throws AmazonServiceException, AmazonClientException {
        Request<PollForDecisionTaskRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(pollForDecisionTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new PollForDecisionTaskRequestMarshaller().marshall(pollForDecisionTaskRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DecisionTaskJsonUnmarshaller unmarshaller = new DecisionTaskJsonUnmarshaller();
        JsonResponseHandler<DecisionTask> responseHandler = new JsonResponseHandler<DecisionTask>(unmarshaller);
        return (DecisionTask)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityTypeInfos listActivityTypes(ListActivityTypesRequest listActivityTypesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListActivityTypesRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(listActivityTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ListActivityTypesRequestMarshaller().marshall(listActivityTypesRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ActivityTypeInfosJsonUnmarshaller unmarshaller = new ActivityTypeInfosJsonUnmarshaller();
        JsonResponseHandler<ActivityTypeInfos> responseHandler = new JsonResponseHandler<ActivityTypeInfos>(unmarshaller);
        return (ActivityTypeInfos)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomainDetail describeDomain(DescribeDomainRequest describeDomainRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDomainRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeDomainRequestMarshaller().marshall(describeDomainRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DomainDetailJsonUnmarshaller unmarshaller = new DomainDetailJsonUnmarshaller();
        JsonResponseHandler<DomainDetail> responseHandler = new JsonResponseHandler<DomainDetail>(unmarshaller);
        return (DomainDetail)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void respondActivityTaskFailed(RespondActivityTaskFailedRequest respondActivityTaskFailedRequest) throws AmazonServiceException, AmazonClientException {
        Request<RespondActivityTaskFailedRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(respondActivityTaskFailedRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RespondActivityTaskFailedRequestMarshaller().marshall(respondActivityTaskFailedRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingTaskCount countPendingDecisionTasks(CountPendingDecisionTasksRequest countPendingDecisionTasksRequest) throws AmazonServiceException, AmazonClientException {
        Request<CountPendingDecisionTasksRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(countPendingDecisionTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new CountPendingDecisionTasksRequestMarshaller().marshall(countPendingDecisionTasksRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        PendingTaskCountJsonUnmarshaller unmarshaller = new PendingTaskCountJsonUnmarshaller();
        JsonResponseHandler<PendingTaskCount> responseHandler = new JsonResponseHandler<PendingTaskCount>(unmarshaller);
        return (PendingTaskCount)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        Request<TerminateWorkflowExecutionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(terminateWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new TerminateWorkflowExecutionRequestMarshaller().marshall(terminateWorkflowExecutionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowExecutionDetail describeWorkflowExecution(DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeWorkflowExecutionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeWorkflowExecutionRequestMarshaller().marshall(describeWorkflowExecutionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        WorkflowExecutionDetailJsonUnmarshaller unmarshaller = new WorkflowExecutionDetailJsonUnmarshaller();
        JsonResponseHandler<WorkflowExecutionDetail> responseHandler = new JsonResponseHandler<WorkflowExecutionDetail>(unmarshaller);
        return (WorkflowExecutionDetail)this.invoke(request, responseHandler, executionContext);
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "swf";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) throws AmazonClientException {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.log();
        return (X)result;
    }
}

