/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest;
import com.amazonaws.services.cloudwatch.model.transform.DeleteAlarmsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmHistoryRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmHistoryResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsForMetricRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsForMetricResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DisableAlarmActionsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.EnableAlarmActionsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.GetMetricStatisticsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.GetMetricStatisticsResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InvalidFormatExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InvalidParameterCombinationExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.ListMetricsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.ListMetricsResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.MissingRequiredParameterExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.PutMetricAlarmRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.PutMetricDataRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.SetAlarmStateRequestMarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudWatchClient
extends AmazonWebServiceClient
implements AmazonCloudWatch {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS4Signer signer;

    public AmazonCloudWatchClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCloudWatchClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCloudWatchClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCloudWatchClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCloudWatchClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCloudWatchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterCombinationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidFormatExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServiceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingRequiredParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("monitoring.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("monitoring");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudwatch/request.handlers"));
    }

    @Override
    public void putMetricAlarm(PutMetricAlarmRequest putMetricAlarmRequest) throws AmazonServiceException, AmazonClientException {
        Request<PutMetricAlarmRequest> request = new PutMetricAlarmRequestMarshaller().marshall(putMetricAlarmRequest);
        this.invoke(request, null);
    }

    @Override
    public void putMetricData(PutMetricDataRequest putMetricDataRequest) throws AmazonServiceException, AmazonClientException {
        Request<PutMetricDataRequest> request = new PutMetricDataRequestMarshaller().marshall(putMetricDataRequest);
        this.invoke(request, null);
    }

    @Override
    public ListMetricsResult listMetrics(ListMetricsRequest listMetricsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListMetricsRequest> request = new ListMetricsRequestMarshaller().marshall(listMetricsRequest);
        return this.invoke(request, new ListMetricsResultStaxUnmarshaller());
    }

    @Override
    public GetMetricStatisticsResult getMetricStatistics(GetMetricStatisticsRequest getMetricStatisticsRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetMetricStatisticsRequest> request = new GetMetricStatisticsRequestMarshaller().marshall(getMetricStatisticsRequest);
        return this.invoke(request, new GetMetricStatisticsResultStaxUnmarshaller());
    }

    @Override
    public void disableAlarmActions(DisableAlarmActionsRequest disableAlarmActionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DisableAlarmActionsRequest> request = new DisableAlarmActionsRequestMarshaller().marshall(disableAlarmActionsRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeAlarmsResult describeAlarms(DescribeAlarmsRequest describeAlarmsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeAlarmsRequest> request = new DescribeAlarmsRequestMarshaller().marshall(describeAlarmsRequest);
        return this.invoke(request, new DescribeAlarmsResultStaxUnmarshaller());
    }

    @Override
    public DescribeAlarmsForMetricResult describeAlarmsForMetric(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeAlarmsForMetricRequest> request = new DescribeAlarmsForMetricRequestMarshaller().marshall(describeAlarmsForMetricRequest);
        return this.invoke(request, new DescribeAlarmsForMetricResultStaxUnmarshaller());
    }

    @Override
    public DescribeAlarmHistoryResult describeAlarmHistory(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeAlarmHistoryRequest> request = new DescribeAlarmHistoryRequestMarshaller().marshall(describeAlarmHistoryRequest);
        return this.invoke(request, new DescribeAlarmHistoryResultStaxUnmarshaller());
    }

    @Override
    public void enableAlarmActions(EnableAlarmActionsRequest enableAlarmActionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<EnableAlarmActionsRequest> request = new EnableAlarmActionsRequestMarshaller().marshall(enableAlarmActionsRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteAlarms(DeleteAlarmsRequest deleteAlarmsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteAlarmsRequest> request = new DeleteAlarmsRequestMarshaller().marshall(deleteAlarmsRequest);
        this.invoke(request, null);
    }

    @Override
    public void setAlarmState(SetAlarmStateRequest setAlarmStateRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetAlarmStateRequest> request = new SetAlarmStateRequestMarshaller().marshall(setAlarmStateRequest);
        this.invoke(request, null);
    }

    @Override
    public ListMetricsResult listMetrics() throws AmazonServiceException, AmazonClientException {
        return this.listMetrics(new ListMetricsRequest());
    }

    @Override
    public DescribeAlarmsResult describeAlarms() throws AmazonServiceException, AmazonClientException {
        return this.describeAlarms(new DescribeAlarmsRequest());
    }

    @Override
    public DescribeAlarmHistoryResult describeAlarmHistory() throws AmazonServiceException, AmazonClientException {
        return this.describeAlarmHistory(new DescribeAlarmHistoryRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "monitoring";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext(originalRequest);
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

