/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;

public class EnvironmentVariableCredentialsProvider
implements AWSCredentialsProvider {
    private static final String ACCESS_KEY_ENV_VAR = "AWS_ACCESS_KEY_ID";
    private static final String ALTERNATE_ACCESS_KEY_ENV_VAR = "AWS_ACCESS_KEY";
    private static final String SECRET_KEY_ENV_VAR = "AWS_SECRET_KEY";
    private static final String ALTERNATE_SECRET_KEY_ENV_VAR = "AWS_SECRET_ACCESS_KEY";

    public AWSCredentials getCredentials() {
        String secretKey;
        String accessKey = System.getenv(ACCESS_KEY_ENV_VAR);
        if (accessKey == null) {
            accessKey = System.getenv(ALTERNATE_ACCESS_KEY_ENV_VAR);
        }
        if ((secretKey = System.getenv(SECRET_KEY_ENV_VAR)) == null) {
            secretKey = System.getenv(ALTERNATE_SECRET_KEY_ENV_VAR);
        }
        if (accessKey != null && secretKey != null) {
            return new BasicAWSCredentials(accessKey, secretKey);
        }
        throw new AmazonClientException("Unable to load AWS credentials from environment variables (AWS_ACCESS_KEY_ID (or AWS_ACCESS_KEY) and AWS_SECRET_KEY (or AWS_SECRET_ACCESS_KEY))");
    }

    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

