/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elastictranscoder.model.Notifications;
import com.amazonaws.services.elastictranscoder.model.Permission;
import com.amazonaws.services.elastictranscoder.model.PipelineOutputConfig;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatePipelineRequestMarshaller
implements Marshaller<Request<UpdatePipelineRequest>, UpdatePipelineRequest> {
    @Override
    public Request<UpdatePipelineRequest> marshall(UpdatePipelineRequest updatePipelineRequest) {
        if (updatePipelineRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdatePipelineRequest> request = new DefaultRequest<UpdatePipelineRequest>(updatePipelineRequest, "AmazonElasticTranscoder");
        String target = "EtsCustomerService.UpdatePipeline";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "2012-09-25/pipelines/{Id}";
        uriResourcePath = uriResourcePath.replace("{Id}", updatePipelineRequest.getId() == null ? "" : StringUtils.fromString(updatePipelineRequest.getId()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            PipelineOutputConfig thumbnailConfig;
            PipelineOutputConfig contentConfig;
            Notifications notifications;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updatePipelineRequest.getName() != null) {
                jsonWriter.key("Name").value(updatePipelineRequest.getName());
            }
            if (updatePipelineRequest.getInputBucket() != null) {
                jsonWriter.key("InputBucket").value(updatePipelineRequest.getInputBucket());
            }
            if (updatePipelineRequest.getRole() != null) {
                jsonWriter.key("Role").value(updatePipelineRequest.getRole());
            }
            if ((notifications = updatePipelineRequest.getNotifications()) != null) {
                jsonWriter.key("Notifications");
                jsonWriter.object();
                if (notifications.getProgressing() != null) {
                    jsonWriter.key("Progressing").value(notifications.getProgressing());
                }
                if (notifications.getCompleted() != null) {
                    jsonWriter.key("Completed").value(notifications.getCompleted());
                }
                if (notifications.getWarning() != null) {
                    jsonWriter.key("Warning").value(notifications.getWarning());
                }
                if (notifications.getError() != null) {
                    jsonWriter.key("Error").value(notifications.getError());
                }
                jsonWriter.endObject();
            }
            if ((contentConfig = updatePipelineRequest.getContentConfig()) != null) {
                ListWithAutoConstructFlag permissionsList;
                jsonWriter.key("ContentConfig");
                jsonWriter.object();
                if (contentConfig.getBucket() != null) {
                    jsonWriter.key("Bucket").value(contentConfig.getBucket());
                }
                if (contentConfig.getStorageClass() != null) {
                    jsonWriter.key("StorageClass").value(contentConfig.getStorageClass());
                }
                if (!((permissionsList = (ListWithAutoConstructFlag)contentConfig.getPermissions()) == null || permissionsList.isAutoConstruct() && permissionsList.isEmpty())) {
                    jsonWriter.key("Permissions");
                    jsonWriter.array();
                    for (Permission permissionsListValue : permissionsList) {
                        ListWithAutoConstructFlag accessList;
                        if (permissionsListValue == null) continue;
                        jsonWriter.object();
                        if (permissionsListValue.getGranteeType() != null) {
                            jsonWriter.key("GranteeType").value(permissionsListValue.getGranteeType());
                        }
                        if (permissionsListValue.getGrantee() != null) {
                            jsonWriter.key("Grantee").value(permissionsListValue.getGrantee());
                        }
                        if (!((accessList = (ListWithAutoConstructFlag)permissionsListValue.getAccess()) == null || accessList.isAutoConstruct() && accessList.isEmpty())) {
                            jsonWriter.key("Access");
                            jsonWriter.array();
                            for (String accessListValue : accessList) {
                                if (accessListValue == null) continue;
                                jsonWriter.value(accessListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if ((thumbnailConfig = updatePipelineRequest.getThumbnailConfig()) != null) {
                ListWithAutoConstructFlag permissionsList;
                jsonWriter.key("ThumbnailConfig");
                jsonWriter.object();
                if (thumbnailConfig.getBucket() != null) {
                    jsonWriter.key("Bucket").value(thumbnailConfig.getBucket());
                }
                if (thumbnailConfig.getStorageClass() != null) {
                    jsonWriter.key("StorageClass").value(thumbnailConfig.getStorageClass());
                }
                if (!((permissionsList = (ListWithAutoConstructFlag)thumbnailConfig.getPermissions()) == null || permissionsList.isAutoConstruct() && permissionsList.isEmpty())) {
                    jsonWriter.key("Permissions");
                    jsonWriter.array();
                    for (Permission permissionsListValue : permissionsList) {
                        ListWithAutoConstructFlag accessList;
                        if (permissionsListValue == null) continue;
                        jsonWriter.object();
                        if (permissionsListValue.getGranteeType() != null) {
                            jsonWriter.key("GranteeType").value(permissionsListValue.getGranteeType());
                        }
                        if (permissionsListValue.getGrantee() != null) {
                            jsonWriter.key("Grantee").value(permissionsListValue.getGrantee());
                        }
                        if (!((accessList = (ListWithAutoConstructFlag)permissionsListValue.getAccess()) == null || accessList.isAutoConstruct() && accessList.isEmpty())) {
                            jsonWriter.key("Access");
                            jsonWriter.array();
                            for (String accessListValue : accessList) {
                                if (accessListValue == null) continue;
                                jsonWriter.value(accessListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

