/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.regions.Region;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionMetadataParser {
    private static final String REGION_TAG = "Region";
    private static final String REGION_ID_TAG = "Name";
    private static final String DOMAIN_TAG = "Domain";
    private static final String ENDPOINT_TAG = "Endpoint";
    private static final String SERVICE_TAG = "ServiceName";
    private static final String HTTP_TAG = "Http";
    private static final String HTTPS_TAG = "Https";
    private static final String HOSTNAME_TAG = "Hostname";

    public List<Region> parseRegionMetadata(InputStream input) throws IOException {
        return this.parseRegionMetadata(input, false);
    }

    public List<Region> parseRegionMetadata(InputStream input, boolean endpointVerification) throws IOException {
        Document document;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            document = documentBuilder.parse(input);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse region metadata file: " + e.getMessage(), e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException exception) {}
        }
        NodeList regionNodes = document.getElementsByTagName(REGION_TAG);
        ArrayList<Region> regions = new ArrayList<Region>();
        for (int i = 0; i < regionNodes.getLength(); ++i) {
            Node node = regionNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            regions.add(this.parseRegionElement(element, endpointVerification));
        }
        return regions;
    }

    private Region parseRegionElement(Element regionElement, boolean endpointVerification) {
        String name = RegionMetadataParser.getChildElementValue(REGION_ID_TAG, regionElement);
        String domain = RegionMetadataParser.getChildElementValue(DOMAIN_TAG, regionElement);
        Region region = new Region(name, domain);
        NodeList endpointNodes = regionElement.getElementsByTagName(ENDPOINT_TAG);
        for (int i = 0; i < endpointNodes.getLength(); ++i) {
            this.addRegionEndpoint(region, (Element)endpointNodes.item(i), endpointVerification);
        }
        return region;
    }

    private void addRegionEndpoint(Region region, Element endpointElement, boolean endpointVerification) {
        String serviceName = RegionMetadataParser.getChildElementValue(SERVICE_TAG, endpointElement);
        String hostname = RegionMetadataParser.getChildElementValue(HOSTNAME_TAG, endpointElement);
        String http = RegionMetadataParser.getChildElementValue(HTTP_TAG, endpointElement);
        String https = RegionMetadataParser.getChildElementValue(HTTPS_TAG, endpointElement);
        if (endpointVerification && !RegionMetadataParser.verifyEndpoint(hostname)) {
            throw new RuntimeException("Invalid service endpoint (" + hostname + ") is detected.");
        }
        region.getServiceEndpoints().put(serviceName, hostname);
        region.getHttpSupport().put(serviceName, "true".equals(http));
        region.getHttpsSupport().put(serviceName, "true".equals(https));
    }

    private static String getChildElementValue(String tagName, Element element) {
        Node tagNode = element.getElementsByTagName(tagName).item(0);
        if (tagNode == null) {
            return null;
        }
        NodeList nodes = tagNode.getChildNodes();
        Node node = nodes.item(0);
        return node.getNodeValue();
    }

    private static boolean verifyEndpoint(String endpoint) {
        return endpoint.endsWith(".amazonaws.com");
    }
}

