/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sns.AmazonSNSAsync;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.AddPermissionRequest;
import com.amazonaws.services.sns.model.ConfirmSubscriptionRequest;
import com.amazonaws.services.sns.model.ConfirmSubscriptionResult;
import com.amazonaws.services.sns.model.CreatePlatformApplicationRequest;
import com.amazonaws.services.sns.model.CreatePlatformApplicationResult;
import com.amazonaws.services.sns.model.CreatePlatformEndpointRequest;
import com.amazonaws.services.sns.model.CreatePlatformEndpointResult;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.DeleteEndpointRequest;
import com.amazonaws.services.sns.model.DeletePlatformApplicationRequest;
import com.amazonaws.services.sns.model.DeleteTopicRequest;
import com.amazonaws.services.sns.model.GetEndpointAttributesRequest;
import com.amazonaws.services.sns.model.GetEndpointAttributesResult;
import com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest;
import com.amazonaws.services.sns.model.GetPlatformApplicationAttributesResult;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesResult;
import com.amazonaws.services.sns.model.GetTopicAttributesRequest;
import com.amazonaws.services.sns.model.GetTopicAttributesResult;
import com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationResult;
import com.amazonaws.services.sns.model.ListPlatformApplicationsRequest;
import com.amazonaws.services.sns.model.ListPlatformApplicationsResult;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicResult;
import com.amazonaws.services.sns.model.ListSubscriptionsRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsResult;
import com.amazonaws.services.sns.model.ListTopicsRequest;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import com.amazonaws.services.sns.model.RemovePermissionRequest;
import com.amazonaws.services.sns.model.SetEndpointAttributesRequest;
import com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest;
import com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sns.model.SubscribeResult;
import com.amazonaws.services.sns.model.UnsubscribeRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSNSAsyncClient
extends AmazonSNSClient
implements AmazonSNSAsync {
    private ExecutorService executorService;

    public AmazonSNSAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonSNSAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonSNSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonSNSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonSNSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(final ConfirmSubscriptionRequest confirmSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfirmSubscriptionResult>(){

            @Override
            public ConfirmSubscriptionResult call() throws Exception {
                return AmazonSNSAsyncClient.this.confirmSubscription(confirmSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(final ConfirmSubscriptionRequest confirmSubscriptionRequest, final AsyncHandler<ConfirmSubscriptionRequest, ConfirmSubscriptionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfirmSubscriptionResult>(){

            @Override
            public ConfirmSubscriptionResult call() throws Exception {
                ConfirmSubscriptionResult result;
                try {
                    result = AmazonSNSAsyncClient.this.confirmSubscription(confirmSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(confirmSubscriptionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreatePlatformApplicationResult> createPlatformApplicationAsync(final CreatePlatformApplicationRequest createPlatformApplicationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePlatformApplicationResult>(){

            @Override
            public CreatePlatformApplicationResult call() throws Exception {
                return AmazonSNSAsyncClient.this.createPlatformApplication(createPlatformApplicationRequest);
            }
        });
    }

    @Override
    public Future<CreatePlatformApplicationResult> createPlatformApplicationAsync(final CreatePlatformApplicationRequest createPlatformApplicationRequest, final AsyncHandler<CreatePlatformApplicationRequest, CreatePlatformApplicationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePlatformApplicationResult>(){

            @Override
            public CreatePlatformApplicationResult call() throws Exception {
                CreatePlatformApplicationResult result;
                try {
                    result = AmazonSNSAsyncClient.this.createPlatformApplication(createPlatformApplicationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createPlatformApplicationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetTopicAttributesResult> getTopicAttributesAsync(final GetTopicAttributesRequest getTopicAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTopicAttributesResult>(){

            @Override
            public GetTopicAttributesResult call() throws Exception {
                return AmazonSNSAsyncClient.this.getTopicAttributes(getTopicAttributesRequest);
            }
        });
    }

    @Override
    public Future<GetTopicAttributesResult> getTopicAttributesAsync(final GetTopicAttributesRequest getTopicAttributesRequest, final AsyncHandler<GetTopicAttributesRequest, GetTopicAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTopicAttributesResult>(){

            @Override
            public GetTopicAttributesResult call() throws Exception {
                GetTopicAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.getTopicAttributes(getTopicAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getTopicAttributesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(final SubscribeRequest subscribeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SubscribeResult>(){

            @Override
            public SubscribeResult call() throws Exception {
                return AmazonSNSAsyncClient.this.subscribe(subscribeRequest);
            }
        });
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(final SubscribeRequest subscribeRequest, final AsyncHandler<SubscribeRequest, SubscribeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SubscribeResult>(){

            @Override
            public SubscribeResult call() throws Exception {
                SubscribeResult result;
                try {
                    result = AmazonSNSAsyncClient.this.subscribe(subscribeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(subscribeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteEndpointAsync(final DeleteEndpointRequest deleteEndpointRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSNSAsyncClient.this.deleteEndpoint(deleteEndpointRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteEndpointAsync(final DeleteEndpointRequest deleteEndpointRequest, final AsyncHandler<DeleteEndpointRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSNSAsyncClient.this.deleteEndpoint(deleteEndpointRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteEndpointRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setTopicAttributesAsync(final SetTopicAttributesRequest setTopicAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSNSAsyncClient.this.setTopicAttributes(setTopicAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setTopicAttributesAsync(final SetTopicAttributesRequest setTopicAttributesRequest, final AsyncHandler<SetTopicAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSNSAsyncClient.this.setTopicAttributes(setTopicAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setTopicAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteTopicAsync(final DeleteTopicRequest deleteTopicRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSNSAsyncClient.this.deleteTopic(deleteTopicRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteTopicAsync(final DeleteTopicRequest deleteTopicRequest, final AsyncHandler<DeleteTopicRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSNSAsyncClient.this.deleteTopic(deleteTopicRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteTopicRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> removePermissionAsync(final RemovePermissionRequest removePermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSNSAsyncClient.this.removePermission(removePermissionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> removePermissionAsync(final RemovePermissionRequest removePermissionRequest, final AsyncHandler<RemovePermissionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSNSAsyncClient.this.removePermission(removePermissionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(removePermissionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetEndpointAttributesResult> getEndpointAttributesAsync(final GetEndpointAttributesRequest getEndpointAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetEndpointAttributesResult>(){

            @Override
            public GetEndpointAttributesResult call() throws Exception {
                return AmazonSNSAsyncClient.this.getEndpointAttributes(getEndpointAttributesRequest);
            }
        });
    }

    @Override
    public Future<GetEndpointAttributesResult> getEndpointAttributesAsync(final GetEndpointAttributesRequest getEndpointAttributesRequest, final AsyncHandler<GetEndpointAttributesRequest, GetEndpointAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetEndpointAttributesResult>(){

            @Override
            public GetEndpointAttributesResult call() throws Exception {
                GetEndpointAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.getEndpointAttributes(getEndpointAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getEndpointAttributesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetPlatformApplicationAttributesResult> getPlatformApplicationAttributesAsync(final GetPlatformApplicationAttributesRequest getPlatformApplicationAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetPlatformApplicationAttributesResult>(){

            @Override
            public GetPlatformApplicationAttributesResult call() throws Exception {
                return AmazonSNSAsyncClient.this.getPlatformApplicationAttributes(getPlatformApplicationAttributesRequest);
            }
        });
    }

    @Override
    public Future<GetPlatformApplicationAttributesResult> getPlatformApplicationAttributesAsync(final GetPlatformApplicationAttributesRequest getPlatformApplicationAttributesRequest, final AsyncHandler<GetPlatformApplicationAttributesRequest, GetPlatformApplicationAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetPlatformApplicationAttributesResult>(){

            @Override
            public GetPlatformApplicationAttributesResult call() throws Exception {
                GetPlatformApplicationAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.getPlatformApplicationAttributes(getPlatformApplicationAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getPlatformApplicationAttributesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(final ListSubscriptionsRequest listSubscriptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListSubscriptionsResult>(){

            @Override
            public ListSubscriptionsResult call() throws Exception {
                return AmazonSNSAsyncClient.this.listSubscriptions(listSubscriptionsRequest);
            }
        });
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(final ListSubscriptionsRequest listSubscriptionsRequest, final AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListSubscriptionsResult>(){

            @Override
            public ListSubscriptionsResult call() throws Exception {
                ListSubscriptionsResult result;
                try {
                    result = AmazonSNSAsyncClient.this.listSubscriptions(listSubscriptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listSubscriptionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> setSubscriptionAttributesAsync(final SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSNSAsyncClient.this.setSubscriptionAttributes(setSubscriptionAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setSubscriptionAttributesAsync(final SetSubscriptionAttributesRequest setSubscriptionAttributesRequest, final AsyncHandler<SetSubscriptionAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSNSAsyncClient.this.setSubscriptionAttributes(setSubscriptionAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setSubscriptionAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setPlatformApplicationAttributesAsync(final SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSNSAsyncClient.this.setPlatformApplicationAttributes(setPlatformApplicationAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setPlatformApplicationAttributesAsync(final SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest, final AsyncHandler<SetPlatformApplicationAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSNSAsyncClient.this.setPlatformApplicationAttributes(setPlatformApplicationAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setPlatformApplicationAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreatePlatformEndpointResult> createPlatformEndpointAsync(final CreatePlatformEndpointRequest createPlatformEndpointRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePlatformEndpointResult>(){

            @Override
            public CreatePlatformEndpointResult call() throws Exception {
                return AmazonSNSAsyncClient.this.createPlatformEndpoint(createPlatformEndpointRequest);
            }
        });
    }

    @Override
    public Future<CreatePlatformEndpointResult> createPlatformEndpointAsync(final CreatePlatformEndpointRequest createPlatformEndpointRequest, final AsyncHandler<CreatePlatformEndpointRequest, CreatePlatformEndpointResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePlatformEndpointResult>(){

            @Override
            public CreatePlatformEndpointResult call() throws Exception {
                CreatePlatformEndpointResult result;
                try {
                    result = AmazonSNSAsyncClient.this.createPlatformEndpoint(createPlatformEndpointRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createPlatformEndpointRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> addPermissionAsync(final AddPermissionRequest addPermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSNSAsyncClient.this.addPermission(addPermissionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> addPermissionAsync(final AddPermissionRequest addPermissionRequest, final AsyncHandler<AddPermissionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSNSAsyncClient.this.addPermission(addPermissionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(addPermissionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetSubscriptionAttributesResult> getSubscriptionAttributesAsync(final GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSubscriptionAttributesResult>(){

            @Override
            public GetSubscriptionAttributesResult call() throws Exception {
                return AmazonSNSAsyncClient.this.getSubscriptionAttributes(getSubscriptionAttributesRequest);
            }
        });
    }

    @Override
    public Future<GetSubscriptionAttributesResult> getSubscriptionAttributesAsync(final GetSubscriptionAttributesRequest getSubscriptionAttributesRequest, final AsyncHandler<GetSubscriptionAttributesRequest, GetSubscriptionAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSubscriptionAttributesResult>(){

            @Override
            public GetSubscriptionAttributesResult call() throws Exception {
                GetSubscriptionAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.getSubscriptionAttributes(getSubscriptionAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getSubscriptionAttributesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateTopicResult> createTopicAsync(final CreateTopicRequest createTopicRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTopicResult>(){

            @Override
            public CreateTopicResult call() throws Exception {
                return AmazonSNSAsyncClient.this.createTopic(createTopicRequest);
            }
        });
    }

    @Override
    public Future<CreateTopicResult> createTopicAsync(final CreateTopicRequest createTopicRequest, final AsyncHandler<CreateTopicRequest, CreateTopicResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTopicResult>(){

            @Override
            public CreateTopicResult call() throws Exception {
                CreateTopicResult result;
                try {
                    result = AmazonSNSAsyncClient.this.createTopic(createTopicRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createTopicRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(final ListTopicsRequest listTopicsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTopicsResult>(){

            @Override
            public ListTopicsResult call() throws Exception {
                return AmazonSNSAsyncClient.this.listTopics(listTopicsRequest);
            }
        });
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(final ListTopicsRequest listTopicsRequest, final AsyncHandler<ListTopicsRequest, ListTopicsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTopicsResult>(){

            @Override
            public ListTopicsResult call() throws Exception {
                ListTopicsResult result;
                try {
                    result = AmazonSNSAsyncClient.this.listTopics(listTopicsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listTopicsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListEndpointsByPlatformApplicationResult> listEndpointsByPlatformApplicationAsync(final ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListEndpointsByPlatformApplicationResult>(){

            @Override
            public ListEndpointsByPlatformApplicationResult call() throws Exception {
                return AmazonSNSAsyncClient.this.listEndpointsByPlatformApplication(listEndpointsByPlatformApplicationRequest);
            }
        });
    }

    @Override
    public Future<ListEndpointsByPlatformApplicationResult> listEndpointsByPlatformApplicationAsync(final ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest, final AsyncHandler<ListEndpointsByPlatformApplicationRequest, ListEndpointsByPlatformApplicationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListEndpointsByPlatformApplicationResult>(){

            @Override
            public ListEndpointsByPlatformApplicationResult call() throws Exception {
                ListEndpointsByPlatformApplicationResult result;
                try {
                    result = AmazonSNSAsyncClient.this.listEndpointsByPlatformApplication(listEndpointsByPlatformApplicationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listEndpointsByPlatformApplicationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deletePlatformApplicationAsync(final DeletePlatformApplicationRequest deletePlatformApplicationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSNSAsyncClient.this.deletePlatformApplication(deletePlatformApplicationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deletePlatformApplicationAsync(final DeletePlatformApplicationRequest deletePlatformApplicationRequest, final AsyncHandler<DeletePlatformApplicationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSNSAsyncClient.this.deletePlatformApplication(deletePlatformApplicationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deletePlatformApplicationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListPlatformApplicationsResult> listPlatformApplicationsAsync(final ListPlatformApplicationsRequest listPlatformApplicationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListPlatformApplicationsResult>(){

            @Override
            public ListPlatformApplicationsResult call() throws Exception {
                return AmazonSNSAsyncClient.this.listPlatformApplications(listPlatformApplicationsRequest);
            }
        });
    }

    @Override
    public Future<ListPlatformApplicationsResult> listPlatformApplicationsAsync(final ListPlatformApplicationsRequest listPlatformApplicationsRequest, final AsyncHandler<ListPlatformApplicationsRequest, ListPlatformApplicationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListPlatformApplicationsResult>(){

            @Override
            public ListPlatformApplicationsResult call() throws Exception {
                ListPlatformApplicationsResult result;
                try {
                    result = AmazonSNSAsyncClient.this.listPlatformApplications(listPlatformApplicationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listPlatformApplicationsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> setEndpointAttributesAsync(final SetEndpointAttributesRequest setEndpointAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSNSAsyncClient.this.setEndpointAttributes(setEndpointAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setEndpointAttributesAsync(final SetEndpointAttributesRequest setEndpointAttributesRequest, final AsyncHandler<SetEndpointAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSNSAsyncClient.this.setEndpointAttributes(setEndpointAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setEndpointAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> unsubscribeAsync(final UnsubscribeRequest unsubscribeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSNSAsyncClient.this.unsubscribe(unsubscribeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> unsubscribeAsync(final UnsubscribeRequest unsubscribeRequest, final AsyncHandler<UnsubscribeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSNSAsyncClient.this.unsubscribe(unsubscribeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(unsubscribeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(final ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListSubscriptionsByTopicResult>(){

            @Override
            public ListSubscriptionsByTopicResult call() throws Exception {
                return AmazonSNSAsyncClient.this.listSubscriptionsByTopic(listSubscriptionsByTopicRequest);
            }
        });
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(final ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest, final AsyncHandler<ListSubscriptionsByTopicRequest, ListSubscriptionsByTopicResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListSubscriptionsByTopicResult>(){

            @Override
            public ListSubscriptionsByTopicResult call() throws Exception {
                ListSubscriptionsByTopicResult result;
                try {
                    result = AmazonSNSAsyncClient.this.listSubscriptionsByTopic(listSubscriptionsByTopicRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listSubscriptionsByTopicRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<PublishResult> publishAsync(final PublishRequest publishRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PublishResult>(){

            @Override
            public PublishResult call() throws Exception {
                return AmazonSNSAsyncClient.this.publish(publishRequest);
            }
        });
    }

    @Override
    public Future<PublishResult> publishAsync(final PublishRequest publishRequest, final AsyncHandler<PublishRequest, PublishResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PublishResult>(){

            @Override
            public PublishResult call() throws Exception {
                PublishResult result;
                try {
                    result = AmazonSNSAsyncClient.this.publish(publishRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(publishRequest, result);
                return result;
            }
        });
    }
}

