/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachLoadBalancerToSubnetsResult
implements Serializable {
    private ListWithAutoConstructFlag<String> subnets;

    public List<String> getSubnets() {
        if (this.subnets == null) {
            this.subnets = new ListWithAutoConstructFlag();
            this.subnets.setAutoConstruct(true);
        }
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        ListWithAutoConstructFlag subnetsCopy = new ListWithAutoConstructFlag(subnets.size());
        subnetsCopy.addAll(subnets);
        this.subnets = subnetsCopy;
    }

    public AttachLoadBalancerToSubnetsResult withSubnets(String ... subnets) {
        if (this.getSubnets() == null) {
            this.setSubnets(new ArrayList<String>(subnets.length));
        }
        for (String value : subnets) {
            this.getSubnets().add(value);
        }
        return this;
    }

    public AttachLoadBalancerToSubnetsResult withSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
        } else {
            ListWithAutoConstructFlag subnetsCopy = new ListWithAutoConstructFlag(subnets.size());
            subnetsCopy.addAll(subnets);
            this.subnets = subnetsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubnets() != null) {
            sb.append("Subnets: " + this.getSubnets());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : ((Object)this.getSubnets()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachLoadBalancerToSubnetsResult)) {
            return false;
        }
        AttachLoadBalancerToSubnetsResult other = (AttachLoadBalancerToSubnetsResult)obj;
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        return other.getSubnets() == null || ((Object)other.getSubnets()).equals(this.getSubnets());
    }
}

