/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.OperatorType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operator
implements Serializable {
    private String type;
    private ListWithAutoConstructFlag<String> values;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Operator withType(String type) {
        this.type = type;
        return this;
    }

    public void setType(OperatorType type) {
        this.type = type.toString();
    }

    public Operator withType(OperatorType type) {
        this.type = type.toString();
        return this;
    }

    public List<String> getValues() {
        if (this.values == null) {
            this.values = new ListWithAutoConstructFlag();
            this.values.setAutoConstruct(true);
        }
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        ListWithAutoConstructFlag valuesCopy = new ListWithAutoConstructFlag(values.size());
        valuesCopy.addAll(values);
        this.values = valuesCopy;
    }

    public Operator withValues(String ... values) {
        if (this.getValues() == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String value : values) {
            this.getValues().add(value);
        }
        return this;
    }

    public Operator withValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
        } else {
            ListWithAutoConstructFlag valuesCopy = new ListWithAutoConstructFlag(values.size());
            valuesCopy.addAll(values);
            this.values = valuesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getValues() != null) {
            sb.append("Values: " + this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : ((Object)this.getValues()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operator)) {
            return false;
        }
        Operator other = (Operator)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || ((Object)other.getValues()).equals(this.getValues());
    }
}

