/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticbeanstalk.model.SolutionStackDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAvailableSolutionStacksResult
implements Serializable {
    private ListWithAutoConstructFlag<String> solutionStacks;
    private ListWithAutoConstructFlag<SolutionStackDescription> solutionStackDetails;

    public List<String> getSolutionStacks() {
        if (this.solutionStacks == null) {
            this.solutionStacks = new ListWithAutoConstructFlag();
            this.solutionStacks.setAutoConstruct(true);
        }
        return this.solutionStacks;
    }

    public void setSolutionStacks(Collection<String> solutionStacks) {
        if (solutionStacks == null) {
            this.solutionStacks = null;
            return;
        }
        ListWithAutoConstructFlag solutionStacksCopy = new ListWithAutoConstructFlag(solutionStacks.size());
        solutionStacksCopy.addAll(solutionStacks);
        this.solutionStacks = solutionStacksCopy;
    }

    public ListAvailableSolutionStacksResult withSolutionStacks(String ... solutionStacks) {
        if (this.getSolutionStacks() == null) {
            this.setSolutionStacks(new ArrayList<String>(solutionStacks.length));
        }
        for (String value : solutionStacks) {
            this.getSolutionStacks().add(value);
        }
        return this;
    }

    public ListAvailableSolutionStacksResult withSolutionStacks(Collection<String> solutionStacks) {
        if (solutionStacks == null) {
            this.solutionStacks = null;
        } else {
            ListWithAutoConstructFlag solutionStacksCopy = new ListWithAutoConstructFlag(solutionStacks.size());
            solutionStacksCopy.addAll(solutionStacks);
            this.solutionStacks = solutionStacksCopy;
        }
        return this;
    }

    public List<SolutionStackDescription> getSolutionStackDetails() {
        if (this.solutionStackDetails == null) {
            this.solutionStackDetails = new ListWithAutoConstructFlag();
            this.solutionStackDetails.setAutoConstruct(true);
        }
        return this.solutionStackDetails;
    }

    public void setSolutionStackDetails(Collection<SolutionStackDescription> solutionStackDetails) {
        if (solutionStackDetails == null) {
            this.solutionStackDetails = null;
            return;
        }
        ListWithAutoConstructFlag solutionStackDetailsCopy = new ListWithAutoConstructFlag(solutionStackDetails.size());
        solutionStackDetailsCopy.addAll(solutionStackDetails);
        this.solutionStackDetails = solutionStackDetailsCopy;
    }

    public ListAvailableSolutionStacksResult withSolutionStackDetails(SolutionStackDescription ... solutionStackDetails) {
        if (this.getSolutionStackDetails() == null) {
            this.setSolutionStackDetails(new ArrayList<SolutionStackDescription>(solutionStackDetails.length));
        }
        for (SolutionStackDescription value : solutionStackDetails) {
            this.getSolutionStackDetails().add(value);
        }
        return this;
    }

    public ListAvailableSolutionStacksResult withSolutionStackDetails(Collection<SolutionStackDescription> solutionStackDetails) {
        if (solutionStackDetails == null) {
            this.solutionStackDetails = null;
        } else {
            ListWithAutoConstructFlag solutionStackDetailsCopy = new ListWithAutoConstructFlag(solutionStackDetails.size());
            solutionStackDetailsCopy.addAll(solutionStackDetails);
            this.solutionStackDetails = solutionStackDetailsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSolutionStacks() != null) {
            sb.append("SolutionStacks: " + this.getSolutionStacks() + ",");
        }
        if (this.getSolutionStackDetails() != null) {
            sb.append("SolutionStackDetails: " + this.getSolutionStackDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSolutionStacks() == null ? 0 : ((Object)this.getSolutionStacks()).hashCode());
        hashCode = 31 * hashCode + (this.getSolutionStackDetails() == null ? 0 : ((Object)this.getSolutionStackDetails()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableSolutionStacksResult)) {
            return false;
        }
        ListAvailableSolutionStacksResult other = (ListAvailableSolutionStacksResult)obj;
        if (other.getSolutionStacks() == null ^ this.getSolutionStacks() == null) {
            return false;
        }
        if (other.getSolutionStacks() != null && !((Object)other.getSolutionStacks()).equals(this.getSolutionStacks())) {
            return false;
        }
        if (other.getSolutionStackDetails() == null ^ this.getSolutionStackDetails() == null) {
            return false;
        }
        return other.getSolutionStackDetails() == null || ((Object)other.getSolutionStackDetails()).equals(this.getSolutionStackDetails());
    }
}

