/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudformation.model.StackEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeStackEventsResult
implements Serializable {
    private ListWithAutoConstructFlag<StackEvent> stackEvents;
    private String nextToken;

    public List<StackEvent> getStackEvents() {
        if (this.stackEvents == null) {
            this.stackEvents = new ListWithAutoConstructFlag();
            this.stackEvents.setAutoConstruct(true);
        }
        return this.stackEvents;
    }

    public void setStackEvents(Collection<StackEvent> stackEvents) {
        if (stackEvents == null) {
            this.stackEvents = null;
            return;
        }
        ListWithAutoConstructFlag stackEventsCopy = new ListWithAutoConstructFlag(stackEvents.size());
        stackEventsCopy.addAll(stackEvents);
        this.stackEvents = stackEventsCopy;
    }

    public DescribeStackEventsResult withStackEvents(StackEvent ... stackEvents) {
        if (this.getStackEvents() == null) {
            this.setStackEvents(new ArrayList<StackEvent>(stackEvents.length));
        }
        for (StackEvent value : stackEvents) {
            this.getStackEvents().add(value);
        }
        return this;
    }

    public DescribeStackEventsResult withStackEvents(Collection<StackEvent> stackEvents) {
        if (stackEvents == null) {
            this.stackEvents = null;
        } else {
            ListWithAutoConstructFlag stackEventsCopy = new ListWithAutoConstructFlag(stackEvents.size());
            stackEventsCopy.addAll(stackEvents);
            this.stackEvents = stackEventsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeStackEventsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackEvents() != null) {
            sb.append("StackEvents: " + this.getStackEvents() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackEvents() == null ? 0 : ((Object)this.getStackEvents()).hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackEventsResult)) {
            return false;
        }
        DescribeStackEventsResult other = (DescribeStackEventsResult)obj;
        if (other.getStackEvents() == null ^ this.getStackEvents() == null) {
            return false;
        }
        if (other.getStackEvents() != null && !((Object)other.getStackEvents()).equals(this.getStackEvents())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

