/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCaseRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String subject;
    private String serviceCode;
    private String severityCode;
    private String categoryCode;
    private String communicationBody;
    private ListWithAutoConstructFlag<String> ccEmailAddresses;
    private String language;
    private String issueType;

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public CreateCaseRequest withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public CreateCaseRequest withServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
        return this;
    }

    public String getSeverityCode() {
        return this.severityCode;
    }

    public void setSeverityCode(String severityCode) {
        this.severityCode = severityCode;
    }

    public CreateCaseRequest withSeverityCode(String severityCode) {
        this.severityCode = severityCode;
        return this;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public CreateCaseRequest withCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
        return this;
    }

    public String getCommunicationBody() {
        return this.communicationBody;
    }

    public void setCommunicationBody(String communicationBody) {
        this.communicationBody = communicationBody;
    }

    public CreateCaseRequest withCommunicationBody(String communicationBody) {
        this.communicationBody = communicationBody;
        return this;
    }

    public List<String> getCcEmailAddresses() {
        if (this.ccEmailAddresses == null) {
            this.ccEmailAddresses = new ListWithAutoConstructFlag();
            this.ccEmailAddresses.setAutoConstruct(true);
        }
        return this.ccEmailAddresses;
    }

    public void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
        if (ccEmailAddresses == null) {
            this.ccEmailAddresses = null;
            return;
        }
        ListWithAutoConstructFlag ccEmailAddressesCopy = new ListWithAutoConstructFlag(ccEmailAddresses.size());
        ccEmailAddressesCopy.addAll(ccEmailAddresses);
        this.ccEmailAddresses = ccEmailAddressesCopy;
    }

    public CreateCaseRequest withCcEmailAddresses(String ... ccEmailAddresses) {
        if (this.getCcEmailAddresses() == null) {
            this.setCcEmailAddresses(new ArrayList<String>(ccEmailAddresses.length));
        }
        for (String value : ccEmailAddresses) {
            this.getCcEmailAddresses().add(value);
        }
        return this;
    }

    public CreateCaseRequest withCcEmailAddresses(Collection<String> ccEmailAddresses) {
        if (ccEmailAddresses == null) {
            this.ccEmailAddresses = null;
        } else {
            ListWithAutoConstructFlag ccEmailAddressesCopy = new ListWithAutoConstructFlag(ccEmailAddresses.size());
            ccEmailAddressesCopy.addAll(ccEmailAddresses);
            this.ccEmailAddresses = ccEmailAddressesCopy;
        }
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public CreateCaseRequest withLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public CreateCaseRequest withIssueType(String issueType) {
        this.issueType = issueType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubject() != null) {
            sb.append("Subject: " + this.getSubject() + ",");
        }
        if (this.getServiceCode() != null) {
            sb.append("ServiceCode: " + this.getServiceCode() + ",");
        }
        if (this.getSeverityCode() != null) {
            sb.append("SeverityCode: " + this.getSeverityCode() + ",");
        }
        if (this.getCategoryCode() != null) {
            sb.append("CategoryCode: " + this.getCategoryCode() + ",");
        }
        if (this.getCommunicationBody() != null) {
            sb.append("CommunicationBody: " + this.getCommunicationBody() + ",");
        }
        if (this.getCcEmailAddresses() != null) {
            sb.append("CcEmailAddresses: " + this.getCcEmailAddresses() + ",");
        }
        if (this.getLanguage() != null) {
            sb.append("Language: " + this.getLanguage() + ",");
        }
        if (this.getIssueType() != null) {
            sb.append("IssueType: " + this.getIssueType());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubject() == null ? 0 : this.getSubject().hashCode());
        hashCode = 31 * hashCode + (this.getServiceCode() == null ? 0 : this.getServiceCode().hashCode());
        hashCode = 31 * hashCode + (this.getSeverityCode() == null ? 0 : this.getSeverityCode().hashCode());
        hashCode = 31 * hashCode + (this.getCategoryCode() == null ? 0 : this.getCategoryCode().hashCode());
        hashCode = 31 * hashCode + (this.getCommunicationBody() == null ? 0 : this.getCommunicationBody().hashCode());
        hashCode = 31 * hashCode + (this.getCcEmailAddresses() == null ? 0 : ((Object)this.getCcEmailAddresses()).hashCode());
        hashCode = 31 * hashCode + (this.getLanguage() == null ? 0 : this.getLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getIssueType() == null ? 0 : this.getIssueType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCaseRequest)) {
            return false;
        }
        CreateCaseRequest other = (CreateCaseRequest)obj;
        if (other.getSubject() == null ^ this.getSubject() == null) {
            return false;
        }
        if (other.getSubject() != null && !other.getSubject().equals(this.getSubject())) {
            return false;
        }
        if (other.getServiceCode() == null ^ this.getServiceCode() == null) {
            return false;
        }
        if (other.getServiceCode() != null && !other.getServiceCode().equals(this.getServiceCode())) {
            return false;
        }
        if (other.getSeverityCode() == null ^ this.getSeverityCode() == null) {
            return false;
        }
        if (other.getSeverityCode() != null && !other.getSeverityCode().equals(this.getSeverityCode())) {
            return false;
        }
        if (other.getCategoryCode() == null ^ this.getCategoryCode() == null) {
            return false;
        }
        if (other.getCategoryCode() != null && !other.getCategoryCode().equals(this.getCategoryCode())) {
            return false;
        }
        if (other.getCommunicationBody() == null ^ this.getCommunicationBody() == null) {
            return false;
        }
        if (other.getCommunicationBody() != null && !other.getCommunicationBody().equals(this.getCommunicationBody())) {
            return false;
        }
        if (other.getCcEmailAddresses() == null ^ this.getCcEmailAddresses() == null) {
            return false;
        }
        if (other.getCcEmailAddresses() != null && !((Object)other.getCcEmailAddresses()).equals(this.getCcEmailAddresses())) {
            return false;
        }
        if (other.getLanguage() == null ^ this.getLanguage() == null) {
            return false;
        }
        if (other.getLanguage() != null && !other.getLanguage().equals(this.getLanguage())) {
            return false;
        }
        if (other.getIssueType() == null ^ this.getIssueType() == null) {
            return false;
        }
        return other.getIssueType() == null || other.getIssueType().equals(this.getIssueType());
    }
}

