/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.Recipes;
import com.amazonaws.services.opsworks.model.UpdateLayerRequest;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateLayerRequestMarshaller
implements Marshaller<Request<UpdateLayerRequest>, UpdateLayerRequest> {
    @Override
    public Request<UpdateLayerRequest> marshall(UpdateLayerRequest updateLayerRequest) {
        if (updateLayerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateLayerRequest> request = new DefaultRequest<UpdateLayerRequest>(updateLayerRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.UpdateLayer";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            Recipes customRecipes;
            ListWithAutoConstructFlag volumeConfigurationsList;
            ListWithAutoConstructFlag packagesList;
            ListWithAutoConstructFlag customSecurityGroupIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateLayerRequest.getLayerId() != null) {
                jsonWriter.key("LayerId").value(updateLayerRequest.getLayerId());
            }
            if (updateLayerRequest.getName() != null) {
                jsonWriter.key("Name").value(updateLayerRequest.getName());
            }
            if (updateLayerRequest.getShortname() != null) {
                jsonWriter.key("Shortname").value(updateLayerRequest.getShortname());
            }
            if (updateLayerRequest.getAttributes() != null) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry<String, String> attributesListValue : updateLayerRequest.getAttributes().entrySet()) {
                    if (attributesListValue.getValue() == null) continue;
                    jsonWriter.key(attributesListValue.getKey());
                    jsonWriter.value(attributesListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (updateLayerRequest.getCustomInstanceProfileArn() != null) {
                jsonWriter.key("CustomInstanceProfileArn").value(updateLayerRequest.getCustomInstanceProfileArn());
            }
            if (!((customSecurityGroupIdsList = (ListWithAutoConstructFlag)updateLayerRequest.getCustomSecurityGroupIds()) == null || customSecurityGroupIdsList.isAutoConstruct() && customSecurityGroupIdsList.isEmpty())) {
                jsonWriter.key("CustomSecurityGroupIds");
                jsonWriter.array();
                for (String customSecurityGroupIdsListValue : customSecurityGroupIdsList) {
                    if (customSecurityGroupIdsListValue == null) continue;
                    jsonWriter.value(customSecurityGroupIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (!((packagesList = (ListWithAutoConstructFlag)updateLayerRequest.getPackages()) == null || packagesList.isAutoConstruct() && packagesList.isEmpty())) {
                jsonWriter.key("Packages");
                jsonWriter.array();
                for (String packagesListValue : packagesList) {
                    if (packagesListValue == null) continue;
                    jsonWriter.value(packagesListValue);
                }
                jsonWriter.endArray();
            }
            if (!((volumeConfigurationsList = (ListWithAutoConstructFlag)updateLayerRequest.getVolumeConfigurations()) == null || volumeConfigurationsList.isAutoConstruct() && volumeConfigurationsList.isEmpty())) {
                jsonWriter.key("VolumeConfigurations");
                jsonWriter.array();
                for (VolumeConfiguration volumeConfigurationsListValue : volumeConfigurationsList) {
                    if (volumeConfigurationsListValue == null) continue;
                    jsonWriter.object();
                    if (volumeConfigurationsListValue.getMountPoint() != null) {
                        jsonWriter.key("MountPoint").value(volumeConfigurationsListValue.getMountPoint());
                    }
                    if (volumeConfigurationsListValue.getRaidLevel() != null) {
                        jsonWriter.key("RaidLevel").value(volumeConfigurationsListValue.getRaidLevel());
                    }
                    if (volumeConfigurationsListValue.getNumberOfDisks() != null) {
                        jsonWriter.key("NumberOfDisks").value(volumeConfigurationsListValue.getNumberOfDisks());
                    }
                    if (volumeConfigurationsListValue.getSize() != null) {
                        jsonWriter.key("Size").value(volumeConfigurationsListValue.getSize());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (updateLayerRequest.isEnableAutoHealing() != null) {
                jsonWriter.key("EnableAutoHealing").value(updateLayerRequest.isEnableAutoHealing());
            }
            if (updateLayerRequest.isAutoAssignElasticIps() != null) {
                jsonWriter.key("AutoAssignElasticIps").value(updateLayerRequest.isAutoAssignElasticIps());
            }
            if ((customRecipes = updateLayerRequest.getCustomRecipes()) != null) {
                ListWithAutoConstructFlag shutdownList;
                ListWithAutoConstructFlag undeployList;
                ListWithAutoConstructFlag deployList;
                ListWithAutoConstructFlag configureList;
                jsonWriter.key("CustomRecipes");
                jsonWriter.object();
                ListWithAutoConstructFlag setupList = (ListWithAutoConstructFlag)customRecipes.getSetup();
                if (!(setupList == null || setupList.isAutoConstruct() && setupList.isEmpty())) {
                    jsonWriter.key("Setup");
                    jsonWriter.array();
                    for (String setupListValue : setupList) {
                        if (setupListValue == null) continue;
                        jsonWriter.value(setupListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((configureList = (ListWithAutoConstructFlag)customRecipes.getConfigure()) == null || configureList.isAutoConstruct() && configureList.isEmpty())) {
                    jsonWriter.key("Configure");
                    jsonWriter.array();
                    for (String configureListValue : configureList) {
                        if (configureListValue == null) continue;
                        jsonWriter.value(configureListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((deployList = (ListWithAutoConstructFlag)customRecipes.getDeploy()) == null || deployList.isAutoConstruct() && deployList.isEmpty())) {
                    jsonWriter.key("Deploy");
                    jsonWriter.array();
                    for (String deployListValue : deployList) {
                        if (deployListValue == null) continue;
                        jsonWriter.value(deployListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((undeployList = (ListWithAutoConstructFlag)customRecipes.getUndeploy()) == null || undeployList.isAutoConstruct() && undeployList.isEmpty())) {
                    jsonWriter.key("Undeploy");
                    jsonWriter.array();
                    for (String undeployListValue : undeployList) {
                        if (undeployListValue == null) continue;
                        jsonWriter.value(undeployListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((shutdownList = (ListWithAutoConstructFlag)customRecipes.getShutdown()) == null || shutdownList.isAutoConstruct() && shutdownList.isEmpty())) {
                    jsonWriter.key("Shutdown");
                    jsonWriter.array();
                    for (String shutdownListValue : shutdownList) {
                        if (shutdownListValue == null) continue;
                        jsonWriter.value(shutdownListValue);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

