/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.identitymanagement.model.Role;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRolesResult
implements Serializable {
    private ListWithAutoConstructFlag<Role> roles;
    private Boolean isTruncated;
    private String marker;

    public List<Role> getRoles() {
        if (this.roles == null) {
            this.roles = new ListWithAutoConstructFlag();
            this.roles.setAutoConstruct(true);
        }
        return this.roles;
    }

    public void setRoles(Collection<Role> roles) {
        if (roles == null) {
            this.roles = null;
            return;
        }
        ListWithAutoConstructFlag rolesCopy = new ListWithAutoConstructFlag(roles.size());
        rolesCopy.addAll(roles);
        this.roles = rolesCopy;
    }

    public ListRolesResult withRoles(Role ... roles) {
        if (this.getRoles() == null) {
            this.setRoles(new ArrayList<Role>(roles.length));
        }
        for (Role value : roles) {
            this.getRoles().add(value);
        }
        return this;
    }

    public ListRolesResult withRoles(Collection<Role> roles) {
        if (roles == null) {
            this.roles = null;
        } else {
            ListWithAutoConstructFlag rolesCopy = new ListWithAutoConstructFlag(roles.size());
            rolesCopy.addAll(roles);
            this.roles = rolesCopy;
        }
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListRolesResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListRolesResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoles() != null) {
            sb.append("Roles: " + this.getRoles() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoles() == null ? 0 : ((Object)this.getRoles()).hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRolesResult)) {
            return false;
        }
        ListRolesResult other = (ListRolesResult)obj;
        if (other.getRoles() == null ^ this.getRoles() == null) {
            return false;
        }
        if (other.getRoles() != null && !((Object)other.getRoles()).equals(this.getRoles())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

