/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.opsworks.model.CreateInstanceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateInstanceRequestMarshaller
implements Marshaller<Request<CreateInstanceRequest>, CreateInstanceRequest> {
    @Override
    public Request<CreateInstanceRequest> marshall(CreateInstanceRequest createInstanceRequest) {
        if (createInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateInstanceRequest> request = new DefaultRequest<CreateInstanceRequest>(createInstanceRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.CreateInstance";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            List<String> layerIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createInstanceRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(createInstanceRequest.getStackId());
            }
            if ((layerIdsList = createInstanceRequest.getLayerIds()) != null && layerIdsList.size() > 0) {
                jsonWriter.key("LayerIds");
                jsonWriter.array();
                for (String layerIdsListValue : layerIdsList) {
                    if (layerIdsListValue == null) continue;
                    jsonWriter.value(layerIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (createInstanceRequest.getInstanceType() != null) {
                jsonWriter.key("InstanceType").value(createInstanceRequest.getInstanceType());
            }
            if (createInstanceRequest.getAutoScalingType() != null) {
                jsonWriter.key("AutoScalingType").value(createInstanceRequest.getAutoScalingType());
            }
            if (createInstanceRequest.getHostname() != null) {
                jsonWriter.key("Hostname").value(createInstanceRequest.getHostname());
            }
            if (createInstanceRequest.getOs() != null) {
                jsonWriter.key("Os").value(createInstanceRequest.getOs());
            }
            if (createInstanceRequest.getSshKeyName() != null) {
                jsonWriter.key("SshKeyName").value(createInstanceRequest.getSshKeyName());
            }
            if (createInstanceRequest.getAvailabilityZone() != null) {
                jsonWriter.key("AvailabilityZone").value(createInstanceRequest.getAvailabilityZone());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

