/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostResult;
import com.amazonaws.services.cloudformation.model.GetTemplateRequest;
import com.amazonaws.services.cloudformation.model.GetTemplateResult;
import com.amazonaws.services.cloudformation.model.ListStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesResult;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.services.cloudformation.model.ListStacksResult;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import com.amazonaws.services.cloudformation.model.ValidateTemplateRequest;
import com.amazonaws.services.cloudformation.model.ValidateTemplateResult;
import com.amazonaws.services.cloudformation.model.transform.AlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.CancelUpdateStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.CreateStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.CreateStackResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DeleteStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackEventsRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackEventsResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourceRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourceResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourcesRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourcesResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStacksRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStacksResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.EstimateTemplateCostRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.EstimateTemplateCostResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetTemplateRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetTemplateResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.InsufficientCapabilitiesExceptionUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStackResourcesRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStackResourcesResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStacksRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStacksResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.UpdateStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.UpdateStackResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ValidateTemplateRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ValidateTemplateResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudFormationClient
extends AmazonWebServiceClient
implements AmazonCloudFormation {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS4Signer signer;

    public AmazonCloudFormationClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCloudFormationClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCloudFormationClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCloudFormationClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCloudFormationClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCloudFormationClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new AlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InsufficientCapabilitiesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("cloudformation.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("cloudformation");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudformation/request.handlers"));
    }

    @Override
    public ValidateTemplateResult validateTemplate(ValidateTemplateRequest validateTemplateRequest) throws AmazonServiceException, AmazonClientException {
        Request<ValidateTemplateRequest> request = new ValidateTemplateRequestMarshaller().marshall(validateTemplateRequest);
        return this.invoke(request, new ValidateTemplateResultStaxUnmarshaller());
    }

    @Override
    public DescribeStacksResult describeStacks(DescribeStacksRequest describeStacksRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeStacksRequest> request = new DescribeStacksRequestMarshaller().marshall(describeStacksRequest);
        return this.invoke(request, new DescribeStacksResultStaxUnmarshaller());
    }

    @Override
    public GetTemplateResult getTemplate(GetTemplateRequest getTemplateRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetTemplateRequest> request = new GetTemplateRequestMarshaller().marshall(getTemplateRequest);
        return this.invoke(request, new GetTemplateResultStaxUnmarshaller());
    }

    @Override
    public ListStacksResult listStacks(ListStacksRequest listStacksRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListStacksRequest> request = new ListStacksRequestMarshaller().marshall(listStacksRequest);
        return this.invoke(request, new ListStacksResultStaxUnmarshaller());
    }

    @Override
    public CreateStackResult createStack(CreateStackRequest createStackRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateStackRequest> request = new CreateStackRequestMarshaller().marshall(createStackRequest);
        return this.invoke(request, new CreateStackResultStaxUnmarshaller());
    }

    @Override
    public EstimateTemplateCostResult estimateTemplateCost(EstimateTemplateCostRequest estimateTemplateCostRequest) throws AmazonServiceException, AmazonClientException {
        Request<EstimateTemplateCostRequest> request = new EstimateTemplateCostRequestMarshaller().marshall(estimateTemplateCostRequest);
        return this.invoke(request, new EstimateTemplateCostResultStaxUnmarshaller());
    }

    @Override
    public DescribeStackEventsResult describeStackEvents(DescribeStackEventsRequest describeStackEventsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeStackEventsRequest> request = new DescribeStackEventsRequestMarshaller().marshall(describeStackEventsRequest);
        return this.invoke(request, new DescribeStackEventsResultStaxUnmarshaller());
    }

    @Override
    public DescribeStackResourceResult describeStackResource(DescribeStackResourceRequest describeStackResourceRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeStackResourceRequest> request = new DescribeStackResourceRequestMarshaller().marshall(describeStackResourceRequest);
        return this.invoke(request, new DescribeStackResourceResultStaxUnmarshaller());
    }

    @Override
    public void cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest) throws AmazonServiceException, AmazonClientException {
        Request<CancelUpdateStackRequest> request = new CancelUpdateStackRequestMarshaller().marshall(cancelUpdateStackRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteStack(DeleteStackRequest deleteStackRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteStackRequest> request = new DeleteStackRequestMarshaller().marshall(deleteStackRequest);
        this.invoke(request, null);
    }

    @Override
    public ListStackResourcesResult listStackResources(ListStackResourcesRequest listStackResourcesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListStackResourcesRequest> request = new ListStackResourcesRequestMarshaller().marshall(listStackResourcesRequest);
        return this.invoke(request, new ListStackResourcesResultStaxUnmarshaller());
    }

    @Override
    public DescribeStackResourcesResult describeStackResources(DescribeStackResourcesRequest describeStackResourcesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeStackResourcesRequest> request = new DescribeStackResourcesRequestMarshaller().marshall(describeStackResourcesRequest);
        return this.invoke(request, new DescribeStackResourcesResultStaxUnmarshaller());
    }

    @Override
    public UpdateStackResult updateStack(UpdateStackRequest updateStackRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateStackRequest> request = new UpdateStackRequestMarshaller().marshall(updateStackRequest);
        return this.invoke(request, new UpdateStackResultStaxUnmarshaller());
    }

    @Override
    public DescribeStacksResult describeStacks() throws AmazonServiceException, AmazonClientException {
        return this.describeStacks(new DescribeStacksRequest());
    }

    @Override
    public ListStacksResult listStacks() throws AmazonServiceException, AmazonClientException {
        return this.listStacks(new ListStacksRequest());
    }

    @Override
    public EstimateTemplateCostResult estimateTemplateCost() throws AmazonServiceException, AmazonClientException {
        return this.estimateTemplateCost(new EstimateTemplateCostRequest());
    }

    @Override
    public DescribeStackEventsResult describeStackEvents() throws AmazonServiceException, AmazonClientException {
        return this.describeStackEvents(new DescribeStackEventsRequest());
    }

    @Override
    public DescribeStackResourcesResult describeStackResources() throws AmazonServiceException, AmazonClientException {
        return this.describeStackResources(new DescribeStackResourcesRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

