/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy;

public class Principal {
    public static final Principal AllUsers = new Principal("*");
    private final String id;
    private final String provider;

    public Principal(Services service) {
        if (service == null) {
            throw new IllegalArgumentException("Null AWS service name specified");
        }
        this.id = service.getServiceId();
        this.provider = "Service";
    }

    public Principal(String accountId) {
        if (accountId == null) {
            throw new IllegalArgumentException("Null AWS account ID specified");
        }
        this.id = accountId.replaceAll("-", "");
        this.provider = "AWS";
    }

    public String getProvider() {
        return this.provider;
    }

    public String getId() {
        return this.id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Services {
        AWSDataPipeline("datapipeline.amazonaws.com"),
        AmazonElasticTranscoder("elastictranscoder.amazonaws.com"),
        AmazonEC2("ec2.amazonaws.com");

        private String serviceId;

        private Services(String serviceId) {
            this.serviceId = serviceId;
        }

        public String getServiceId() {
            return this.serviceId;
        }
    }
}

