/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeReservedInstancesRequest
extends AmazonWebServiceRequest {
    private List<String> reservedInstancesIds;
    private List<Filter> filters;
    private String offeringType;

    public List<String> getReservedInstancesIds() {
        if (this.reservedInstancesIds == null) {
            this.reservedInstancesIds = new ArrayList<String>();
        }
        return this.reservedInstancesIds;
    }

    public void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
        if (reservedInstancesIds == null) {
            this.reservedInstancesIds = null;
            return;
        }
        ArrayList<String> reservedInstancesIdsCopy = new ArrayList<String>(reservedInstancesIds.size());
        reservedInstancesIdsCopy.addAll(reservedInstancesIds);
        this.reservedInstancesIds = reservedInstancesIdsCopy;
    }

    public DescribeReservedInstancesRequest withReservedInstancesIds(String ... reservedInstancesIds) {
        if (this.getReservedInstancesIds() == null) {
            this.setReservedInstancesIds(new ArrayList<String>(reservedInstancesIds.length));
        }
        for (String value : reservedInstancesIds) {
            this.getReservedInstancesIds().add(value);
        }
        return this;
    }

    public DescribeReservedInstancesRequest withReservedInstancesIds(Collection<String> reservedInstancesIds) {
        if (reservedInstancesIds == null) {
            this.reservedInstancesIds = null;
        } else {
            ArrayList<String> reservedInstancesIdsCopy = new ArrayList<String>(reservedInstancesIds.size());
            reservedInstancesIdsCopy.addAll(reservedInstancesIds);
            this.reservedInstancesIds = reservedInstancesIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ArrayList<Filter> filtersCopy = new ArrayList<Filter>(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeReservedInstancesRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeReservedInstancesRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ArrayList<Filter> filtersCopy = new ArrayList<Filter>(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public String getOfferingType() {
        return this.offeringType;
    }

    public void setOfferingType(String offeringType) {
        this.offeringType = offeringType;
    }

    public DescribeReservedInstancesRequest withOfferingType(String offeringType) {
        this.offeringType = offeringType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: " + this.getReservedInstancesIds() + ", ");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ", ");
        }
        if (this.getOfferingType() != null) {
            sb.append("OfferingType: " + this.getOfferingType() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReservedInstancesIds() == null ? 0 : ((Object)this.getReservedInstancesIds()).hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : ((Object)this.getFilters()).hashCode());
        hashCode = 31 * hashCode + (this.getOfferingType() == null ? 0 : this.getOfferingType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesRequest)) {
            return false;
        }
        DescribeReservedInstancesRequest other = (DescribeReservedInstancesRequest)obj;
        if (other.getReservedInstancesIds() == null ^ this.getReservedInstancesIds() == null) {
            return false;
        }
        if (other.getReservedInstancesIds() != null && !((Object)other.getReservedInstancesIds()).equals(this.getReservedInstancesIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !((Object)other.getFilters()).equals(this.getFilters())) {
            return false;
        }
        if (other.getOfferingType() == null ^ this.getOfferingType() == null) {
            return false;
        }
        return other.getOfferingType() == null || other.getOfferingType().equals(this.getOfferingType());
    }
}

