/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.route53.AmazonRoute53Async;
import com.amazonaws.services.route53.AmazonRoute53Client;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsResult;
import com.amazonaws.services.route53.model.CreateHostedZoneRequest;
import com.amazonaws.services.route53.model.CreateHostedZoneResult;
import com.amazonaws.services.route53.model.DeleteHostedZoneRequest;
import com.amazonaws.services.route53.model.DeleteHostedZoneResult;
import com.amazonaws.services.route53.model.GetChangeRequest;
import com.amazonaws.services.route53.model.GetChangeResult;
import com.amazonaws.services.route53.model.GetHostedZoneRequest;
import com.amazonaws.services.route53.model.GetHostedZoneResult;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonRoute53AsyncClient
extends AmazonRoute53Client
implements AmazonRoute53Async {
    private ExecutorService executorService;

    public AmazonRoute53AsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonRoute53AsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<CreateHostedZoneResult> createHostedZoneAsync(final CreateHostedZoneRequest createHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHostedZoneResult>(){

            @Override
            public CreateHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.createHostedZone(createHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<CreateHostedZoneResult> createHostedZoneAsync(final CreateHostedZoneRequest createHostedZoneRequest, final AsyncHandler<CreateHostedZoneRequest, CreateHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHostedZoneResult>(){

            @Override
            public CreateHostedZoneResult call() throws Exception {
                CreateHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createHostedZone(createHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createHostedZoneRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListHostedZonesResult> listHostedZonesAsync(final ListHostedZonesRequest listHostedZonesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHostedZonesResult>(){

            @Override
            public ListHostedZonesResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listHostedZones(listHostedZonesRequest);
            }
        });
    }

    @Override
    public Future<ListHostedZonesResult> listHostedZonesAsync(final ListHostedZonesRequest listHostedZonesRequest, final AsyncHandler<ListHostedZonesRequest, ListHostedZonesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHostedZonesResult>(){

            @Override
            public ListHostedZonesResult call() throws Exception {
                ListHostedZonesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listHostedZones(listHostedZonesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listHostedZonesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ChangeResourceRecordSetsResult> changeResourceRecordSetsAsync(final ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeResourceRecordSetsResult>(){

            @Override
            public ChangeResourceRecordSetsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.changeResourceRecordSets(changeResourceRecordSetsRequest);
            }
        });
    }

    @Override
    public Future<ChangeResourceRecordSetsResult> changeResourceRecordSetsAsync(final ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest, final AsyncHandler<ChangeResourceRecordSetsRequest, ChangeResourceRecordSetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeResourceRecordSetsResult>(){

            @Override
            public ChangeResourceRecordSetsResult call() throws Exception {
                ChangeResourceRecordSetsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.changeResourceRecordSets(changeResourceRecordSetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(changeResourceRecordSetsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetChangeResult> getChangeAsync(final GetChangeRequest getChangeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetChangeResult>(){

            @Override
            public GetChangeResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getChange(getChangeRequest);
            }
        });
    }

    @Override
    public Future<GetChangeResult> getChangeAsync(final GetChangeRequest getChangeRequest, final AsyncHandler<GetChangeRequest, GetChangeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetChangeResult>(){

            @Override
            public GetChangeResult call() throws Exception {
                GetChangeResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getChange(getChangeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getChangeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListResourceRecordSetsResult> listResourceRecordSetsAsync(final ListResourceRecordSetsRequest listResourceRecordSetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListResourceRecordSetsResult>(){

            @Override
            public ListResourceRecordSetsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listResourceRecordSets(listResourceRecordSetsRequest);
            }
        });
    }

    @Override
    public Future<ListResourceRecordSetsResult> listResourceRecordSetsAsync(final ListResourceRecordSetsRequest listResourceRecordSetsRequest, final AsyncHandler<ListResourceRecordSetsRequest, ListResourceRecordSetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListResourceRecordSetsResult>(){

            @Override
            public ListResourceRecordSetsResult call() throws Exception {
                ListResourceRecordSetsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listResourceRecordSets(listResourceRecordSetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listResourceRecordSetsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHostedZoneResult> getHostedZoneAsync(final GetHostedZoneRequest getHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHostedZoneResult>(){

            @Override
            public GetHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHostedZone(getHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<GetHostedZoneResult> getHostedZoneAsync(final GetHostedZoneRequest getHostedZoneRequest, final AsyncHandler<GetHostedZoneRequest, GetHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHostedZoneResult>(){

            @Override
            public GetHostedZoneResult call() throws Exception {
                GetHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHostedZone(getHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getHostedZoneRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHostedZoneResult> deleteHostedZoneAsync(final DeleteHostedZoneRequest deleteHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHostedZoneResult>(){

            @Override
            public DeleteHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.deleteHostedZone(deleteHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<DeleteHostedZoneResult> deleteHostedZoneAsync(final DeleteHostedZoneRequest deleteHostedZoneRequest, final AsyncHandler<DeleteHostedZoneRequest, DeleteHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHostedZoneResult>(){

            @Override
            public DeleteHostedZoneResult call() throws Exception {
                DeleteHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteHostedZone(deleteHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteHostedZoneRequest, result);
                return result;
            }
        });
    }
}

