/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLoadBalancerPolicyRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerPolicyRequest>, CreateLoadBalancerPolicyRequest> {
    @Override
    public Request<CreateLoadBalancerPolicyRequest> marshall(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) {
        if (createLoadBalancerPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLoadBalancerPolicyRequest> request = new DefaultRequest<CreateLoadBalancerPolicyRequest>(createLoadBalancerPolicyRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateLoadBalancerPolicy");
        request.addParameter("Version", "2012-06-01");
        if (createLoadBalancerPolicyRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString(createLoadBalancerPolicyRequest.getLoadBalancerName()));
        }
        if (createLoadBalancerPolicyRequest.getPolicyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(createLoadBalancerPolicyRequest.getPolicyName()));
        }
        if (createLoadBalancerPolicyRequest.getPolicyTypeName() != null) {
            request.addParameter("PolicyTypeName", StringUtils.fromString(createLoadBalancerPolicyRequest.getPolicyTypeName()));
        }
        List<PolicyAttribute> policyAttributesList = createLoadBalancerPolicyRequest.getPolicyAttributes();
        int policyAttributesListIndex = 1;
        for (PolicyAttribute policyAttributesListValue : policyAttributesList) {
            PolicyAttribute policyAttributeMember = policyAttributesListValue;
            if (policyAttributeMember != null) {
                if (policyAttributeMember.getAttributeName() != null) {
                    request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeName", StringUtils.fromString(policyAttributeMember.getAttributeName()));
                }
                if (policyAttributeMember.getAttributeValue() != null) {
                    request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeValue", StringUtils.fromString(policyAttributeMember.getAttributeValue()));
                }
            }
            ++policyAttributesListIndex;
        }
        return request;
    }
}

