/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.internal;

import com.amazonaws.Request;
import com.amazonaws.handlers.AbstractRequestHandler;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQSRequestHandler
extends AbstractRequestHandler {
    private static final Map<String, String> nonstandardEndpointMap = new HashMap<String, String>();

    @Override
    public void beforeRequest(Request<?> request) {
        URI endpoint = request.getEndpoint();
        if (nonstandardEndpointMap.containsKey(endpoint.getHost())) {
            String newHost = nonstandardEndpointMap.get(endpoint.getHost());
            String newEndpoint = endpoint.toString().replaceFirst(endpoint.getHost(), newHost);
            request.setEndpoint(URI.create(newEndpoint));
        }
    }

    static {
        nonstandardEndpointMap.put("queue.amazonaws.com", "sqs.us-east-1.amazonaws.com");
        nonstandardEndpointMap.put("us-west-1.queue.amazonaws.com", "sqs.us-west-1.amazonaws.com");
        nonstandardEndpointMap.put("us-west-2.queue.amazonaws.com", "sqs.us-west-2.amazonaws.com");
        nonstandardEndpointMap.put("eu-west-1.queue.amazonaws.com", "sqs.eu-west-1.amazonaws.com");
        nonstandardEndpointMap.put("ap-southeast-1.queue.amazonaws.com", "sqs.ap-southeast-1.amazonaws.com");
        nonstandardEndpointMap.put("ap-northeast-1.queue.amazonaws.com", "sqs.ap-northeast-1.amazonaws.com");
        nonstandardEndpointMap.put("sa-east-1.queue.amazonaws.com", "sqs.sa-east-1.amazonaws.com");
    }
}

