/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.rds.model.ModifyOptionGroupRequest;
import com.amazonaws.services.rds.model.OptionConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyOptionGroupRequestMarshaller
implements Marshaller<Request<ModifyOptionGroupRequest>, ModifyOptionGroupRequest> {
    @Override
    public Request<ModifyOptionGroupRequest> marshall(ModifyOptionGroupRequest modifyOptionGroupRequest) {
        if (modifyOptionGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyOptionGroupRequest> request = new DefaultRequest<ModifyOptionGroupRequest>(modifyOptionGroupRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyOptionGroup");
        request.addParameter("Version", "2012-09-17");
        if (modifyOptionGroupRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString(modifyOptionGroupRequest.getOptionGroupName()));
        }
        List<OptionConfiguration> optionsToIncludeList = modifyOptionGroupRequest.getOptionsToInclude();
        int optionsToIncludeListIndex = 1;
        for (OptionConfiguration optionsToIncludeListValue : optionsToIncludeList) {
            OptionConfiguration optionConfigurationMember = optionsToIncludeListValue;
            if (optionConfigurationMember != null) {
                if (optionConfigurationMember.getOptionName() != null) {
                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionName", StringUtils.fromString(optionConfigurationMember.getOptionName()));
                }
                if (optionConfigurationMember.getPort() != null) {
                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".Port", StringUtils.fromInteger(optionConfigurationMember.getPort()));
                }
                List<String> dBSecurityGroupMembershipsList = optionConfigurationMember.getDBSecurityGroupMemberships();
                int dBSecurityGroupMembershipsListIndex = 1;
                for (String dBSecurityGroupMembershipsListValue : dBSecurityGroupMembershipsList) {
                    if (dBSecurityGroupMembershipsListValue != null) {
                        request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".DBSecurityGroupMemberships.DBSecurityGroupName." + dBSecurityGroupMembershipsListIndex, StringUtils.fromString(dBSecurityGroupMembershipsListValue));
                    }
                    ++dBSecurityGroupMembershipsListIndex;
                }
            }
            ++optionsToIncludeListIndex;
        }
        List<String> optionsToRemoveList = modifyOptionGroupRequest.getOptionsToRemove();
        int optionsToRemoveListIndex = 1;
        for (String optionsToRemoveListValue : optionsToRemoveList) {
            if (optionsToRemoveListValue != null) {
                request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex, StringUtils.fromString(optionsToRemoveListValue));
            }
            ++optionsToRemoveListIndex;
        }
        if (modifyOptionGroupRequest.isApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean(modifyOptionGroupRequest.isApplyImmediately()));
        }
        return request;
    }
}

