/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.Condition;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.ScanRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanRequestMarshaller
implements Marshaller<Request<ScanRequest>, ScanRequest> {
    @Override
    public Request<ScanRequest> marshall(ScanRequest scanRequest) {
        if (scanRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ScanRequest> request = new DefaultRequest<ScanRequest>(scanRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20111205.Scan";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            Key exclusiveStartKey;
            List<String> attributesToGetList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (scanRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(scanRequest.getTableName());
            }
            if ((attributesToGetList = scanRequest.getAttributesToGet()) != null && attributesToGetList.size() > 0) {
                jsonWriter.key("AttributesToGet");
                jsonWriter.array();
                for (String attributesToGetListValue : attributesToGetList) {
                    jsonWriter.value(attributesToGetListValue);
                }
                jsonWriter.endArray();
            }
            if (scanRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(scanRequest.getLimit());
            }
            if (scanRequest.isCount() != null) {
                jsonWriter.key("Count").value(scanRequest.isCount());
            }
            if (scanRequest.getScanFilter() != null) {
                jsonWriter.key("ScanFilter");
                jsonWriter.object();
                for (Map.Entry<String, Condition> scanFilterListValue : scanRequest.getScanFilter().entrySet()) {
                    if (scanFilterListValue.getValue() == null) continue;
                    jsonWriter.key(scanFilterListValue.getKey());
                    jsonWriter.object();
                    List<AttributeValue> attributeValueListList = scanFilterListValue.getValue().getAttributeValueList();
                    if (attributeValueListList != null && attributeValueListList.size() > 0) {
                        jsonWriter.key("AttributeValueList");
                        jsonWriter.array();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            List<ByteBuffer> bSList;
                            List<String> nSList;
                            List<String> sSList;
                            jsonWriter.object();
                            if (attributeValueListListValue.getS() != null) {
                                jsonWriter.key("S").value(attributeValueListListValue.getS());
                            }
                            if (attributeValueListListValue.getN() != null) {
                                jsonWriter.key("N").value(attributeValueListListValue.getN());
                            }
                            if (attributeValueListListValue.getB() != null) {
                                jsonWriter.key("B").value(attributeValueListListValue.getB());
                            }
                            if ((sSList = attributeValueListListValue.getSS()) != null && sSList.size() > 0) {
                                jsonWriter.key("SS");
                                jsonWriter.array();
                                for (String sSListValue : sSList) {
                                    jsonWriter.value(sSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            if ((nSList = attributeValueListListValue.getNS()) != null && nSList.size() > 0) {
                                jsonWriter.key("NS");
                                jsonWriter.array();
                                for (String nSListValue : nSList) {
                                    jsonWriter.value(nSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            if ((bSList = attributeValueListListValue.getBS()) != null && bSList.size() > 0) {
                                jsonWriter.key("BS");
                                jsonWriter.array();
                                for (ByteBuffer bSListValue : bSList) {
                                    jsonWriter.value(bSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (scanFilterListValue.getValue().getComparisonOperator() != null) {
                        jsonWriter.key("ComparisonOperator").value(scanFilterListValue.getValue().getComparisonOperator());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if ((exclusiveStartKey = scanRequest.getExclusiveStartKey()) != null) {
                AttributeValue rangeKeyElement;
                jsonWriter.key("ExclusiveStartKey");
                jsonWriter.object();
                AttributeValue hashKeyElement = exclusiveStartKey.getHashKeyElement();
                if (hashKeyElement != null) {
                    List<ByteBuffer> bSList;
                    List<String> nSList;
                    List<String> sSList;
                    jsonWriter.key("HashKeyElement");
                    jsonWriter.object();
                    if (hashKeyElement.getS() != null) {
                        jsonWriter.key("S").value(hashKeyElement.getS());
                    }
                    if (hashKeyElement.getN() != null) {
                        jsonWriter.key("N").value(hashKeyElement.getN());
                    }
                    if (hashKeyElement.getB() != null) {
                        jsonWriter.key("B").value(hashKeyElement.getB());
                    }
                    if ((sSList = hashKeyElement.getSS()) != null && sSList.size() > 0) {
                        jsonWriter.key("SS");
                        jsonWriter.array();
                        for (String sSListValue : sSList) {
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((nSList = hashKeyElement.getNS()) != null && nSList.size() > 0) {
                        jsonWriter.key("NS");
                        jsonWriter.array();
                        for (String nSListValue : nSList) {
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((bSList = hashKeyElement.getBS()) != null && bSList.size() > 0) {
                        jsonWriter.key("BS");
                        jsonWriter.array();
                        for (ByteBuffer bSListValue : bSList) {
                            jsonWriter.value(bSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                if ((rangeKeyElement = exclusiveStartKey.getRangeKeyElement()) != null) {
                    List<ByteBuffer> bSList;
                    List<String> nSList;
                    List<String> sSList;
                    jsonWriter.key("RangeKeyElement");
                    jsonWriter.object();
                    if (rangeKeyElement.getS() != null) {
                        jsonWriter.key("S").value(rangeKeyElement.getS());
                    }
                    if (rangeKeyElement.getN() != null) {
                        jsonWriter.key("N").value(rangeKeyElement.getN());
                    }
                    if (rangeKeyElement.getB() != null) {
                        jsonWriter.key("B").value(rangeKeyElement.getB());
                    }
                    if ((sSList = rangeKeyElement.getSS()) != null && sSList.size() > 0) {
                        jsonWriter.key("SS");
                        jsonWriter.array();
                        for (String sSListValue : sSList) {
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((nSList = rangeKeyElement.getNS()) != null && nSList.size() > 0) {
                        jsonWriter.key("NS");
                        jsonWriter.array();
                        for (String nSListValue : nSList) {
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((bSList = rangeKeyElement.getBS()) != null && bSList.size() > 0) {
                        jsonWriter.key("BS");
                        jsonWriter.array();
                        for (ByteBuffer bSListValue : bSList) {
                            jsonWriter.value(bSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

