/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopInstancesRequestMarshaller
implements Marshaller<Request<StopInstancesRequest>, StopInstancesRequest> {
    @Override
    public Request<StopInstancesRequest> marshall(StopInstancesRequest stopInstancesRequest) {
        if (stopInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StopInstancesRequest> request = new DefaultRequest<StopInstancesRequest>(stopInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "StopInstances");
        request.addParameter("Version", "2012-06-01");
        List<String> instanceIdsList = stopInstancesRequest.getInstanceIds();
        int instanceIdsListIndex = 1;
        for (String instanceIdsListValue : instanceIdsList) {
            if (instanceIdsListValue != null) {
                request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString(instanceIdsListValue));
            }
            ++instanceIdsListIndex;
        }
        if (stopInstancesRequest.isForce() != null) {
            request.addParameter("Force", StringUtils.fromBoolean(stopInstancesRequest.isForce()));
        }
        return request;
    }
}

