/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.storagegateway.AWSStorageGatewayAsync;
import com.amazonaws.services.storagegateway.AWSStorageGatewayClient;
import com.amazonaws.services.storagegateway.model.ActivateGatewayRequest;
import com.amazonaws.services.storagegateway.model.ActivateGatewayResult;
import com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest;
import com.amazonaws.services.storagegateway.model.AddWorkingStorageResult;
import com.amazonaws.services.storagegateway.model.CreateSnapshotRequest;
import com.amazonaws.services.storagegateway.model.CreateSnapshotResult;
import com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest;
import com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeResult;
import com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest;
import com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitResult;
import com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest;
import com.amazonaws.services.storagegateway.model.DeleteChapCredentialsResult;
import com.amazonaws.services.storagegateway.model.DeleteGatewayRequest;
import com.amazonaws.services.storagegateway.model.DeleteGatewayResult;
import com.amazonaws.services.storagegateway.model.DeleteVolumeRequest;
import com.amazonaws.services.storagegateway.model.DeleteVolumeResult;
import com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest;
import com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitResult;
import com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest;
import com.amazonaws.services.storagegateway.model.DescribeChapCredentialsResult;
import com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest;
import com.amazonaws.services.storagegateway.model.DescribeGatewayInformationResult;
import com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest;
import com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeResult;
import com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest;
import com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleResult;
import com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest;
import com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesResult;
import com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest;
import com.amazonaws.services.storagegateway.model.DescribeWorkingStorageResult;
import com.amazonaws.services.storagegateway.model.ListGatewaysRequest;
import com.amazonaws.services.storagegateway.model.ListGatewaysResult;
import com.amazonaws.services.storagegateway.model.ListLocalDisksRequest;
import com.amazonaws.services.storagegateway.model.ListLocalDisksResult;
import com.amazonaws.services.storagegateway.model.ListVolumesRequest;
import com.amazonaws.services.storagegateway.model.ListVolumesResult;
import com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest;
import com.amazonaws.services.storagegateway.model.ShutdownGatewayResult;
import com.amazonaws.services.storagegateway.model.StartGatewayRequest;
import com.amazonaws.services.storagegateway.model.StartGatewayResult;
import com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest;
import com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitResult;
import com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest;
import com.amazonaws.services.storagegateway.model.UpdateChapCredentialsResult;
import com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest;
import com.amazonaws.services.storagegateway.model.UpdateGatewayInformationResult;
import com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest;
import com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowResult;
import com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest;
import com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeResult;
import com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest;
import com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSStorageGatewayAsyncClient
extends AWSStorageGatewayClient
implements AWSStorageGatewayAsync {
    private ExecutorService executorService;

    public AWSStorageGatewayAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AWSStorageGatewayAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSStorageGatewayAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSStorageGatewayAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AWSStorageGatewayAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSStorageGatewayAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DescribeBandwidthRateLimitResult> describeBandwidthRateLimitAsync(final DescribeBandwidthRateLimitRequest describeBandwidthRateLimitRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeBandwidthRateLimitResult>(){

            @Override
            public DescribeBandwidthRateLimitResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.describeBandwidthRateLimit(describeBandwidthRateLimitRequest);
            }
        });
    }

    @Override
    public Future<ShutdownGatewayResult> shutdownGatewayAsync(final ShutdownGatewayRequest shutdownGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ShutdownGatewayResult>(){

            @Override
            public ShutdownGatewayResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.shutdownGateway(shutdownGatewayRequest);
            }
        });
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(final CreateSnapshotRequest createSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.createSnapshot(createSnapshotRequest);
            }
        });
    }

    @Override
    public Future<DeleteVolumeResult> deleteVolumeAsync(final DeleteVolumeRequest deleteVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteVolumeResult>(){

            @Override
            public DeleteVolumeResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.deleteVolume(deleteVolumeRequest);
            }
        });
    }

    @Override
    public Future<UpdateMaintenanceStartTimeResult> updateMaintenanceStartTimeAsync(final UpdateMaintenanceStartTimeRequest updateMaintenanceStartTimeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateMaintenanceStartTimeResult>(){

            @Override
            public UpdateMaintenanceStartTimeResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.updateMaintenanceStartTime(updateMaintenanceStartTimeRequest);
            }
        });
    }

    @Override
    public Future<DescribeGatewayInformationResult> describeGatewayInformationAsync(final DescribeGatewayInformationRequest describeGatewayInformationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeGatewayInformationResult>(){

            @Override
            public DescribeGatewayInformationResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.describeGatewayInformation(describeGatewayInformationRequest);
            }
        });
    }

    @Override
    public Future<CreateStorediSCSIVolumeResult> createStorediSCSIVolumeAsync(final CreateStorediSCSIVolumeRequest createStorediSCSIVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateStorediSCSIVolumeResult>(){

            @Override
            public CreateStorediSCSIVolumeResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.createStorediSCSIVolume(createStorediSCSIVolumeRequest);
            }
        });
    }

    @Override
    public Future<UpdateChapCredentialsResult> updateChapCredentialsAsync(final UpdateChapCredentialsRequest updateChapCredentialsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateChapCredentialsResult>(){

            @Override
            public UpdateChapCredentialsResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.updateChapCredentials(updateChapCredentialsRequest);
            }
        });
    }

    @Override
    public Future<StartGatewayResult> startGatewayAsync(final StartGatewayRequest startGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StartGatewayResult>(){

            @Override
            public StartGatewayResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.startGateway(startGatewayRequest);
            }
        });
    }

    @Override
    public Future<DeleteBandwidthRateLimitResult> deleteBandwidthRateLimitAsync(final DeleteBandwidthRateLimitRequest deleteBandwidthRateLimitRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteBandwidthRateLimitResult>(){

            @Override
            public DeleteBandwidthRateLimitResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.deleteBandwidthRateLimit(deleteBandwidthRateLimitRequest);
            }
        });
    }

    @Override
    public Future<UpdateSnapshotScheduleResult> updateSnapshotScheduleAsync(final UpdateSnapshotScheduleRequest updateSnapshotScheduleRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateSnapshotScheduleResult>(){

            @Override
            public UpdateSnapshotScheduleResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.updateSnapshotSchedule(updateSnapshotScheduleRequest);
            }
        });
    }

    @Override
    public Future<DescribeMaintenanceStartTimeResult> describeMaintenanceStartTimeAsync(final DescribeMaintenanceStartTimeRequest describeMaintenanceStartTimeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMaintenanceStartTimeResult>(){

            @Override
            public DescribeMaintenanceStartTimeResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.describeMaintenanceStartTime(describeMaintenanceStartTimeRequest);
            }
        });
    }

    @Override
    public Future<DescribeSnapshotScheduleResult> describeSnapshotScheduleAsync(final DescribeSnapshotScheduleRequest describeSnapshotScheduleRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotScheduleResult>(){

            @Override
            public DescribeSnapshotScheduleResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.describeSnapshotSchedule(describeSnapshotScheduleRequest);
            }
        });
    }

    @Override
    public Future<UpdateBandwidthRateLimitResult> updateBandwidthRateLimitAsync(final UpdateBandwidthRateLimitRequest updateBandwidthRateLimitRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateBandwidthRateLimitResult>(){

            @Override
            public UpdateBandwidthRateLimitResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.updateBandwidthRateLimit(updateBandwidthRateLimitRequest);
            }
        });
    }

    @Override
    public Future<DeleteChapCredentialsResult> deleteChapCredentialsAsync(final DeleteChapCredentialsRequest deleteChapCredentialsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteChapCredentialsResult>(){

            @Override
            public DeleteChapCredentialsResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.deleteChapCredentials(deleteChapCredentialsRequest);
            }
        });
    }

    @Override
    public Future<DescribeStorediSCSIVolumesResult> describeStorediSCSIVolumesAsync(final DescribeStorediSCSIVolumesRequest describeStorediSCSIVolumesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStorediSCSIVolumesResult>(){

            @Override
            public DescribeStorediSCSIVolumesResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.describeStorediSCSIVolumes(describeStorediSCSIVolumesRequest);
            }
        });
    }

    @Override
    public Future<UpdateGatewayInformationResult> updateGatewayInformationAsync(final UpdateGatewayInformationRequest updateGatewayInformationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateGatewayInformationResult>(){

            @Override
            public UpdateGatewayInformationResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.updateGatewayInformation(updateGatewayInformationRequest);
            }
        });
    }

    @Override
    public Future<DeleteGatewayResult> deleteGatewayAsync(final DeleteGatewayRequest deleteGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteGatewayResult>(){

            @Override
            public DeleteGatewayResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.deleteGateway(deleteGatewayRequest);
            }
        });
    }

    @Override
    public Future<ListVolumesResult> listVolumesAsync(final ListVolumesRequest listVolumesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListVolumesResult>(){

            @Override
            public ListVolumesResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.listVolumes(listVolumesRequest);
            }
        });
    }

    @Override
    public Future<ListLocalDisksResult> listLocalDisksAsync(final ListLocalDisksRequest listLocalDisksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListLocalDisksResult>(){

            @Override
            public ListLocalDisksResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.listLocalDisks(listLocalDisksRequest);
            }
        });
    }

    @Override
    public Future<DescribeChapCredentialsResult> describeChapCredentialsAsync(final DescribeChapCredentialsRequest describeChapCredentialsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeChapCredentialsResult>(){

            @Override
            public DescribeChapCredentialsResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.describeChapCredentials(describeChapCredentialsRequest);
            }
        });
    }

    @Override
    public Future<UpdateGatewaySoftwareNowResult> updateGatewaySoftwareNowAsync(final UpdateGatewaySoftwareNowRequest updateGatewaySoftwareNowRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateGatewaySoftwareNowResult>(){

            @Override
            public UpdateGatewaySoftwareNowResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.updateGatewaySoftwareNow(updateGatewaySoftwareNowRequest);
            }
        });
    }

    @Override
    public Future<ListGatewaysResult> listGatewaysAsync(final ListGatewaysRequest listGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListGatewaysResult>(){

            @Override
            public ListGatewaysResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.listGateways(listGatewaysRequest);
            }
        });
    }

    @Override
    public Future<DescribeWorkingStorageResult> describeWorkingStorageAsync(final DescribeWorkingStorageRequest describeWorkingStorageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeWorkingStorageResult>(){

            @Override
            public DescribeWorkingStorageResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.describeWorkingStorage(describeWorkingStorageRequest);
            }
        });
    }

    @Override
    public Future<AddWorkingStorageResult> addWorkingStorageAsync(final AddWorkingStorageRequest addWorkingStorageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddWorkingStorageResult>(){

            @Override
            public AddWorkingStorageResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.addWorkingStorage(addWorkingStorageRequest);
            }
        });
    }

    @Override
    public Future<ActivateGatewayResult> activateGatewayAsync(final ActivateGatewayRequest activateGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ActivateGatewayResult>(){

            @Override
            public ActivateGatewayResult call() throws Exception {
                return AWSStorageGatewayAsyncClient.this.activateGateway(activateGatewayRequest);
            }
        });
    }
}

