/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.services.elasticloadbalancing.model.Instance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeregisterInstancesFromLoadBalancerResult {
    private List<Instance> instances;

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new ArrayList<Instance>();
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        ArrayList<Instance> instancesCopy = new ArrayList<Instance>(instances.size());
        instancesCopy.addAll(instances);
        this.instances = instancesCopy;
    }

    public DeregisterInstancesFromLoadBalancerResult withInstances(Instance ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<Instance>(instances.length));
        }
        for (Instance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public DeregisterInstancesFromLoadBalancerResult withInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
        } else {
            ArrayList<Instance> instancesCopy = new ArrayList<Instance>(instances.size());
            instancesCopy.addAll(instances);
            this.instances = instancesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instances != null) {
            sb.append("Instances: " + this.instances + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : ((Object)this.getInstances()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterInstancesFromLoadBalancerResult)) {
            return false;
        }
        DeregisterInstancesFromLoadBalancerResult other = (DeregisterInstancesFromLoadBalancerResult)obj;
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        return other.getInstances() == null || ((Object)other.getInstances()).equals(this.getInstances());
    }
}

