/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchPutAttributesRequest
extends AmazonWebServiceRequest {
    private String domainName;
    private List<ReplaceableItem> items;

    public BatchPutAttributesRequest() {
    }

    public BatchPutAttributesRequest(String domainName, List<ReplaceableItem> items) {
        this.domainName = domainName;
        this.items = items;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public BatchPutAttributesRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public List<ReplaceableItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<ReplaceableItem>();
        }
        return this.items;
    }

    public void setItems(Collection<ReplaceableItem> items) {
        ArrayList<ReplaceableItem> itemsCopy = new ArrayList<ReplaceableItem>();
        if (items != null) {
            itemsCopy.addAll(items);
        }
        this.items = itemsCopy;
    }

    public BatchPutAttributesRequest withItems(ReplaceableItem ... items) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<ReplaceableItem>());
        }
        for (ReplaceableItem value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public BatchPutAttributesRequest withItems(Collection<ReplaceableItem> items) {
        ArrayList<ReplaceableItem> itemsCopy = new ArrayList<ReplaceableItem>();
        if (items != null) {
            itemsCopy.addAll(items);
        }
        this.items = itemsCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("DomainName: " + this.domainName + ", ");
        sb.append("Items: " + this.items + ", ");
        sb.append("}");
        return sb.toString();
    }
}

