/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.services.rds.model.AvailabilityZone;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderableDBInstanceOption {
    private String engine;
    private String engineVersion;
    private String dBInstanceClass;
    private String licenseModel;
    private List<AvailabilityZone> availabilityZones;
    private Boolean multiAZCapable;
    private Boolean readReplicaCapable;

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public OrderableDBInstanceOption withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public OrderableDBInstanceOption withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public OrderableDBInstanceOption withDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
        return this;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public OrderableDBInstanceOption withLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
        return this;
    }

    public List<AvailabilityZone> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ArrayList<AvailabilityZone>();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        ArrayList<AvailabilityZone> availabilityZonesCopy = new ArrayList<AvailabilityZone>();
        if (availabilityZones != null) {
            availabilityZonesCopy.addAll(availabilityZones);
        }
        this.availabilityZones = availabilityZonesCopy;
    }

    public OrderableDBInstanceOption withAvailabilityZones(AvailabilityZone ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.setAvailabilityZones(new ArrayList<AvailabilityZone>());
        }
        for (AvailabilityZone value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public OrderableDBInstanceOption withAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        ArrayList<AvailabilityZone> availabilityZonesCopy = new ArrayList<AvailabilityZone>();
        if (availabilityZones != null) {
            availabilityZonesCopy.addAll(availabilityZones);
        }
        this.availabilityZones = availabilityZonesCopy;
        return this;
    }

    public Boolean isMultiAZCapable() {
        return this.multiAZCapable;
    }

    public void setMultiAZCapable(Boolean multiAZCapable) {
        this.multiAZCapable = multiAZCapable;
    }

    public OrderableDBInstanceOption withMultiAZCapable(Boolean multiAZCapable) {
        this.multiAZCapable = multiAZCapable;
        return this;
    }

    public Boolean getMultiAZCapable() {
        return this.multiAZCapable;
    }

    public Boolean isReadReplicaCapable() {
        return this.readReplicaCapable;
    }

    public void setReadReplicaCapable(Boolean readReplicaCapable) {
        this.readReplicaCapable = readReplicaCapable;
    }

    public OrderableDBInstanceOption withReadReplicaCapable(Boolean readReplicaCapable) {
        this.readReplicaCapable = readReplicaCapable;
        return this;
    }

    public Boolean getReadReplicaCapable() {
        return this.readReplicaCapable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("Engine: " + this.engine + ", ");
        sb.append("EngineVersion: " + this.engineVersion + ", ");
        sb.append("DBInstanceClass: " + this.dBInstanceClass + ", ");
        sb.append("LicenseModel: " + this.licenseModel + ", ");
        sb.append("AvailabilityZones: " + this.availabilityZones + ", ");
        sb.append("MultiAZCapable: " + this.multiAZCapable + ", ");
        sb.append("ReadReplicaCapable: " + this.readReplicaCapable + ", ");
        sb.append("}");
        return sb.toString();
    }
}

