/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddInstanceGroupsRequest
extends AmazonWebServiceRequest {
    private List<InstanceGroupConfig> instanceGroups;
    private String jobFlowId;

    public AddInstanceGroupsRequest() {
    }

    public AddInstanceGroupsRequest(List<InstanceGroupConfig> instanceGroups, String jobFlowId) {
        this.instanceGroups = instanceGroups;
        this.jobFlowId = jobFlowId;
    }

    public List<InstanceGroupConfig> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new ArrayList<InstanceGroupConfig>();
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        ArrayList<InstanceGroupConfig> instanceGroupsCopy = new ArrayList<InstanceGroupConfig>();
        if (instanceGroups != null) {
            instanceGroupsCopy.addAll(instanceGroups);
        }
        this.instanceGroups = instanceGroupsCopy;
    }

    public AddInstanceGroupsRequest withInstanceGroups(InstanceGroupConfig ... instanceGroups) {
        if (this.getInstanceGroups() == null) {
            this.setInstanceGroups(new ArrayList<InstanceGroupConfig>());
        }
        for (InstanceGroupConfig value : instanceGroups) {
            this.getInstanceGroups().add(value);
        }
        return this;
    }

    public AddInstanceGroupsRequest withInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        ArrayList<InstanceGroupConfig> instanceGroupsCopy = new ArrayList<InstanceGroupConfig>();
        if (instanceGroups != null) {
            instanceGroupsCopy.addAll(instanceGroups);
        }
        this.instanceGroups = instanceGroupsCopy;
        return this;
    }

    public String getJobFlowId() {
        return this.jobFlowId;
    }

    public void setJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
    }

    public AddInstanceGroupsRequest withJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("InstanceGroups: " + this.instanceGroups + ", ");
        sb.append("JobFlowId: " + this.jobFlowId + ", ");
        sb.append("}");
        return sb.toString();
    }
}

