/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.util.DateUtils;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWS3Signer
extends AbstractAWSSigner {
    private static final String AUTHORIZATION_HEADER = "X-Amzn-Authorization";
    private static final String NONCE_HEADER = "x-amz-nonce";
    private static final String HTTP_SCHEME = "AWS3";
    private static final String HTTPS_SCHEME = "AWS3-HTTPS";
    protected static final DateUtils dateUtils = new DateUtils();
    private static final Log log = LogFactory.getLog(AWS3Signer.class);

    @Override
    public void sign(Request<?> request, AWSCredentials credentials) throws AmazonClientException {
        String stringToSign;
        SigningAlgorithm algorithm = SigningAlgorithm.HmacSHA256;
        String nonce = UUID.randomUUID().toString();
        String date = dateUtils.formatRfc822Date(new Date());
        boolean isHttps = this.isHttpsRequest(request);
        if (isHttps) {
            stringToSign = date + nonce;
        } else {
            stringToSign = "POST\n" + this.getCanonicalizedEndpoint(request.getEndpoint()) + "\n" + this.getCanonicalizedResourcePath(request.getEndpoint()) + "\n" + this.getCanonicalizedQueryString(request.getParameters()) + "\n" + this.getCanonicalizedHeadersForStringToSign(request) + "\n" + "";
            stringToSign = this.hash(stringToSign);
        }
        log.debug((Object)("Calculated StringToSign: " + stringToSign));
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        String signature = this.sign(stringToSign, sanitizedCredentials.getAWSSecretKey(), algorithm);
        StringBuilder builder = new StringBuilder();
        builder.append(isHttps ? HTTPS_SCHEME : HTTP_SCHEME).append(" ");
        builder.append("AWSAccessKeyId=" + sanitizedCredentials.getAWSAccessKeyId() + ",");
        builder.append("Algorithm=" + algorithm.toString() + ",");
        builder.append("Signature=" + signature);
        request.addHeader(AUTHORIZATION_HEADER, builder.toString());
        request.addHeader(NONCE_HEADER, nonce);
        request.addHeader("Date", date);
    }

    private String hash(String text) throws AmazonClientException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes());
            return this.toHex(md.digest());
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    private String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i]);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase(Locale.getDefault());
    }

    protected String getCanonicalizedHeadersForStringToSign(Request<?> request) {
        TreeMap<String, String> sortedHeaderMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            String key = entry.getKey().toLowerCase();
            if (!key.startsWith("x-amz") && !key.equals("date") && !key.equals("content-length")) continue;
            sortedHeaderMap.put(key, entry.getValue());
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : sortedHeaderMap.entrySet()) {
            builder.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("\n");
        }
        return builder.toString();
    }

    private boolean isHttpsRequest(Request<?> request) throws AmazonClientException {
        try {
            String protocol = request.getEndpoint().toURL().getProtocol().toLowerCase();
            if (protocol.equals("http")) {
                return false;
            }
            if (protocol.equals("https")) {
                return true;
            }
            throw new AmazonClientException("Unknown request endpoint protocol encountered while signing request: " + protocol);
        }
        catch (MalformedURLException e) {
            throw new AmazonClientException("Unable to parse request endpoint during signing", e);
        }
    }
}

