/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpMethodReleaseInputStream;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.RepeatableInputStreamRequestEntity;
import com.amazonaws.util.CountingInputStream;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.ResponseMetadataCache;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    private static final Log requestLog;
    private static final Log log;
    private static final Log unmarshallerPerformanceLog;
    private org.apache.commons.httpclient.HttpClient httpClient;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private final ClientConfiguration config;
    private ResponseMetadataCache responseMetadataCache = new ResponseMetadataCache(50);
    private Random random = new Random();

    public HttpClient(ClientConfiguration clientConfiguration) {
        this.config = clientConfiguration;
        this.configureHttpClient();
    }

    public ResponseMetadata getResponseMetadataForRequest(AmazonWebServiceRequest request) {
        return this.responseMetadataCache.get(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpRequest request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler) throws AmazonServiceException {
        java.net.URI endpoint = request.getEndpoint();
        HttpMethodBase method = this.createHttpMethodFromRequest(request);
        if (method.getRequestHeader("Content-Type") == null) {
            log.debug((Object)("Setting content-type to application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase()));
            method.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase());
        } else {
            log.debug((Object)("Not overwriting Content-Type; already set to: " + method.getRequestHeader("Content-Type")));
        }
        boolean leaveHttpConnectionOpen = false;
        String hostHeader = endpoint.getHost();
        if (HttpUtils.isUsingNonDefaultPort(endpoint)) {
            hostHeader = hostHeader + ":" + endpoint.getPort();
        }
        method.addRequestHeader("Host", hostHeader);
        this.httpClient.getHttpConnectionManager().closeIdleConnections(30000L);
        requestLog.info((Object)("Sending Request: " + request.toString()));
        int retries = 0;
        AmazonServiceException exception = null;
        while (true) {
            try {
                if (retries > 0) {
                    this.pauseExponentially(retries, exception);
                }
                exception = null;
                ++retries;
                int status = this.httpClient.executeMethod((HttpMethod)method);
                if (this.isRequestSuccessful(status)) {
                    leaveHttpConnectionOpen = responseHandler.needsConnectionLeftOpen();
                    T t = this.handleResponse(request, responseHandler, method);
                    return t;
                }
                if (this.isTemporaryRedirect(method, status)) {
                    Header locationHeader = method.getResponseHeader("location");
                    String redirectedLocation = locationHeader.getValue();
                    log.debug((Object)("Redirecting to: " + redirectedLocation));
                    method.setURI(new URI(redirectedLocation, false));
                    continue;
                }
                leaveHttpConnectionOpen = errorResponseHandler.needsConnectionLeftOpen();
                exception = this.handleErrorResponse(request, errorResponseHandler, method);
                if (this.shouldRetry((HttpMethod)method, exception, retries)) continue;
                throw exception;
            }
            catch (IOException ioe) {
                log.warn((Object)("Unable to execute HTTP request: " + ioe.getMessage()));
                if (this.shouldRetry((HttpMethod)method, ioe, retries)) continue;
                throw new AmazonClientException("Unable to execute HTTP request: " + ioe.getMessage(), ioe);
            }
            finally {
                if (leaveHttpConnectionOpen) continue;
                try {
                    method.getResponseBodyAsStream().close();
                }
                catch (Throwable t) {}
                method.releaseConnection();
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        HttpConnectionManager connectionManager = this.httpClient.getHttpConnectionManager();
        if (connectionManager instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)connectionManager).shutdown();
        }
    }

    private boolean shouldRetry(HttpMethod method, Exception exception, int retries) {
        if (retries > this.config.getMaxErrorRetry()) {
            return false;
        }
        if (!method.isRequestSent()) {
            log.debug((Object)"Retrying on unsent request");
            return true;
        }
        if (exception instanceof NoHttpResponseException || exception instanceof SocketException || exception instanceof SocketTimeoutException) {
            log.debug((Object)("Retrying on " + exception.getClass().getName() + ": " + exception.getMessage()));
            return true;
        }
        if (exception instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)exception;
            if (ase.getStatusCode() == 500 || ase.getStatusCode() == 503) {
                return true;
            }
            if (this.isThrottlingException(ase)) {
                return true;
            }
        }
        return false;
    }

    private boolean isTemporaryRedirect(HttpMethodBase method, int status) {
        return status == 307 && method.getResponseHeader("location") != null;
    }

    private boolean isRequestSuccessful(int status) {
        return status / 100 == 2;
    }

    private HttpMethodBase createHttpMethodFromRequest(HttpRequest request) {
        PostMethod method;
        java.net.URI endpoint = request.getEndpoint();
        String uri = endpoint.toString();
        if (request.getResourcePath() != null && request.getResourcePath().length() > 0) {
            if (!request.getResourcePath().startsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + request.getResourcePath();
        }
        NameValuePair[] nameValuePairs = null;
        if (request.getParameters().size() > 0) {
            nameValuePairs = new NameValuePair[request.getParameters().size()];
            int i = 0;
            for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
                nameValuePairs[i++] = new NameValuePair(entry.getKey(), entry.getValue());
            }
        }
        if (request.getMethodName() == HttpMethodName.POST) {
            PostMethod postMethod = new PostMethod(uri);
            if (request.getContent() == null) {
                if (nameValuePairs != null) {
                    postMethod.addParameters(nameValuePairs);
                }
            } else {
                if (nameValuePairs != null) {
                    postMethod.setQueryString(nameValuePairs);
                }
                postMethod.setRequestEntity((RequestEntity)new RepeatableInputStreamRequestEntity(request));
            }
            method = postMethod;
        } else if (request.getMethodName() == HttpMethodName.GET) {
            GetMethod getMethod = new GetMethod(uri);
            if (nameValuePairs != null) {
                getMethod.setQueryString(nameValuePairs);
            }
            method = getMethod;
        } else if (request.getMethodName() == HttpMethodName.PUT) {
            PutMethod putMethod = new PutMethod(uri);
            if (nameValuePairs != null) {
                putMethod.setQueryString(nameValuePairs);
            }
            method = putMethod;
            putMethod.getParams().setBooleanParameter("http.protocol.expect-continue", true);
            if (request.getContent() != null) {
                putMethod.setRequestEntity((RequestEntity)new RepeatableInputStreamRequestEntity(request));
            }
        } else if (request.getMethodName() == HttpMethodName.DELETE) {
            DeleteMethod deleteMethod = new DeleteMethod(uri);
            if (nameValuePairs != null) {
                deleteMethod.setQueryString(nameValuePairs);
            }
            method = deleteMethod;
        } else if (request.getMethodName() == HttpMethodName.HEAD) {
            HeadMethod headMethod = new HeadMethod(uri);
            if (nameValuePairs != null) {
                headMethod.setQueryString(nameValuePairs);
            }
            method = headMethod;
        } else {
            throw new AmazonClientException("Unknown HTTP method name: " + (Object)((Object)request.getMethodName()));
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            method.addRequestHeader(entry.getKey(), entry.getValue());
        }
        return method;
    }

    private <T> T handleResponse(HttpRequest request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpMethodBase method) throws IOException {
        HttpResponse httpResponse = this.createResponse(method, request);
        if (responseHandler.needsConnectionLeftOpen()) {
            httpResponse.setContent(new HttpMethodReleaseInputStream((HttpMethod)method));
        }
        try {
            CountingInputStream countingInputStream = null;
            if (unmarshallerPerformanceLog.isTraceEnabled()) {
                countingInputStream = new CountingInputStream(httpResponse.getContent());
                httpResponse.setContent(countingInputStream);
            }
            long startTime = System.currentTimeMillis();
            AmazonWebServiceResponse<T> awsResponse = responseHandler.handle(httpResponse);
            long endTime = System.currentTimeMillis();
            if (unmarshallerPerformanceLog.isTraceEnabled()) {
                unmarshallerPerformanceLog.trace((Object)(countingInputStream.getByteCount() + ", " + (endTime - startTime)));
            }
            if (awsResponse == null) {
                throw new RuntimeException("Unable to unmarshall response metadata");
            }
            this.responseMetadataCache.add(request.getOriginalRequest(), awsResponse.getResponseMetadata());
            requestLog.info((Object)("Received successful response: " + method.getStatusCode() + ", AWS Request ID: " + awsResponse.getRequestId()));
            return awsResponse.getResult();
        }
        catch (Exception e) {
            String errorMessage = "Unable to unmarshall response (" + e.getMessage() + "): " + method.getResponseBodyAsString();
            log.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, e);
        }
    }

    private AmazonServiceException handleErrorResponse(HttpRequest request, HttpResponseHandler<AmazonServiceException> errorResponseHandler, HttpMethodBase method) throws IOException {
        int status = method.getStatusCode();
        HttpResponse response = this.createResponse(method, request);
        if (errorResponseHandler.needsConnectionLeftOpen()) {
            response.setContent(new HttpMethodReleaseInputStream((HttpMethod)method));
        }
        AmazonServiceException exception = null;
        try {
            exception = errorResponseHandler.handle(response);
            requestLog.info((Object)("Received error response: " + exception.toString()));
        }
        catch (Exception e) {
            String errorMessage = "Unable to unmarshall error response (" + e.getMessage() + "): " + method.getResponseBodyAsString();
            log.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, e);
        }
        exception.setStatusCode(status);
        exception.setServiceName(request.getServiceName());
        exception.fillInStackTrace();
        return exception;
    }

    private HttpResponse createResponse(HttpMethodBase method, HttpRequest request) throws IOException {
        HttpResponse httpResponse = new HttpResponse(request);
        httpResponse.setContent(method.getResponseBodyAsStream());
        httpResponse.setStatusCode(method.getStatusCode());
        httpResponse.setStatusText(method.getStatusText());
        for (Header header : method.getResponseHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    private void pauseExponentially(int retries, AmazonServiceException previousException) {
        long scaleFactor = 300L;
        if (this.isThrottlingException(previousException)) {
            scaleFactor = 500 + this.random.nextInt(100);
        }
        long delay = (long)(Math.pow(2.0, retries) * (double)scaleFactor);
        delay = Math.min(delay, 20000L);
        log.debug((Object)("Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries));
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new AmazonClientException(e.getMessage(), e);
        }
    }

    private boolean isThrottlingException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        return "Throttling".equals(ase.getErrorCode());
    }

    private void configureHttpClient() {
        int socketReceiveBufferSizeHint;
        String userAgent = this.config.getUserAgent();
        if (!userAgent.equals(ClientConfiguration.DEFAULT_USER_AGENT)) {
            userAgent = userAgent + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        HttpClientParams httpClientParams = new HttpClientParams();
        httpClientParams.setParameter("http.useragent", (Object)userAgent);
        HostConfiguration hostConfiguration = new HostConfiguration();
        HttpConnectionManagerParams connectionManagerParams = new HttpConnectionManagerParams();
        connectionManagerParams.setConnectionTimeout(this.config.getConnectionTimeout());
        connectionManagerParams.setSoTimeout(this.config.getSocketTimeout());
        connectionManagerParams.setStaleCheckingEnabled(true);
        connectionManagerParams.setTcpNoDelay(true);
        connectionManagerParams.setMaxTotalConnections(this.config.getMaxConnections());
        connectionManagerParams.setMaxConnectionsPerHost(hostConfiguration, this.config.getMaxConnections());
        int socketSendBufferSizeHint = this.config.getSocketBufferSizeHints()[0];
        if (socketSendBufferSizeHint > 0) {
            connectionManagerParams.setSendBufferSize(socketSendBufferSizeHint);
        }
        if ((socketReceiveBufferSizeHint = this.config.getSocketBufferSizeHints()[1]) > 0) {
            connectionManagerParams.setReceiveBufferSize(socketReceiveBufferSizeHint);
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.setParams(connectionManagerParams);
        this.httpClient = new org.apache.commons.httpclient.HttpClient(httpClientParams, (HttpConnectionManager)connectionManager);
        String proxyHost = this.config.getProxyHost();
        int proxyPort = this.config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            log.info((Object)("Configuring Proxy. Proxy Host: " + proxyHost + " " + "Proxy Port: " + proxyPort));
            hostConfiguration.setProxy(proxyHost, proxyPort);
            String proxyUsername = this.config.getProxyUsername();
            String proxyPassword = this.config.getProxyPassword();
            if (proxyUsername != null && proxyPassword != null) {
                AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                this.httpClient.getState().setProxyCredentials(authScope, (Credentials)credentials);
            }
        }
        this.httpClient.setHostConfiguration(hostConfiguration);
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    static {
        String jvmVersion;
        requestLog = LogFactory.getLog((String)"com.amazonaws.request");
        log = LogFactory.getLog(HttpClient.class);
        unmarshallerPerformanceLog = LogFactory.getLog((String)"com.amazonaws.unmarshaller.performance");
        List<String> problematicJvmVersions = Arrays.asList("1.6.0_06", "1.6.0_13", "1.6.0_17");
        if (problematicJvmVersions.contains(jvmVersion = System.getProperty("java.version"))) {
            log.warn((Object)("Detected a possible problem with the current JVM version (" + jvmVersion + ").  " + "If you experience XML parsing problems using the SDK, try upgrading to a more recent JVM update."));
        }
    }
}

